/************************************************************************************/
/*	 TransBrow.c++																	*/
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
0 .. 3	Left Brow
4 .. 7	Right Brow
*/

PointNumber browControlPointNumber[8] = { 
	{6, 4}, {6, 6}, {6, 13}, {6, 10}, 
	{7, 4}, {7, 10}, {7, 13}, {7, 6},
};

PointNumber browReferencePointNumber[8][9] = { 
	{{18, 6}, {8, 16}, {18, 6}, {18, 10}, {8, 16}, {3, 1}, {0, 0}},
	{{8, 11}, {6, 20}, {6, 20}, {4, 31}, {4, 31}, {8, 8}, {8, 8}, {8, 11}, 
	{0, 0}},
	{{8, 11}, {6, 19}, {6, 19}, {3, 1}, {3, 1}, {8, 17}, {0, 0}},
	{{8, 8}, {4, 31}, {4, 31}, {3, 3}, {3, 3}, {8, 17}, {0, 0}},
	
	{{19, 6}, {8, 16}, {19, 6}, {19, 10}, {8, 16}, {3, 1}, {0, 0}},
	{{9, 8}, {5, 31}, {5, 31}, {3, 3}, {3, 3}, {8, 17}, {0, 0}},
	{{9, 11}, {7, 19}, {7, 19}, {3, 1}, {3, 1}, {8, 17}, {0, 0}},
	{{9, 11}, {7, 20}, {7, 20}, {5, 31}, {5, 31}, {9, 8}, {9, 8}, {9, 11}, 
	{0, 0}},
	
};

PointNumber browFollowingPointNumber[8][20] = { 
	{{8, 12}, {8, 13}, {8, 14}, {0, 0},
	{6, 5}, {0, 0},
	{6, 2}, {6, 3}, {0, 0}},
	{{6, 16}, {6, 17}, {6, 19}, {0, 0},
	{6, 15}, {4, 7}, {4, 8}, {4, 13}, {4, 14}, {0, 0},
	{6, 5}, {6, 14}, {0, 0},
	{8, 14}, {8, 15}, {0, 0}},
	{{6, 14}, {4, 6}, {0, 0},
	{4, 5}, {4, 10}, {4, 11}, {4, 12}, {0, 0},
	{6, 12}, {4, 4}, {0, 0}},
	{{8, 12}, {6, 2}, {6, 3}, {6, 11}, {6, 12}, 
	{4, 3}, {4, 4}, {4, 9}, {0, 0},
	{4, 2}, {0, 0},
	{6, 1}, {6, 9}, {4, 1}, {0, 0}},
	
	{{9, 12}, {9, 13}, {9, 14}, {0, 0},
	{7, 5}, {0, 0},
	{7, 2}, {7, 3}, {0, 0}},
	{{9, 12}, {7, 2}, {7, 3}, {7, 11}, {7, 12}, 
	{5, 3}, {5, 4}, {5, 9}, {0, 0},
	{5, 2}, {0, 0},
	{7, 1}, {7, 9}, {5, 1}, {0, 0}},
	{{7, 14}, {5, 6}, {0, 0},
	{5, 5}, {5, 10}, {5, 11}, {5, 12}, {0, 0},
	{7, 12}, {5, 4}, {0, 0}},
	{{7, 16}, {7, 17}, {7, 19}, {0, 0},
	{7, 15}, {5, 7}, {5, 8}, {5, 13}, {5, 14}, {0, 0},
	{7, 5}, {7, 14}, {0, 0},
	{9, 14}, {9, 15}, {0, 0}},
	
};

TransBrow::TransBrow(Wfm *wfm) : TransFace(wfm, 8)
{
	_controlPointNumber = browControlPointNumber;
	for (int i = 0; i < _n; i++){
		_referencePointNumber[i] = browReferencePointNumber[i];
		_followingPointNumber[i] = browFollowingPointNumber[i];
	}
	init();
}

void TransBrow::transform(int,int flag)
{
	for(int i = 0; i < _n; i++) affineTransform2D(i,flag);
	init();
}

