/************************************************************************************/
/*	 TransContour.c++																 */
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
0 ... 27 points on the contour line
*/

PointNumber contourControlPointNumber[28] = { 
	// 0: top
	{18, 19},
		// 1-7: left side
	{18, 6}, {18, 7}, {18, 8}, {18, 9}, {18, 10}, {18, 11}, {18, 12}, 
	// 8-13: left chin
	{18, 13}, {18, 14}, {18, 15}, {18, 16}, {18, 17}, {18, 18}, 
	// 14: bottom
	{18, 20},
	// 15-20: right chin
	{19, 18}, {19, 17}, {19, 16}, {19, 15}, {19, 14}, {19, 13}, 
	// 21-27: right side
	{19, 12}, {19, 11}, {19, 10}, {19, 9}, {19, 8}, {19, 7}, {19, 6}
};

PointNumber contourReferencePointNumber[28][3] = { 
	// top (18-19)
	{{18, 7}, {19, 7}, {0, 0}},
		
		// left side
		//(18-6)
	{{18, 19}, {8, 17}, {0, 0}},
	//(18-7)
	{{8, 17}, {6, 22}, {0, 0}},
	//(18-8)
	{{6, 22}, {3, 1}, {0, 0}},
	//(18-9)
	{{3, 1}, {3, 5}, {0, 0}},
	//(18-10)
	{{3, 5}, {3, 15}, {0, 0}},
	//(18-11)
	{{3, 15}, {12, 17}, {0, 0}},
	//(18-12)
	{{12, 17}, {1, 40}, {0, 0}},
	
	// left chin
	// (18-13)
	{{1, 33}, {1, 40}, {0, 0}},
	// (18-14)
	{{1, 33}, {1, 40}, {0, 0}},
	// (18-15)
	{{1, 33}, {1, 40}, {0, 0}},
	// (18-16)
	{{1, 33}, {1, 40}, {0, 0}},
	// (18-17)
	{{1, 33}, {1, 40}, {0, 0}},
	// (18-18)
	{{1, 33}, {2, 33}, {0, 0}},
	
	// bottom (18-20)
	{{1, 33}, {2, 33}, {0, 0}},
	
	// right chin
	// (19-18)
	{{1, 33}, {2, 33}, {0, 0}},
	// (19-17)
	{{2, 33}, {1, 40}, {0, 0}},
	// (19-16)
	{{2, 33}, {1, 40}, {0, 0}},
	// (19-15)
	{{2, 33}, {1, 40}, {0, 0}},
	// (19-14)
	{{2, 33}, {1, 40}, {0, 0}},
	// (19-13)
	{{2, 33}, {1, 40}, {0, 0}},
	
	// right side
	// (19-12)
	{{12, 17}, {1, 40}, {0, 0}},
	// (19-11)
	{{3, 15}, {12, 17}, {0, 0}},
	// (19-10)
	{{3, 5}, {3, 15}, {0, 0}},
	// (19-9)
	{{3, 1}, {3, 5}, {0, 0}},
	// (19-8)
	{{6, 22}, {3, 1}, {0, 0}},
	// (19-7)
	{{8, 17}, {6, 22}, {0, 0}},
	// (19-6)
	{{18, 19}, {8, 17}, {0, 0}}
};

PointNumber contourFollowingPointNumber[28][50] = { 
	// top (18-19)
	{{18, 1}, {18, 2}, {18, 3}, {18, 4}, {18, 5}, {18, 6}, 
	{8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 6}, 
	{8, 7}, {8, 8}, {8, 9}, {8, 10}, {8, 11},
	{8, 16}, {8, 17},
	{9, 1}, {9, 2}, {9, 3}, {9, 4}, {9, 5}, {9, 6}, 
	{9, 7}, {9, 8}, {9, 9}, {9, 10}, {9, 11},
	{19, 1}, {19, 2}, {19, 3}, {19, 4}, {19, 5}, {19, 6}, {0, 0}},
	
	// left side
	// (18-6)
	{{18, 1}, {18, 2}, {18, 3}, {18, 4}, {18, 5},
	{8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {0, 0}},
	// (18-7)
	{{8, 6}, {8, 7}, {8, 8}, {8, 9}, {8, 10}, {8, 11},
	{8, 12}, {8, 13}, {8, 14}, {8, 15}, {6, 8}, {0, 0}},
	// (18-8)
	{{6, 1}, {6, 2}, {6, 3}, {6, 4}, {6, 5}, {6, 6}, {6, 7}, {6, 8}, 
	{6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6, 15}, {6, 16}, 
	{6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, 
	{4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {4, 7}, {4, 8},
	{4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 16},
	{4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {0, 0}},
	// (18-9)
	{{6, 20}, {6, 21},
	{4, 23}, {4, 24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30},
	{4, 31}, {4, 32}, {4, 33}, {0, 0}},
	// (18-10)
	{{10, 1}, {10, 2}, {10, 3}, {10, 4}, {10, 5}, {10, 6}, {10, 7}, {10, 8},
	{3, 2}, {3, 6}, {3, 9}, {3, 10}, {3, 13}, {3, 14}, {0, 0}},
	// (18-11)
	{{10, 9}, {10, 10}, {10, 11}, {10, 12}, {10, 13}, 
	{3, 18}, {3, 19}, {3, 23}, {3, 24},
	{12, 1}, {12, 2}, {12, 3}, {12, 4}, {12, 5}, {12, 6}, {12, 7}, {12, 8},
	{0, 0}},
	// (18-12)
	{{10, 14}, {10, 15}, {10, 16}, 
	{14, 1}, {14, 2},
	{12, 9}, {12, 10}, {12, 11}, {12, 16}, 
	{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, 
	{1, 9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, 
	{1, 17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, 
	{1, 25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {1, 31}, {1, 32}, 
	{1, 33}, {0, 0}},
	
	// left chin
	// (18-13)
	{{12, 16}, {14, 1}, {14, 5}, {16, 6}, {0, 0}},
	// (18-14)
	{{12, 15}, {14, 4}, {16, 5}, {0, 0}},
	// (18-15)
	{{14, 3}, {14, 7}, {14, 8}, {12, 14}, {16, 4}, {0, 0}},
	// (18-16)
	{{14, 6}, {14, 11}, {12, 13}, {16, 3}, {0, 0}},
	// (18-17)
	{{14, 10}, {14, 13}, {12, 12}, {16, 2}, {0, 0}},
	// (18-18)
	{{14, 9}, {14, 12}, {16, 1}, {0, 0}},
	
	// bottom (18-20)
	{{14, 14}, {14, 15}, {12, 18}, {16, 15}, {0, 0}},
	
	// right chin
	// (19-18)
	{{15, 9}, {15, 12}, {17, 1}, {0, 0}},
	// (19-17)
	{{15, 10}, {15, 13}, {13, 12}, {17, 2}, {0, 0}},
	// (19-16)
	{{15, 6}, {15, 11}, {13, 13}, {17, 3}, {0, 0}},
	// (19-15)
	{{15, 3}, {15, 7}, {15, 8}, {13, 14}, {17, 4}, {0, 0}},
	// (19-14)
	{{13, 15}, {15, 4}, {17, 5}, {0, 0}},
	// (19-13)
	{{13, 16}, {15, 1}, {15, 5}, {17, 6}, {0, 0}},
	
	// right side
	// (19-12)
	{{11, 14}, {11, 15}, {11, 16}, 
	{15, 1}, {15, 2},
	{13, 9}, {13, 10}, {13, 11}, {13, 16}, 
	{2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {2, 7}, {2, 8}, 
	{2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 13}, {2, 14}, {2, 15}, {2, 16}, 
	{2, 17}, {2, 18}, {2, 19}, {2, 20}, {2, 21}, {2, 22}, {2, 23}, {2, 24}, 
	{2, 25}, {2, 26}, {2, 27}, {2, 28}, {2, 29}, {2, 30}, {2, 31}, {2, 32}, 
	{2, 33}, {0, 0}},
	// (19-11)
	{{11, 9}, {11, 10}, {11, 11}, {11, 12}, {11, 13}, 
	{3, 21}, {3, 22}, {3, 26}, {3, 27},
	{13, 1}, {13, 2}, {13, 3}, {13, 4}, {13, 5}, {13, 6}, {13, 7}, {13, 8},
	{0, 0}},
	// (19-10)
	{{11, 1}, {11, 2}, {11, 3}, {11, 4}, {11, 5}, {11, 6}, {11, 7}, {11, 8},
	{3, 4}, {3, 8}, {3, 11}, {3, 12}, {3, 16}, {3, 17}, {0, 0}},
	// (19-9)
	{{7, 20}, {7, 21},
	{5, 23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30},
	{5, 31}, {5, 32}, {5, 33}, {0, 0}},
	// (19-8)
	{{7, 1}, {7, 2}, {7, 3}, {7, 4}, {7, 5}, {7, 6}, {7, 7}, {7, 8}, 
	{7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 15}, {7, 16}, 
	{7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, 
	{5, 1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {5, 7}, {5, 8},
	{5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 15}, {5, 16},
	{5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {0, 0}},
	// (19-7)
	{{9, 6}, {9, 7}, {9, 8}, {9, 9}, {9, 10}, {9, 11},
	{9, 12}, {9, 13}, {9, 14}, {9, 15}, {7, 8}, {0, 0}},
	// (19-6)
	{{19, 1}, {19, 2}, {19, 3}, {19, 4}, {19, 5},
	{9, 1}, {9, 2}, {9, 3}, {9, 4}, {9, 5}, {0, 0}}
};

TransContour::TransContour(Wfm *wfm) : TransFace(wfm, 28)
{
	_controlPointNumber = contourControlPointNumber;
	for(int i = 0; i < _n; i++){
		_referencePointNumber[i] = contourReferencePointNumber[i];
		_followingPointNumber[i] = contourFollowingPointNumber[i];
	}
	init();
}

void TransContour::transform(int,int flag)
{
	Matrix P0(3, 3), P1(3, 3), T(3, 3);
	for(int i = 0; i < _n; i++) affineTransform2D(i,flag);
	init();
}

