/************************************************************************************/
/*	 TransEye.c++																	 */
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
0 .. 4	Left Eye
5 .. 9	Right Eye
*/

const int leftEyeGroup = 4, rightEyeGroup = 5;
const int leftEyeballGroup = 20, rightEyeballGroup = 21;
const int leftEyeGroupPoints = 35, rightEyeGroupPoints = 34;
const int eyeballGroupPoints = 25;
const int eyeSide1 = 17, eyeSide2 = 23;
const int eyeballSide1 = 20, eyeballSide2 = 24;

PointNumber eyeControlPointNumber[10] = { 
	{4, 20}, {4, 23}, {4, 27}, {4, 17}, {20, 1},
	{5, 20}, {5, 17}, {5, 27}, {5, 23}, {21, 1}	
};


PointNumber eyeReferencePointNumber[10][5] = { 
	{{4, 17}, {4, 23}, {18, 7}, {8, 18}, {0, 0}},
	{{4, 31}, {4, 20}, {18, 8}, {18, 10}, {0, 0}},
	{{4, 23}, {4, 17}, {0, 0}},
	{{4, 26}, {4, 20}, {6, 23}, {3, 3}, {0, 0}},
	{{0, 0}},
	
	{{5, 17}, {5, 23}, {19, 7}, {8, 18}, {0, 0}},
	{{5, 26}, {5, 20}, {6, 23}, {3, 3}, {0, 0}},
	{{5, 23}, {5, 17}, {0, 0}},
	{{5, 31}, {5, 20}, {19, 8}, {19, 10}, {0, 0}},
	{{0, 0}}
};

PointNumber eyeFollowingPointNumber[10][20] = { 
	{{4, 18}, {4, 19}, {4, 21}, {4, 22}, {0, 0},
	{4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {0, 0}},
	{{4, 28}, {4, 21}, {4, 22}, {0, 0},
	{4, 15}, {4, 34}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {0, 0}},
	{{4, 26}, {4, 28}, {4, 24}, {4, 25}, {0, 0}},
	{{4, 24}, {4, 25}, {4, 26}, {4, 18}, {4, 19}, {0, 0},
	{4, 1}, {4, 2}, {4, 16}, {4, 29}, {0, 0}},
	{{0, 0}},
	
	{{5, 18}, {5, 19}, {5, 21}, {5, 22}, {0, 0},
	{5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {0, 0}},
	{{5, 24}, {5, 25}, {5, 26}, {5, 18}, {5, 19}, {0, 0},
	{5, 1}, {5, 2}, {5, 16}, {5, 29}, {0, 0}},
	{{5, 26}, {5, 28}, {5, 24}, {5, 25}, {0, 0}},
	{{5, 28}, {5, 21}, {5, 22}, {0, 0},
	{5, 15}, {5, 34}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {0, 0}},
	{{0, 0}}
};

TransEye::TransEye(Wfm *wfm) : TransFace(wfm, 10)
{
	_controlPointNumber = eyeControlPointNumber;
	for(int i = 0; i < _n; i++){
		_referencePointNumber[i] = eyeReferencePointNumber[i];
		_followingPointNumber[i] = eyeFollowingPointNumber[i];
	}
	init();
}

void TransEye::transform(int,int flag)
{
	int i;
	// Transform edge of left eye 
	for(i = 0; i < 4; i++) affineTransform2D(i,flag);
	
	// Transform left eye ball
	transformEyeball(4, leftEyeGroup, leftEyeballGroup);
	
	// Transform edge of right eye
	for(i = 5; i < 9; i++) affineTransform2D(i ,flag);
	
	// Transform right eye ball
	transformEyeball(9, rightEyeGroup, rightEyeballGroup);
	
	init();
}

// Transform eye ball
void TransEye::transformEyeball(int eyeballControlPoint, 
								int eyeGroup, 
								int eyeballGroup)
{
	Affine T0, T1;
	
	// Translate to the origin
	Point origin0 = (wfmPoint(eyeballGroup, eyeballSide1) 
		+ wfmPoint(eyeballGroup, eyeballSide2)) / 2.0;
	Point origin1 = (wfmPoint(eyeGroup, eyeSide1) 
		+ wfmPoint(eyeGroup, eyeSide2)) / 2.0;
	
	// This determines z position of the eye balls. 0.4 to 1.0 are suitable.
	origin1.z() -= 0.5
		* distance(wfmPoint(eyeGroup, eyeSide1), wfmPoint(eyeGroup, eyeSide2));
	T0 = translate(-origin0.x(), -origin0.y(), -origin0.z());
	T1 = translate(-origin1.x(), -origin1.y(), -origin1.z());
	Point center0 = T0 * controlPoint0(eyeballControlPoint);
	Point center1 = T1 * controlPoint1(eyeballControlPoint);
	
	// Calculate theta (rotation about Y axis)
	double l0 = sqrt(center0.x() * center0.x() + center0.z() * center0.z());
	double theta0 = 0.0;
	if (l0 > 0.0) theta0 = asin(center0.x() / l0);
	double l1 = sqrt(center1.x() * center1.x() + center1.z() * center1.z());
	double theta1;
	if (l1 > 0.0) theta1 = asin(center1.x() / l1);
	else theta1 = 0.0;
	T0 = rotateY(-theta0) * T0;
	T1 = rotateY(-theta1) * T1;
	
	// Calculate phi (rotation about X axis)
	l0 = length(center0);
	double phi0 = 0.0;
	if (l0 > 0.0) {
		Point c0 = T0 * controlPoint0(eyeballControlPoint);
		phi0 = asin(c0.y() / l0);
	}
	l1 = length(center1);
	double phi1 = 0.0;
	if (l1 > 0.0) {
		Point c1 = T1 * controlPoint1(eyeballControlPoint);
		phi1 = asin(c1.y() / l1);
	}
	T0 = rotateX(phi0) * T0;
	T1 = rotateX(phi1) * T1;
	
	// Transform all of the points of left eye
	Affine T;
	T = inv(T1) * T0;
	transformGroupPoints(T, eyeballGroup, eyeballGroupPoints);
}

TransEyeFine::TransEyeFine(Wfm *wfm) 
: TransFace(wfm, leftEyeGroupPoints + rightEyeGroupPoints)
{
	_controlPointNumber = new PointNumber[_n];
	int i, n;
	for (i = 0, n = 0; i < leftEyeGroupPoints; i++) {
		_controlPointNumber[n].gn = leftEyeGroup;
		_controlPointNumber[n].pn = i + 1;
		n++;
	}
	for (i = 0; i < rightEyeGroupPoints; i++) {
		_controlPointNumber[n].gn = rightEyeGroup;
		_controlPointNumber[n].pn = i + 1;
		n++;
	}
	init();
}

void TransEyeFine::transform(int,int)
{
	for(int i = 0; i < _n; i++) setWfmPoint(_controlPointNumber[i], controlPoint1(i));
	init();
}
