/************************************************************************************/
/*   TransFace.c++																  */
/*	  t-misawa	Version 1998.09.28											  */
/************************************************************************************/

#include "TransFace.h"
#include <assert.h>

TransFace::TransFace(Wfm *wfm, int n)
{
	_wfm = wfm;
	_n = n;
	_controlPoint = new Point[_n];
	_controlPointNumber = NULL;
	_referencePointNumber = new PointNumber*[_n];
	_followingPointNumber = new PointNumber*[_n];
}

TransFace::~TransFace()
{
	delete []_controlPoint;
	/*
	for(int i = 0; i < _n; i++){
	delete [] _referencePointNumber[i]; 
	delete [] _followingPointNumber[i]; 
	}
	*/
	delete [] _referencePointNumber;
	delete [] _followingPointNumber;
}

void TransFace::init()
{
	for (int i = 0; i < _n; i++) {
		Point p = controlPoint0(i);
		setControlPoint(i, p);
	}
}

Point TransFace::wfmPoint(int n)
{
	Point result(_wfm->Sgridx(n), _wfm->Sgridy(n), _wfm->Sgridz(n));
	return result;
}

Point TransFace::wfmPoint(int i, int j)
{
	Point result(_wfm->Ggridx(i, j), _wfm->Ggridy(i, j), _wfm->Ggridz(i, j));
	return result;
}

Point TransFace::wfmPoint(const PointNumber& n)
{
	Point result(_wfm->Ggridx(n.gn, n.pn), _wfm->Ggridy(n.gn, n.pn), _wfm->Ggridz(n.gn, n.pn));
	return result;
}

void TransFace::transformWfm(const Affine& T)
{
	Point a, b;
	for (int i = 1; i <= _wfm->grn(); i++){
		a = wfmPoint(i);
		b = T * a;
		setWfmPoint(i, b);
	}
}

void TransFace::affineTransform2D(int i, int flag)
{
	Matrix P0(3, 3), P1(3, 3), T(3, 3);
	Point a, b;
	Vector a3(3), b3(3);
	int j = 0, k = 0;
	
	if(!flag) {
		while (_referencePointNumber[i][j*2].pn != 0) {
			P0[0][0] = controlPoint0(i).x();
			P0[1][0] = controlPoint0(i).y();
			P0[2][0] = 1.0;
			P0[0][1] = referencePoint(i, j, 0).x();
			P0[1][1] = referencePoint(i, j, 0).y();
			P0[2][1] = 1.0;
			P0[0][2] = referencePoint(i, j, 1).x();
			P0[1][2] = referencePoint(i, j, 1).y();
			P0[2][2] = 1.0;
			
			P1[0][0] = controlPoint1(i).x();
			P1[1][0] = controlPoint1(i).y();
			P1[2][0] = 1.0;
			P1[0][1] = referencePoint(i, j, 0).x();
			P1[1][1] = referencePoint(i, j, 0).y();
			P1[2][1] = 1.0;
			P1[0][2] = referencePoint(i, j, 1).x();
			P1[1][2] = referencePoint(i, j, 1).y();
			P1[2][2] = 1.0;
			
			T = P1 * inv(P0);
			
			a3[2] = 1.0;
			b[3] = 1.0;
			while (_followingPointNumber[i][k].pn != 0) {
				a = wfmPoint(_followingPointNumber[i][k]);
				a3[0] = a.x();
				a3[1] = a.y();
				b3 = T * a3;
				b[0] = b3[0];
				b[1] = b3[1];
				b[2] = a.z();
				setWfmPoint(_followingPointNumber[i][k], b);
				k++;
			}
			j++;
			k++;
		}
	}
	else {
		while (_referencePointNumber[i][j*2].pn != 0) {
			P0[0][0] = 1.0;
			P0[1][0] = controlPoint0(i).y();
			P0[2][0] = controlPoint0(i).z();
			P0[0][1] = 1.0;
			P0[1][1] = referencePoint(i, j, 0).y();
			P0[2][1] = referencePoint(i, j, 0).z();
			P0[0][2] = 1.0;
			P0[1][2] = referencePoint(i, j, 1).y();
			P0[2][2] = referencePoint(i, j, 1).z();
			
			P1[0][0] = 1.0;
			P1[1][0] = controlPoint1(i).y();
			P1[2][0] = controlPoint1(i).z();
			P1[0][1] = 1.0;
			P1[1][1] = referencePoint(i, j, 0).y();
			P1[2][1] = referencePoint(i, j, 0).z();
			P1[0][2] = 1.0;
			P1[1][2] = referencePoint(i, j, 1).y();
			P1[2][2] = referencePoint(i, j, 1).z();
			
			T = P1 * inv(P0);
			
			a3[2] = 1.0;
			b[3] = 1.0;
			while (_followingPointNumber[i][k].pn != 0) {
				a = wfmPoint(_followingPointNumber[i][k]);
				a3[1] = a.y();
				a3[2] = a.z();
				b3 = T * a3;
				b[0] = a.x();
				b[1] = b3[1];
				b[2] = b3[2];
				setWfmPoint(_followingPointNumber[i][k], b);
				k++;
			}
			j++; k++;
		}
	}
	
	setWfmPoint(_controlPointNumber[i], controlPoint1(i));
}


void TransFace::linearTransform(int i)
{
	Point t = controlPoint1(i) - controlPoint0(i);
	Point r = (referencePoint(i, 0, 0) + referencePoint(i, 0, 1)) / 2.0;
	double d = distance(controlPoint0(i), r);
	
	Point a, b;
	double f;
	int k = 0;
	while (_followingPointNumber[i][k].pn != 0) {
		a = wfmPoint(_followingPointNumber[i][k]);
		f = 1.0 - distance(controlPoint0(i), a) / d;
		if (f < 0.0) f = 0.0;
		b = a + t * f;
		setWfmPoint(_followingPointNumber[i][k], b);
		k++;
	}
	setWfmPoint(_controlPointNumber[i], controlPoint1(i));
}

void TransFace::transformFollowingPoints(const Matrix& T, int n)
{
	Point a, b;
	int i = 0;
	while (_followingPointNumber[n][i].pn != 0) {
		a = wfmPoint(_followingPointNumber[n][i]);
		b = T * a;
		setWfmPoint(_followingPointNumber[n][i], b);
		i++;
	}
}

void TransFace::transformGroupPoints(const Matrix& T, int g, int n)
{
	Point a, b;
	for (int i = 1; i <= n; i++) {
		a = wfmPoint(g, i);
		b = T * a;
		setWfmPoint(g, i, b);
	}
}

void TransFace::setWfmPoint(const PointNumber& n, const Point& p)
{
	_wfm->Ggridx(n.gn, n.pn) = p.x();
	_wfm->Ggridy(n.gn, n.pn) = p.y();
	_wfm->Ggridz(n.gn, n.pn) = p.z();
}

void TransFace::setWfmPoint(int g, int n, const Point& p)
{
	_wfm->Ggridx(g, n) = p.x();
	_wfm->Ggridy(g, n) = p.y();
	_wfm->Ggridz(g, n) = p.z();
	
}

void TransFace::setWfmPoint(int n, const Point& p)
{
	_wfm->Sgridx(n) = p.x();
	_wfm->Sgridy(n) = p.y();
	_wfm->Sgridz(n) = p.z();
}

