/************************************************************************************/
/*	 TransHead.c++																	*/
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
//#include "MFunction.h" delete by shin 2001/11/23. function in WFM. 
#include <math.h>
#include <limits.h>

/*
--- Control points ---
//	 0 left end of left eye
//	 1 right end of right eye
0 left end of face
1 right end of face
2 top of nose
3 bottom of chin
*/

PointNumber headControlPointNumber[4] = { 
	//	{4, 23}, {5, 23}, {3, 15}, {18, 20}
	{18, 9}, {19, 9}, {3, 25}, {18, 20}
};

PointNumber headReferencePointNumber[4][3] = {
	{{0, 0}},
	{{0, 0}},
	{{0, 0}},
	{{18, 11}, {19, 11}, {0, 0}}
};

PointNumber headFollowingPointNumber[4][100] = {
	{{0, 0}},
	{{0, 0}},
	{{0, 0}},
	{{10, 16}, {11, 16},
	{12, 12}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, 
	{12, 18}, 
	{13, 12}, {13, 13}, {13, 14}, {13, 15}, {13, 16},
	{14, 1}, {14, 2}, {14, 3}, {14, 4}, {14, 5}, {14, 6}, {14, 7}, {14, 8}, 
	{14, 9}, {14, 10}, {14, 11}, {14, 12}, {14, 13}, 
	{14, 14}, {14, 15},
	{15, 1}, {15, 2}, {15, 3}, {15, 4}, {15, 5}, {15, 6}, {15, 7}, {15, 8},
	{15, 9}, {15, 10}, {15, 11}, {15, 12}, {15, 13}, 
	{18, 12}, {18, 13}, {18, 14}, {18, 15}, {18, 16}, {18, 17}, {18, 18}, 
	{18, 20},
	{19, 12}, {19, 13}, {19, 14}, {19, 15}, {19, 16}, {19, 17}, {19, 18}, 
	{16, 1}, {16, 2}, {16, 3}, {16, 4}, {16, 5}, {16, 6}, {16, 7}, {16, 8},
	{16, 9}, {16, 10}, {16, 11}, {16, 12}, {16, 13}, {16, 14}, 
	{16, 15}, {16, 16}, {16, 17},
	{17, 1}, {17, 2}, {17, 3}, {17, 4}, {17, 5}, {17, 6}, {17, 7}, {17, 8},
	{17, 9}, {17, 10}, {17, 11}, {17, 12}, {17, 13}, {17, 14},
	{0, 0}}
};

/************************************************************************************/
TransHead::TransHead(Wfm *wfm) : TransFace(wfm, 4)
{
	_controlPointNumber = headControlPointNumber;
	for(int i = 0; i < _n; i++){
		_referencePointNumber[i] = headReferencePointNumber[i];
		_followingPointNumber[i] = headFollowingPointNumber[i];
	}
	init();
}

/************************************************************************************/
void TransHead::transform(int,int flag)
{	
	Affine T0, T1;
	
	// Translation
	Point center0 = (controlPoint0(0) + controlPoint0(1)) / 2.0;
	Point center1 = (controlPoint1(0) + controlPoint1(1)) / 2.0;
	T0 = translate(-center0.x(), -center0.y(), -center0.z());
	T1 = translate(-center1.x(), -center1.y(), -center1.z());
	
	// Rotation about Z axis
	Point v0 = controlPoint0(1) - controlPoint0(0);
	Point v1 = controlPoint1(1) - controlPoint1(0);
	v0.z() = v1.z() = 0.0; 
	double angleZ0 = 0.0, angleZ1;
	if(length(v0) > 0.0) angleZ0 = asin(v0.y() / length(v0));
	if(length(v1) > 0.0) angleZ1 = asin(v1.y() / length(v1));
	else angleZ1 = angleZ0;
	T0 = rotateZ(-angleZ0) * T0;
	T1 = rotateZ(-angleZ1) * T1;
	
	// Limit the control point of the top of nose
	v0 = T0 * controlPoint0(2);
	v1 = T1 * controlPoint1(2);
	if (v1.y() > -0.05) {
		controlPoint1(2).y() = center1.y() - 0.05;
		v1 = T1 * controlPoint1(2);
	}
	
	// Scaling
	double scaleX = 1.0;
	v0 = T0 * (controlPoint0(1) - controlPoint0(0));
	v1 = T1 * (controlPoint1(1) - controlPoint1(0));
	if (v0.x() > 0.0) scaleX = v1.x() / v0.x();
	double scaleY = 1.0;
	v0 = T0 * (center0 - controlPoint0(2));
	v1 = T1 * (center1 - controlPoint1(2));
	if (v0.y() > 0.0) scaleY = v1.y() / v0.y();
	
	T0 = scale(scaleX, scaleY, scaleX) * T0;
	
	// Affine transform
	transformWfm(T0);
	Point cp3 = T0 * controlPoint1(3);
	setControlPoint(3, cp3);
	
	// Chin transformation
	affineTransform2D(3,0);
	
	// Affine transform
	transformWfm(inv(T1));
	
	init();
}

