/************************************************************************************/
/*	 TransMouth.c++																 */
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
*/

const int leftLipGroup = 1, rightLipGroup = 2;
const int leftLipGroupPoints = 40, rightLipGroupPoints = 33;

PointNumber mouthControlPointNumber[6] = { 
	{1, 34}, {1, 33}, {1, 40}, {2, 33}, {1, 36}, {1, 37}
};

PointNumber mouthReferencePointNumber[6][5] = { 
	{{3, 25}, {10, 9}, {3, 25}, {11, 9}, {0, 0}},
	{{10, 11}, {14, 8}, {0, 0}},
	{{14, 15}, {14, 4}, {14, 15}, {15, 4}, {0, 0}},
	{{11, 11}, {15, 8}, {0, 0}},
	{{0, 0}},
	{{0, 0}}
};

PointNumber mouthFollowingPointNumber[6][45] = { 
	{{12, 1}, {12, 2}, {12, 3}, {12, 4}, {12, 17}, {0, 0},
	{13, 1}, {13, 2}, {13, 3}, {13, 4}, {0, 0}},
	{{12, 7}, {12, 8}, {12, 9}, {12, 10}, {12, 11}, {12, 14}, 
	{12, 15}, {12, 16}, {14, 3}, {0, 0}},
	{{12, 12}, {12, 13}, {12, 18}, {14, 6}, {14, 9}, {14, 14}, {0, 0},
	{13, 12}, {13, 13}, {15, 6}, {15, 9}, {0, 0}},
	{{13, 7}, {13, 8}, {13, 9}, {13, 10}, {13, 11}, {13, 14}, 
	{13, 15}, {13, 16}, {15, 3}, {0, 0}},
	{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, 
	{1, 6}, {1, 7}, {1, 8}, {1, 9}, {1, 10}, {1, 35}, 
	{1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 36}, 
	{2, 1}, {2, 2}, {2, 3}, {2, 4}, {2, 5},
	{2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, 
	{2, 11}, {2, 12}, {2, 13}, {2, 14}, {1 , 34}, {0, 0}},
	{{1, 15}, {1, 16}, {1, 17}, {1, 18}, {1, 37},
	{1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 38},
	{1, 23}, {1, 24}, {1, 25}, {1, 26}, {1, 27}, {1, 39},
	{1, 28}, {1, 29}, {1, 30}, {1, 31}, {1, 32}, {1 , 40}, 
	{2, 15}, {2, 16}, {2, 17}, {2, 18},
	{2, 19}, {2, 20}, {2, 21}, {2, 22}, 
	{2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, 
	{2, 28}, {2, 29}, {2, 30}, {2, 31}, {2, 32}, {0, 0}},
};

TransMouth::TransMouth(Wfm *wfm) : TransFace(wfm, 6)
{
	_controlPointNumber = mouthControlPointNumber;
	for(int i = 0; i < _n; i++){
		_referencePointNumber[i] = mouthReferencePointNumber[i];
		_followingPointNumber[i] = mouthFollowingPointNumber[i];
	}
	init();
}

void TransMouth::transform(int,int flag)
{
	// Transform lips
	transformLip(flag);
	
	// Transform other points
	for(int i = 0; i < 4; i++) affineTransform2D(i,flag);
	init();
}

// Transform lip points
void TransMouth::transformLip(int flag) 
{
	Affine T0, T1;
	
	Point center0 = (controlPoint0(1) + controlPoint0(3)) / 2.0;
	Point center1 = (controlPoint1(1) + controlPoint1(3)) / 2.0;
	T0 = translate(-center0.x(), -center0.y(), -center0.z());
	T1 = translate(-center1.x(), -center1.y(), -center1.z());
	
	if(!flag){
		
		Point v0 = controlPoint0(3) - center0;
		v0.z() = 0.0;
		if (length(v0) > 0.0) {
			double angle0 = asin(v0.y() / length(v0));
			T0 = rotateZ(- angle0) * T0;
		}
		Point v1 = controlPoint1(3) - center1;
		v1.z() = 0.0;
		if (length(v1) > 0.0) {
			double angle1 = asin(v1.y() / length(v1));
			T1 = rotateZ(- angle1) * T1;
		}
		Affine invT1 = inv(T1);
		
		Point left0 = T0 * controlPoint0(1);
		Point left1 = T1 * controlPoint1(1);
		Point right0 = T0 * controlPoint0(3);
		Point right1 = T1 * controlPoint1(3);
		
		int n;
		for (n = 0; n <= 1; n++) {
			Point outer0 = T0 * controlPoint0(n*2); // control point 0,2
			Point outer1 = T1 * controlPoint1(n*2);
			Point inner0 = T0 * controlPoint0(n+4); // control point 4,6
			Point inner1 = T1 * controlPoint1(n+4);
			
			double a0, a1, b0, b1;
			a0 = right0.x();
			if (a0 > 0.0) b0 = - inner0.y() / (a0 * a0);
			else b0 = 0.0;
			a1 = right1.x();
			if (a1 > 0.0) b1 = - inner1.y() / (a1 * a1);
			else b1 = 0.0;
			
			Matrix P0(3, 3), P1(3, 3), T(3, 3);
			
			P0[0][0] = outer0.x();
			P0[1][0] = outer0.y() - b0 * (outer0.x() + a0) * (outer0.x() - a0);
			P0[2][0] = 1.0;
			P0[0][1] = left0.x();
			P0[1][1] = left0.y();
			P0[2][1] = 1.0;
			P0[0][2] = right0.x();
			P0[1][2] = right0.y();
			P0[2][2] = 1.0;
			
			P1[0][0] = outer1.x();
			P1[1][0] = outer1.y() - b1 * (outer1.x() + a1) * (outer1.x() - a1);
			P1[2][0] = 1.0;
			P1[0][1] = left1.x();
			P1[1][1] = left1.y();
			P1[2][1] = 1.0;
			P1[0][2] = right1.x();
			P1[1][2] = right1.y();
			P1[2][2] = 1.0;
			
			T = P1 * inv(P0);
			
			Vector a3(3), b3(3);
			a3[2] = 1.0;
			int i = 0;
			while (_followingPointNumber[n+4][i].pn != 0) {
				Point p = T0 * wfmPoint(_followingPointNumber[n+4][i]);
				p.y() -= b0 * (p.x() + a0) * (p.x() - a0);
				a3[0] = p.x();
				a3[1] = p.y();
				b3 = T * a3;
				p.x() = b3[0];
				p.y() = b3[1];
				p.y() += b1 * (p.x() + a1) * (p.x() - a1);
				p = invT1 * p;
				setWfmPoint(_followingPointNumber[n+4][i], p);
				i++;
			}	
		}	
	}
	else{
		int n;
		
		for(int i = 0; i <= 1; i++){
			for (n = 0; n <= 1; n++){
				
				Point right0;
				Point right1;
				right0 = controlPoint0(i*2+1);
				right1 = controlPoint1(i*2+1);
				// Move inner lip
				Point outer0 = controlPoint0(n*2);
				Point outer1 = controlPoint1(n*2);
				Point inner0 = controlPoint0(n+4);
				Point inner1 = controlPoint1(n+4);
				
				Matrix P0(3, 3), P1(3, 3), T(3, 3);
				
				P0[0][0] = 1.0;
				
				if(n == 0)	
					P0[1][0] = outer0.y()+0.06;
				if(n == 1)	
					P0[1][0] = outer0.y()-0.06;
				
				P0[2][0] = outer0.z();
				P0[0][1] = 1.0;
				
				if(n == 0)	
					P0[1][1] = inner0.y()-0.06;
				if(n == 1)	
					P0[1][1] = inner0.y()+0.06;
				
				P0[2][1] = inner0.z();
				P0[0][2] = 1.0;
				P0[1][2] = right0.y();
				P0[2][2] = right0.z()-0.05;
				
				P1[0][0] = 1.0;
				
				if(n == 0)	
					P1[1][0] = outer1.y()+0.06;
				if(n == 1)	
					P1[1][0] = outer1.y()-0.06;
				
				P1[2][0] = outer1.z();
				P1[0][1] = 1.0;
				
				if(n == 0)	
					P1[1][1] = inner1.y()-0.06;
				if(n == 1)	
					P1[1][1] = inner1.y()+0.06;
				
				P1[2][1] = inner1.z();
				P1[0][2] = 1.0;
				P1[1][2] = right1.y();
				P1[2][2] = right1.z()-0.05;
				
				T = P1 * inv(P0);
				
				Vector a3(3), b3(3);
				a3[0] = 1.0;
				int i = 0;
				while (_followingPointNumber[n+4][i].pn != 0) {
					Point p = wfmPoint(_followingPointNumber[n+4][i]);
					a3[1] = p.y();
					a3[2] = p.z();
					b3 = T * a3;
					p.z() = b3[2];
					p.y() = b3[1];
					setWfmPoint(_followingPointNumber[n+4][i], p);
					i++;
					
				}
			}
		}
	}
}

TransMouthFine::TransMouthFine(Wfm *wfm) 
: TransFace(wfm, leftLipGroupPoints + rightLipGroupPoints)
{
	_controlPointNumber = new PointNumber[_n];
	int i, n = 0;
	for (i = 0; i < leftLipGroupPoints; i++) {
		_controlPointNumber[n].gn = leftLipGroup;
		_controlPointNumber[n].pn = i + 1;
		n++;
	}
	for (i = 0; i < rightLipGroupPoints; i++) {
		_controlPointNumber[n].gn = rightLipGroup;
		_controlPointNumber[n].pn = i + 1;
		n++;
	}
	init();
}

void TransMouthFine::transform(int,int)
{
	for(int i = 0; i < _n; i++) setWfmPoint(_controlPointNumber[i], controlPoint1(i));
	init();
}

