/************************************************************************************/
/*	 TransNeck.c++																	*/
/*		t-misawa	 Version 1998.09.28												 */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
*/

PointNumber neckControlPointNumber[13] = { 
	{16, 6}, {16, 10}, {16, 14}, {16, 13}, {16, 12}, {16, 11}, 
	{16, 17}, 
	{17, 11}, {17, 12}, {17, 13}, {17, 14}, {17, 10}, {17, 6}
};

PointNumber neckReferencePointNumber[13][3] = { 
	{{0, 0}},
	{{16, 4}, {16, 13}, {0, 0}},
	{{16, 5}, {16, 8}, {0, 0}},
	{{16, 5}, {16, 3}, {0, 0}},
	{{16, 4}, {16, 1}, {0, 0}},
	{{16, 3}, {16, 1}, {0, 0}},
	
	{{16, 1}, {17, 1}, {0, 0}},
	
	{{17, 3}, {17, 1}, {0, 0}},
	{{17, 4}, {17, 1}, {0, 0}},
	{{17, 5}, {17, 3}, {0, 0}},
	{{17, 5}, {17, 8}, {0, 0}},
	{{17, 4}, {17, 13}, {0, 0}},
	{{0, 0}}
};

PointNumber neckFollowingPointNumber[13][20] = { 
	{{0, 0}},
	{{16, 9}, {0, 0}},
	{{16, 9}, {0, 0}},
	{{16, 9}, {16, 8}, {0, 0}},
	{{16, 8}, {16, 7}, {0, 0}},
	{{16, 7}, {0, 0}},
	
	{{16, 16}, {0, 0}},
	
	{{17, 7}, {0, 0}},
	{{17, 8}, {17, 7}, {0, 0}},
	{{17, 9}, {17, 8}, {0, 0}},
	{{17, 9}, {0, 0}},
	{{17, 9}, {0, 0}},
	{{0, 0}}
};

/************************************************************************************/
TransNeck::TransNeck(Wfm *wfm) : TransFace(wfm, 13)
{
	_controlPointNumber = neckControlPointNumber;
	for(int i = 0; i < _n; i++){
		_referencePointNumber[i] = neckReferencePointNumber[i];
		_followingPointNumber[i] = neckFollowingPointNumber[i];
	}
	init();
}

/************************************************************************************/
void TransNeck::transform(int,int flag)
{
	for(int i = 0; i < _n; i++) affineTransform2D(i,flag);
	init();
}

