/************************************************************************************/
/*   TransNose.c++                                                                  */
/*      t-misawa   Version 1998.09.28                                               */
/************************************************************************************/

#include "TransFace.h"
#include <math.h>

/*
--- Control Points ---
*/

PointNumber noseControlPointNumber[4] = { 
    {3, 15}, {3, 13}, {3, 25}, {3, 17}
};

PointNumber noseReferencePointNumber[4][10] = { 
    {{10, 1}, {11, 1}, {3, 9}, {3, 18}, {3, 23}, {3, 27}, {3, 12}, {3, 22},
	{0, 0}},
    {{3, 5}, {3, 25}, {0, 0}},
    {{3, 13}, {3, 17}, {0, 0}},
    {{3, 5}, {3, 25}, {0, 0}}
};

PointNumber noseFollowingPointNumber[4][20] = { 
    {{3, 7}, {0, 0}, 
	{3, 10}, {3, 14}, {0, 0},
	{3, 19}, {3, 20}, {3, 21}, {0, 0}, 
	{3, 11}, {3, 16}, {0, 0}},
    {{3, 6}, {3, 9}, {3, 10}, {3, 14}, {3, 18}, {3, 19}, {0, 0}},
    {{3, 19}, {3, 20}, {3, 21}, {3, 23}, {3, 24}, {3, 26}, {3, 27}, {0, 0}},
    {{3, 8}, {3, 11}, {3, 12}, {3, 16}, {3, 21}, {3, 22}, {0, 0}}
};

/************************************************************************************/
TransNose::TransNose(Wfm *wfm) : TransFace(wfm, 4)
{
    _controlPointNumber = noseControlPointNumber;
    int i;
    for (i = 0; i < _n; i++)
		_referencePointNumber[i] = noseReferencePointNumber[i];
    for (i = 0; i < _n; i++) 
		_followingPointNumber[i] = noseFollowingPointNumber[i];
    init();
}

/************************************************************************************/
void TransNose::transform(int,int flag)
{
    int i;
   	for (i = 0; i < _n; i++)
		affineTransform2D(i, flag);
    init();
}

