#include "main.h"

// extern
int main_window;
int main_window_size[2];
int main_window_pos[2];
int editor_window;
int editor_window_size[2];
int file_select_window;
int message_window;

Document *m_pDocument;
View *m_pView;
DialogEdit *m_pDialogEdit;
AUMove *m_pAUMove;
float m_dAUMove[];

int menu_layer;
int second_layer;

bool editflag;

char current_floder[256];
puOneShot *main_b[];
puOneShot *file_b[];
puOneShot *view_b[];
puOneShot *region_b[];
puOneShot *help_b[];
puOneShot *edit_b[];

puSlider	*editor_eye_sld[];
puText		*editor_eye_text[];
puOneShot	*editor_b[];
puOneShot	*eye_slider_button_save;

puDial		*au_slider_select_dial;
puSlider    *au_slider_slider;
puOneShot	*au_slider_button;
puOneShot	*au_slider_button_reset;
puOneShot   *au_slider_button_reset_trans;
puOneShot	*au_slider_button_reset_window;
puOneShot	*au_slider_button_save_wfm;

puSlider	*teeth_slider[EDITOR_TEETH_NUM];
puOneShot	*teeth_slider_button_save;

int flag_of_ok_cansel;
// extern 

// Button and slider open.
void OpenMainButtonMenu();
void SetMainButtonPos(int group_num, int num, int *pos);
void OpenResetEditorButton();
void OpenEyeEditorSlider();
void OpenAuEditorSlider();
void OpenTeethEditorSlider();

int main( int argc, char **argv )
{
	// Init.
	main_window_size[0] = MAIN_WIDTH;
	main_window_size[1] = MAIN_HEIGHT;
	main_window_pos[0] = MAIN_X;
	main_window_pos[1] = MAIN_Y;
	editor_window_size[0] = EDITOR_WIDTH;
	editor_window_size[1] = EDITOR_HEIGHT;
	strcpy( current_floder, "." );
	menu_layer = 0; 
	second_layer = -1;
	
	m_pDocument = new Document(DEFAULT_PNT_FILE, DEFAULT_LNK_FILE, DEFAULT_EYE_FILE,
		DEFAULT_MOUTHWALL_FILE, DEFAULT_MOUTHEALL_IMAGE_FILE, DEFAULT_TEETH_U_FILE, DEFAULT_TEETH_L_FILE,
			DEFAULT_AU_DIR, AU_SLD_NUM);
	m_pView = new View(m_pDocument, &main_window_size[0], &main_window_size[1]);
	m_pDialogEdit = new DialogEdit(m_pDocument, &editor_window_size[0], &editor_window_size[1]);

	m_pAUMove = m_pDocument->GetAUMove();

	for( int i = 0; i < AU_SLD_NUM; i++ ) {
		m_dAUMove[i] = 0.0;
	}

	// Create Main Window
	glutInitWindowSize(MAIN_WIDTH, MAIN_HEIGHT);
	glutInitWindowPosition(MAIN_X, MAIN_Y);
	glutInit(&argc, argv);
	glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);

	main_window = glutCreateWindow(MAIN_TITLE);
	glutDisplayFunc(mainDisplayfn);
	glutMouseFunc(mainMousefn);
	glutMotionFunc(mainMotionfn);
	glutReshapeFunc(mainReshapefn);
	glutKeyboardFunc(mainKeyfn);
	glutSpecialFunc(mainSpecialfn);
	
	puInit();

	puSetDefaultStyle(PUSTYLE_SMALL_SHADED);
	puSetDefaultColourScheme(0.3f, 0.4f, 0.8f, 0.6f);
	puSetDefaultFonts(PUFONT_HELVETICA_12, PUFONT_HELVETICA_12);
	
	// create button
	OpenMainButtonMenu();
	
	// Create Editor Window
	editor_window = glutCreateWindow( EDITOR_TITLE_EYE );
	glutDisplayFunc( editorDisplayfn );
	glutMouseFunc(editorMousefn);
	glutMotionFunc(editorMotionfn);
	glutReshapeFunc(editorReshapefn);
	glutKeyboardFunc(editorKeyfn);
	glutSpecialFunc(editorSpecialfn);
	glutHideWindow();
	
	// createSlider
	OpenResetEditorButton();
	OpenEyeEditorSlider();

	// create AU slider
	OpenAuEditorSlider();

	// createa teeth slider
	OpenTeethEditorSlider();

	// eye buttons open
	EditorAUButtonCloseAction(true);
	EditorEyeButtonCloseAction(false);
	EditorResetButtonCloseAction(false);
	EditorTeethButtonCloseAction(true);

	editflag = false;

	// Create File Select Dialog
	file_select_window = glutCreateWindow( FS_WINDOW_TITLE );
	glutDisplayFunc( fileSelectfn );
	glutMouseFunc(mousefn);
	glutMotionFunc(motionfn);
	glutKeyboardFunc(keyfn);
	glutSpecialFunc(specialfn);
	glutHideWindow();
	
	// Create Message Dialog
	message_window = glutCreateWindow( MS_WINDOW_TITLE );
	glutDisplayFunc( messageWindowfn );
	glutMouseFunc(mousefn);
	glutMotionFunc(motionfn);
	glutKeyboardFunc(keyfn);
	glutSpecialFunc(specialfn);
	glutHideWindow();

	glutMainLoop();
	
	return 0;
}

void OpenAuEditorSlider()
{
	int x_pos, y_pos;

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + 
		AU_SLIDER_WIDTH + AU_SLIDER_DUR * 3 + AU_SLIDER_BUTTON * 1);
	y_pos = AU_SLIDER_HEIGHT + AU_SLIDER_DUR * 2;
	au_slider_button_reset = new puOneShot( x_pos, y_pos,
			x_pos + AU_SLIDER_BUTTON, y_pos + AU_SLIDER_HEIGHT);
	au_slider_button_reset->setLegend("Reset All");
	au_slider_button_reset->setCallback(editor_au_button_reset_cb);
	au_slider_button_reset->setColour(PUCOL_LABEL, AU_SLIDER_FONT_COLOUR);
	au_slider_button_reset->setValue( true );

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + 
		AU_SLIDER_WIDTH + AU_SLIDER_DUR * 3 + AU_SLIDER_BUTTON * 1);
	y_pos = AU_SLIDER_DUR;
	au_slider_button = new puOneShot( x_pos, y_pos,
			x_pos + AU_SLIDER_BUTTON, y_pos + AU_SLIDER_HEIGHT);
	au_slider_button->setLegend("Reset");
	au_slider_button->setCallback(editor_au_button_cb);
	au_slider_button->setColour(PUCOL_LABEL, AU_SLIDER_FONT_COLOUR);
	au_slider_button->setValue( true );

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + AU_SLIDER_WIDTH + AU_SLIDER_DUR * 2 );

	au_slider_slider = new puSlider( x_pos, AU_SLIDER_DUR,
		AU_SLIDER_WIDTH, false, AU_SLIDER_HEIGHT);
	
	au_slider_slider->setMaxValue( 1.50f );
	au_slider_slider->setMinValue( 0.00f );
	au_slider_slider->setStepSize( 0.01f );
	au_slider_slider->setValue(0.0f);
	au_slider_slider->setLabel("0.00");
	au_slider_slider->setCBMode( PUSLIDER_ALWAYS );
	au_slider_slider->setCallback( editor_au_slider_cb );
	au_slider_slider->setLabelPlace( PUPLACE_BOTTOM_CENTERED );
	au_slider_slider->setColour( PUCOL_LABEL, AU_SLIDER_FONT_COLOUR );
 
	x_pos = x_pos + AU_SLIDER_WIDTH + AU_SLIDER_DUR;

	au_slider_select_dial = new puDial( x_pos, AU_SLIDER_DUR, 70 );
	au_slider_select_dial->setWrap( 1 );
	au_slider_select_dial->setMaxValue( AU_SLD_NUM - 1);
	au_slider_select_dial->setMinValue( 0 );
	au_slider_select_dial->setStepSize( 1 );
	au_slider_select_dial->setCBMode( PUSLIDER_ALWAYS );
	au_slider_select_dial->setCallback( editor_au_select_cb );
	au_slider_select_dial->setLabel( "AU List" );
	au_slider_select_dial->setLabelPlace( PUPLACE_BOTTOM_CENTERED );
	au_slider_select_dial->setColour( PUCOL_LABEL, AU_SLIDER_FONT_COLOUR );
	au_slider_select_dial->setLegendPlace( PUPLACE_BOTTOM_CENTERED );
	au_slider_select_dial->setLegend(AU_SLIDER_NAME[0]);

	y_pos = editor_window_size[1] - ( AU_SLIDER_DUR + AU_SLIDER_HEIGHT);
	au_slider_button_save_wfm = new puOneShot( AU_SLIDER_DUR, y_pos,
		AU_SLIDER_DUR + AU_SLIDER_BIG_BUTTON, y_pos + AU_SLIDER_HEIGHT);
	au_slider_button_save_wfm->setLegend("Save AU");
	au_slider_button_save_wfm->setCallback(editor_au_button_save_wfm_cb);
	au_slider_button_save_wfm->setColour(PUCOL_LABEL, AU_SLIDER_FONT_COLOUR);
	au_slider_button_save_wfm->setValue( true );
}	


void ResetAuEditorSlider()
{
	int x_pos, y_pos;

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + 
		AU_SLIDER_WIDTH + AU_SLIDER_DUR * 3 + AU_SLIDER_BUTTON * 1);
	y_pos = AU_SLIDER_HEIGHT + AU_SLIDER_DUR * 2;
	au_slider_button_reset->setPosition(x_pos, y_pos);
	au_slider_button_reset->setSize(AU_SLIDER_BUTTON, AU_SLIDER_HEIGHT);

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + 
		AU_SLIDER_WIDTH + AU_SLIDER_DUR * 3 + AU_SLIDER_BUTTON * 1);
	y_pos = AU_SLIDER_DUR;
	au_slider_button->setPosition(x_pos, y_pos);
	au_slider_button->setSize(AU_SLIDER_BUTTON, AU_SLIDER_HEIGHT);

	x_pos = editor_window_size[0] - (AU_SLIDER_DIAL_WIDTH + AU_SLIDER_WIDTH + AU_SLIDER_DUR * 2 );
	au_slider_slider->setPosition(x_pos, AU_SLIDER_DUR);

	x_pos = x_pos + AU_SLIDER_WIDTH + AU_SLIDER_DUR;
	au_slider_select_dial->setPosition(x_pos, AU_SLIDER_DUR);

	y_pos = editor_window_size[1] - ( AU_SLIDER_DUR + AU_SLIDER_HEIGHT);
	au_slider_button_save_wfm->setPosition(AU_SLIDER_DUR, y_pos);

}


void OpenResetEditorButton()
{
	int i;
	// create main
	for( i = 0; i < EDITOR_BUTTON_NUM; i++ ) {
		editor_b[i] = new puOneShot( EDITOR_BTN_DUR, 
			EDITOR_BTN_DUR + (EDITOR_BTN_HEIGHT + EDITOR_BTN_DUR) * i, 
			EDITOR_BTN_DUR + EDITOR_BTN_WIDTH,
			EDITOR_BTN_DUR + (EDITOR_BTN_HEIGHT + EDITOR_BTN_DUR) * i + EDITOR_BTN_HEIGHT );
		editor_b[i]->setLegend(EDITOR_BUTTON_NAME[i]);
		editor_b[i]->setCallback(EDITOR_BUTTON_CB[i]);
		editor_b[i]->setColour(PUCOL_LABEL, EYE_SLIDER_FONT_COLOUR);
		editor_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		editor_b[i]->setValue( true );
	}
}

void OpenTeethEditorSlider()
{
	int i, y_pos;


	for( i = 0; i < EDITOR_TEETH_NUM; i++ ) {
		teeth_slider[i] = new puSlider(TEETH_SLIDER_X_POS, 
			TEETH_SLIDER_Y_POS + (TEETH_SLIDER_HEIGHT + TEETH_SLIDER_DUR ) * i, 
			TEETH_SLIDER_WIDTH, false, TEETH_SLIDER_HEIGHT);
		teeth_slider[i]->setMaxValue( 1.00f );
		teeth_slider[i]->setMinValue( 0.00f );
		teeth_slider[i]->setStepSize( 0.01f );
		teeth_slider[i]->setValue(1.0f);
		teeth_slider[i]->setLabel(TEETH_SLIDER_NAME[i]);
		teeth_slider[i]->setCBMode( PUSLIDER_ALWAYS );
		teeth_slider[i]->setCallback( EDITOR_TEETH_SLIDER_CB[i] );
		teeth_slider[i]->setLabelPlace( PUPLACE_CENTERED_LEFT );
		teeth_slider[i]->setColour( PUCOL_LABEL, TEETH_SLIDER_FONT_COLOUR );
	}
	
	y_pos = editor_window_size[1] - ( TEETH_SLIDER_DUR + TEETH_SLIDER_HEIGHT);
	teeth_slider_button_save = new puOneShot( TEETH_SLIDER_DUR, y_pos,
		TEETH_SLIDER_DUR + TEETH_SLIDER_BIG_BUTTON, y_pos + TEETH_SLIDER_HEIGHT);
	teeth_slider_button_save->setLegend("Save Teeth");
	teeth_slider_button_save->setCallback(editor_teeth_button_save_cb);
	teeth_slider_button_save->setColour(PUCOL_LABEL, TEETH_SLIDER_FONT_COLOUR);
	teeth_slider_button_save->setValue( true );
}

void ResetTeethEditorSlider()
{
	int i, x_pos, y_pos;
	x_pos = editor_window_size[0] - (TEETH_SLIDER_WIDTH + TEETH_SLIDER_DUR);

	for( i = 0; i < EDITOR_TEETH_NUM; i++ ) {
		teeth_slider[i]->setPosition(x_pos, TEETH_SLIDER_Y_POS + (TEETH_SLIDER_HEIGHT + TEETH_SLIDER_DUR ) * i);
	}

	y_pos = editor_window_size[1] - ( TEETH_SLIDER_DUR + TEETH_SLIDER_HEIGHT);
	teeth_slider_button_save->setPosition(TEETH_SLIDER_DUR, y_pos);
}

void OpenEyeEditorSlider()
{
	int i, y_pos;

	editor_eye_text[1] = new puText(EYE_SLIDER_X_POS, EYE_SLIDER_Y_POS);
	editor_eye_text[1]->setLabel(EDITOR_EYE_SLIDER_LABEL[0]);
	editor_eye_text[1]->setLabelPlace(PUPLACE_BOTTOM_CENTERED);
	editor_eye_text[1]->setColour( PUCOL_LABEL, EYE_SLIDER_FONT_COLOUR );

	editor_eye_text[0] = new puText(EYE_SLIDER_X_POS + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, EYE_SLIDER_Y_POS);
	editor_eye_text[0]->setLabel(EDITOR_EYE_SLIDER_LABEL[1]);
	editor_eye_text[0]->setLabelPlace(PUPLACE_BOTTOM_CENTERED);
	editor_eye_text[0]->setColour( PUCOL_LABEL, EYE_SLIDER_FONT_COLOUR );

	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT] = new puSlider(EYE_SLIDER_X_POS, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR), 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setMaxValue( 0.07f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setMinValue( -0.07f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setStepSize( 0.0005f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setLabel(EDITOR_EYE_SLIDER_NAME[0]);


	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT] = new puSlider(EYE_SLIDER_X_POS + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR), 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setMaxValue( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setMinValue( -0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setStepSize( 0.001f );
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setLabel(EDITOR_EYE_SLIDER_NAME[0]);


	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT] = new puSlider(EYE_SLIDER_X_POS, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 2, 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setMaxValue( 30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setMinValue( -30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setStepSize( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setLabel(EDITOR_EYE_SLIDER_NAME[1]);


	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT] = new puSlider(EYE_SLIDER_X_POS + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 2, 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setMaxValue( 30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setMinValue( -30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setStepSize( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setLabel(EDITOR_EYE_SLIDER_NAME[1]);


	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT] = new puSlider(EYE_SLIDER_X_POS, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 3, 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setMaxValue( 30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setMinValue( -30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setStepSize( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setLabel(EDITOR_EYE_SLIDER_NAME[2]);


	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT] = new puSlider(EYE_SLIDER_X_POS + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 3, 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setMaxValue( 30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setMinValue( -30.0f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setStepSize( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setValue(0.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setLabel(EDITOR_EYE_SLIDER_NAME[2]);


	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE] = new puSlider(EYE_SLIDER_X_POS + EYE_SLIDER_WIDTH / 2 + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 4, 
		EYE_SLIDER_WIDTH, false, EYE_SLIDER_HEIGHT);
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setMaxValue( 1.5f );
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setMinValue( 0.1f );
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setStepSize( 0.01f );
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setValue(1.0f);
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setLabel(EDITOR_EYE_SLIDER_NAME[3]);


	for( i = 0; i < EDITOR_EYE_SLIDER_NUM; i++ ) {
		editor_eye_sld[i]->setCBMode( PUSLIDER_ALWAYS );
		editor_eye_sld[i]->setCallback( EDITOR_EYE_SLIDER_CB[i] );
		editor_eye_sld[i]->setLabelPlace( PUPLACE_BOTTOM_CENTERED );
		editor_eye_sld[i]->setColour( PUCOL_LABEL, EYE_SLIDER_FONT_COLOUR );
 
	}

	y_pos = editor_window_size[1] - ( EYE_SLIDER_DUR + EYE_SLIDER_HEIGHT);
	eye_slider_button_save = new puOneShot( EYE_SLIDER_DUR, y_pos,
		EYE_SLIDER_DUR + EYE_SLIDER_BIG_BUTTON, y_pos + EYE_SLIDER_HEIGHT);
	eye_slider_button_save->setLegend("Save Eye");
	eye_slider_button_save->setCallback(editor_eye_button_save_cb);
	eye_slider_button_save->setColour(PUCOL_LABEL, EYE_SLIDER_FONT_COLOUR);
	eye_slider_button_save->setValue( true );

}

void ResetEyeEditorSlider()
{
	int x_pos, y_pos;
	x_pos = editor_window_size[0] - (EYE_SLIDER_WIDTH + EYE_SLIDER_HEIGHT) * 2;

	editor_eye_text[1]->setPosition(x_pos, EYE_SLIDER_Y_POS);
	editor_eye_text[0]->setPosition(x_pos + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, EYE_SLIDER_Y_POS);

	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setPosition(x_pos, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR));

	editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setPosition(x_pos + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR));
	
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setPosition(x_pos, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 2);
	
	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setPosition(x_pos + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 2);

	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setPosition(x_pos,
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 3);

	editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setPosition(x_pos + EYE_SLIDER_WIDTH + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 3);
		
	editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setPosition(x_pos + EYE_SLIDER_WIDTH / 2 + EYE_SLIDER_DUR, 
		EYE_SLIDER_Y_POS - (EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 4);

	y_pos = editor_window_size[1] - ( EYE_SLIDER_DUR + EYE_SLIDER_HEIGHT);
	eye_slider_button_save->setPosition(EYE_SLIDER_DUR, y_pos);
}

void OpenMainButtonMenu()
{
	int i = 0;
	int pos[4];

	// create main
	for( i = 0; i < MAIN_B_NUM; i++ ) {
		SetMainButtonPos( MAIN_B_NUM, i + 1, pos );
		main_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		main_b[i]->setLegend(MAIN_MENU_NAME[i]);
		main_b[i]->setCallback(MAIN_MENU_CB[i]);
		main_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
	}
	
	// create file
	for( i = 0; i < FILE_B_NUM; i++ ) {
		SetMainButtonPos( FILE_B_NUM, i + 1, pos );
		file_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		file_b[i]->setLegend(FILE_SUBMENU_NAME[i]);
		file_b[i]->setCallback(FILE_SUBMENU_CB[i]);
		file_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		file_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
		file_b[i]->hide();
	}
	
	// create edit
	for( i = 0; i < EDIT_B_NUM; i++ ) {
		SetMainButtonPos( EDIT_B_NUM, i + 1, pos );
		edit_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		edit_b[i]->setLegend(EDIT_SUBMENU_NAME[i]);
		edit_b[i]->setCallback(EDIT_SUBMENU_CB[i]);
		edit_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		edit_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
		edit_b[i]->hide();
	}
	
	// create region
	for( i = 0; i < REGION_B_NUM; i++ ) {
		SetMainButtonPos( REGION_B_NUM, i + 1, pos );
		region_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		region_b[i]->setLegend(REGION_SUBMENU_NAME[i]);
		region_b[i]->setCallback(REGION_SUBMENU_CB[i]);
		region_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		region_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
		region_b[i]->hide();
	}
	
	// create view
	for( i = 0; i < VIEW_B_NUM; i++ ) {
		SetMainButtonPos( VIEW_B_NUM, i + 1, pos );
		view_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		view_b[i]->setLegend(VIEW_SUBMENU_NAME[i]);
		view_b[i]->setCallback(VIEW_SUBMENU_CB[i]);
		view_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		view_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
		view_b[i]->hide();
	}
	
	// create help
	for( i = 0; i < HELP_B_NUM; i++ ) {
		SetMainButtonPos( HELP_B_NUM, i + 1, pos );
		help_b[i] = new puOneShot( pos[0], pos[1], pos[2], pos[3] );
		help_b[i]->setLegend(HELP_SUBMENU_NAME[i]);
		help_b[i]->setCallback(HELP_SUBMENU_CB[i]);
		help_b[i]->setColour(0.8f, 0.3f, 0.4f, 0.6f);
		help_b[i]->setColour( PUCOL_LABEL, BTN_FONT_COLOUR );
		help_b[i]->hide();
	}
	ButtonStatusNewImage();
}

void ResetMainButtonMenu()
{
	int i;
	int pos[4];
	// create main
	for( i = 0; i < MAIN_B_NUM; i++ ) {
		SetMainButtonPos( MAIN_B_NUM, i + 1, pos );
		main_b[i]->setPosition(pos[0], pos[1]);
		main_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
	
	// create file
	for( i = 0; i < FILE_B_NUM; i++ ) {
		SetMainButtonPos( FILE_B_NUM, i + 1, pos );
		file_b[i]->setPosition(pos[0], pos[1]);
		file_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
	
	// create edit
	for( i = 0; i < EDIT_B_NUM; i++ ) {
		SetMainButtonPos( EDIT_B_NUM, i + 1, pos );
		edit_b[i]->setPosition(pos[0], pos[1]);
		edit_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
	
	// create region
	for( i = 0; i < REGION_B_NUM; i++ ) {
		SetMainButtonPos( REGION_B_NUM, i + 1, pos );
		region_b[i]->setPosition(pos[0], pos[1]);
		region_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
	
	// create view
	for( i = 0; i < VIEW_B_NUM; i++ ) {
		SetMainButtonPos( VIEW_B_NUM, i + 1, pos );
		view_b[i]->setPosition(pos[0], pos[1]);
		view_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
	
	// create help
	for( i = 0; i < HELP_B_NUM; i++ ) {
		SetMainButtonPos( HELP_B_NUM, i + 1, pos );
		help_b[i]->setPosition(pos[0], pos[1]);
		help_b[i]->setSize(BTN_WIDTH, BTN_HEIGHT);
	}
}

void SetMainButtonPos(int group_num, int num, int *pos)
{
	int center_x, center_y;	
	center_x = main_window_size[0] / 2;
	center_y = main_window_size[1] / 2;
	int f_pos[4];
	int row, clm, x_pos, y_pos;
	
	switch( group_num ) {
	case 1:
		row = clm = 1;
		x_pos = y_pos = 1;
		break;
	case 2:
		switch( num ) {
		case 1:	row = 2;	clm = 1;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 1;	x_pos = 2;	y_pos = 1;	break;
		}
		break;
	case 3:
		switch( num ) {
		case 1:	row = 2;	clm = 2;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 2;	x_pos = 2;	y_pos = 1; 	break;
		case 3:	row = 1;	clm = 2;	x_pos = 1;	y_pos = 2;	break;
		}
		break;
	case 4:
		switch( num ) {
		case 1:	row = 2;	clm = 2; 	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 2;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 2;	clm = 2;	x_pos = 1;	y_pos = 2;	break;
		case 4:	row = 2;	clm = 2;	x_pos = 2;	y_pos = 2;	break;
		}
		break;
	case 5:
		switch( num ) {
		case 1:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 1;	clm = 3;	x_pos = 1;	y_pos = 2;	break;
		case 4:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 3;	break;
		case 5:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 3;	break;
		}
		break;
	case 6:
		switch( num ) {
		case 1:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 2;	break;
		case 4:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 2;	break;
		case 5:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 3;	break;
		case 6:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 3;	break;
		}
		break;
	case 7:
		switch( num ) {
		case 1:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 2;	break;
		case 4:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 2;	break;
		case 5:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 2;	break;
		case 6:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 3;	break;
		case 7:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 3;	break;
		}
		break;
	case 8:
		switch( num ) {
		case 1:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 1;	break;
		case 4:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 2;	break;
		case 5:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 2;	break;
		case 6:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 2;	break;
		case 7:	row = 2;	clm = 3;	x_pos = 1;	y_pos = 3;	break;
		case 8:	row = 2;	clm = 3;	x_pos = 2;	y_pos = 3;	break;
		}
		break;
	case 9:
		switch( num ) {
		case 1:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 1;	break;
		case 2:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 1;	break;
		case 3:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 1;	break;
		case 4:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 2;	break;
		case 5:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 2;	break;
		case 6:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 2;	break;
		case 7:	row = 3;	clm = 3;	x_pos = 1;	y_pos = 3;	break;
		case 8:	row = 3;	clm = 3;	x_pos = 2;	y_pos = 3;	break;
		case 9:	row = 3;	clm = 3;	x_pos = 3;	y_pos = 3;	break;
		}
		break;
	}
	switch( row ) {
	case 1:
		f_pos[0] = center_x - BTN_WIDTH / 2;
		break;
	case 2:
		f_pos[0] = center_x - BTN_WIDTH - BTN_DUR / 2;
		break;
	case 3:
		f_pos[0] = center_x - BTN_WIDTH - BTN_DUR - BTN_WIDTH / 2;
		break;
	}
	switch( clm ) {
	case 1:
		f_pos[1] = center_y - BTN_HEIGHT / 2;
		break;
	case 2:
		f_pos[1] = center_y + BTN_DUR / 2;
		break;
	case 3:
		f_pos[1] = center_y + BTN_DUR / 2 + BTN_HEIGHT / 2;
		break;
	}
	
	pos[0] = f_pos[0] + (BTN_WIDTH + BTN_DUR) * (x_pos - 1);
	pos[2] = pos[0] + BTN_WIDTH;
	
	pos[1] = f_pos[1] - (BTN_HEIGHT + BTN_DUR) * (y_pos - 1);
	pos[3] = pos[1] + BTN_HEIGHT; 	
}

