#include "main.h"

// puObject *active_widget = (puObject *)NULL;
bool menuBflag = true;
int editorBflag = 1;  // 0:all close, 1:eye open, 2: au open, 3: teeth open

//////////
// for GlutKeyboard and Special Fn
void specialfn( int key, int, int )
{
	puKeyboard( key + PU_KEY_GLUT_SPECIAL_OFFSET, PU_DOWN );
	glutPostRedisplay();
}

void keyfn ( unsigned char key, int, int )
{
	puKeyboard( key, PU_DOWN );
	glutPostRedisplay();
}

void mainSpecialfn( int key, int, int )
{
	puKeyboard( key + PU_KEY_GLUT_SPECIAL_OFFSET, PU_DOWN );
	glutPostRedisplay();
}

void mainKeyfn ( unsigned char key, int, int )
{
	puKeyboard( key, PU_DOWN );
	//printf("key = %d\n", key );
	switch( key ) {
	case 32:	// space key
		menuBflag = !menuBflag;
		if( menuBflag == true ) {
			ButtonCloseAction(false);
		} else {
			ButtonCloseAction(true);
		}	
		break;
	case 14:	// Ctrl + n key: New Edit
		clear_file_cb(NULL);
		break;
	case 15:	// Ctrl + o key: Open face
		open_face_cb(NULL);
		break;
	case 16:	// Ctrl + p key: Open pnt
		open_pnt_cb(NULL);
		break;
	case 19:	// Ctrl + s key: Save pnt
		save_pnt_cb(NULL);
		break;

	case 49:	// 1 key: Region
		select_any_points_cb(NULL);
		break;
	case 50:	// 2 key: Region
		select_with_around_cb(NULL);
		break;
	case 51:	// 3 key: Region
		select_head_cb(NULL);
		break;
	case 52:	// 4 key: Region
		select_outline_cb(NULL);
		break;
	case 53:	// 5 key: Region
		select_eyes_cb(NULL);
		break;
	case 54:	// 6 key: Region
		select_brows_cb(NULL);
		break;
	case 55:	// 7 key: Region
		select_nose_cb(NULL);
		break;
	case 56:	// 8 key: Region
		select_mouth_cb(NULL);
		break;
	case 57:	// 9 key: Region
		select_neck_cb(NULL);
		break;	

	case 26:	// Ctrl + z key: Save pnt
		undo_cb(NULL);
		break;	
	case 25:	// Ctrl + y key: Save pnt
		redo_cb(NULL);
		break;
	case 87:	// Shift + w key: Save pnt
		reset_window_cb(NULL);
		break;	
	case 82:	// Shift + r key: Save pnt
		reset_model_cb(NULL);
		break;
	case 18:	// Ctrl + r key: Save pnt
		reset_all_cb(NULL);
		break;	
	}
		
	glutPostRedisplay();
}

void editorSpecialfn( int key, int, int )
{
	puKeyboard( key + PU_KEY_GLUT_SPECIAL_OFFSET, PU_DOWN );
	glutPostRedisplay();
}

void editorKeyfn ( unsigned char key, int, int )
{
	puKeyboard( key, PU_DOWN );
	if( key == 32 ) {   // space key...
		editorBflag++;
		if( editorBflag >= 4 ) {
			editorBflag = 0;
		}
		if( editorBflag == 0 ) {		// all close
			glutSetWindowTitle(EDITOR_TITLE_VIEWER);
			EditorAUButtonCloseAction(true);
			EditorEyeButtonCloseAction(true);
			EditorResetButtonCloseAction(true);
			EditorTeethButtonCloseAction(true);
		} else if( editorBflag == 1 ) { // eye open
			glutSetWindowTitle(EDITOR_TITLE_EYE);
			EditorAUButtonCloseAction(true);
			EditorEyeButtonCloseAction(false);
			EditorResetButtonCloseAction(false);
			EditorTeethButtonCloseAction(true);
		} else if( editorBflag == 2 ) { // au open
			glutSetWindowTitle(EDITOR_TITLE_AU);		
			EditorAUButtonCloseAction(false);
			EditorEyeButtonCloseAction(true);
			EditorResetButtonCloseAction(false);
			EditorTeethButtonCloseAction(true);
		} else if( editorBflag == 3 ) { // teeth open
			glutSetWindowTitle(EDITOR_TITLE_TEETH);		
			EditorAUButtonCloseAction(true);
			EditorEyeButtonCloseAction(true);
			EditorResetButtonCloseAction(false);
			EditorTeethButtonCloseAction(false);
		}
	}
	glutPostRedisplay();
}
// for GlutKeyboard and Special Fn
//////////


//////////
// for GlutMotionFn
void mainMotionfn(int x, int y)
{
	int status = 0;
//	active_widget = puActiveWidget();
	if( !puMouse(x, y) ) {
		m_pView->MouseDragEvent(x, y, status );
		//printf( "(%d, %d)\n", x, y );
#if 0
		if ( active_widget ) {
			active_widget->invokeActiveCallback();
			// Make sure PUI keeps the active widget active
			puSetActiveWidget( active_widget, 0, 0 );
		}
#endif
	}
	glutPostRedisplay();
}

void editorMotionfn(int x, int y)
{
	int status = 0;
//	active_widget = puActiveWidget();
	if( !puMouse(x, y) ) {
		//printf( "(%d, %d)\n", x, y );
		m_pDialogEdit->MouseDragEvent(x, y, status );
#if 0
		if ( active_widget ) {
			active_widget->invokeActiveCallback();
			// Make sure PUI keeps the active widget active
			puSetActiveWidget( active_widget, 0, 0 );
		}
#endif
	}
	glutPostRedisplay();
}

void motionfn(int x, int y)
{
	puMouse(x, y);
	glutPostRedisplay();
}
// for GlutMotionFn
//////////


//////////
// for GlutMouseFn
void mainMousefn(int button, int updown, int x, int y)
{
	int status = glutGetModifiers();
//	active_widget = puActiveWidget();

	if( menuBflag == true && menu_layer == 1 && button == PU_RIGHT_BUTTON ) {
		menu_layer = 0; 
		GetLayerButtons();
	} 
	else if ( !puMouse ( button, updown, x, y ) ) {
		//printf("status = %d\n", status );
	
		if( button == PU_LEFT_BUTTON && updown == PU_DOWN) {
			m_pView->LeftMousePushEvent(x, y, status);
		} 
		else if( button == PU_RIGHT_BUTTON && updown == PU_DOWN ) {
			m_pView->RightMousePushEvent(x, y, status);
		}
		else if( button == PU_LEFT_BUTTON && updown == PU_UP) {
			m_pView->LeftMouseReleaseEvent(x, y, status);
		}
		else if( button == PU_RIGHT_BUTTON && updown == PU_UP ) {
			m_pView->RightMouseReleaseEvent(x, y, status);
		}
#if 0		
	if ( active_widget ) {
		active_widget->invokeActiveCallback();
			// Make sure PUI keeps the active widget active
			puSetActiveWidget( active_widget, 0, 0 );
		}
#endif
	}

	
	glutPostRedisplay();
}

void editorMousefn(int button, int updown, int x, int y)
{
	int status = glutGetModifiers();
	//printf("status = %d\n", status );
	//active_widget = puActiveWidget();
	if ( !puMouse ( button, updown, x, y ) ) {
		if( button == PU_LEFT_BUTTON && updown == PU_DOWN) {
			m_pDialogEdit->LeftMousePushEvent(x, y, status);
		} 
		else if( button == PU_RIGHT_BUTTON && updown == PU_DOWN ) {
			m_pDialogEdit->RightMousePushEvent(x, y, status);
		}
		else if( button == PU_MIDDLE_BUTTON && updown == PU_DOWN ) {
			m_pDialogEdit->MidMousePushEvent(x, y, status);
		}
		else if( button == PU_LEFT_BUTTON && updown == PU_UP) {
			m_pDialogEdit->LeftMouseReleaseEvent(x, y, status);
		}
		else if( button == PU_RIGHT_BUTTON && updown == PU_UP ) {
			m_pDialogEdit->RightMouseReleaseEvent(x, y, status);
		}
		else if( button == PU_MIDDLE_BUTTON && updown == PU_UP ) {
			m_pDialogEdit->MidMouseReleaseEvent(x, y, status);
		}
#if 0		
		if ( active_widget ) {
			active_widget->invokeActiveCallback();
			// Make sure PUI keeps the active widget active
			puSetActiveWidget( active_widget, 0, 0 );
		}
#endif
	}	
	glutPostRedisplay();
}

void mousefn(int button, int updown, int x, int y)
{
	puMouse( button, updown, x, y ) ;
	glutPostRedisplay();
}
// for GlutMouseFn
//////////


//////////
// for GlutDisplayFn
void mainDisplayfn( void )
{
	// redraw
	m_pView->redraw();

	main_window_pos[0] = glutGet(GLUT_WINDOW_X);
	main_window_pos[1] = glutGet(GLUT_WINDOW_Y);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GREATER, 0.1f);

	puDisplay();

	glDisable(GL_BLEND);
	
	glutSwapBuffers();
	glutPostRedisplay();
}

void editorDisplayfn( void )
{
	Wfm *workWfm = m_pDocument->GetWorkWfm();
	Wfm *tempWfm = m_pDocument->GetTempWfm();

	// redraw
	if( editflag == true ) {
		m_pAUMove->setWfm(workWfm, tempWfm);
		m_pAUMove->resetWfm();
		m_pAUMove->auMove(m_dAUMove);
		m_pDialogEdit->redraw();
	}
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GREATER, 0.1f);
	
	puDisplay();
	
	glDisable(GL_BLEND);

	glutSwapBuffers();	
	glutPostRedisplay();
}

// for GlutDisplayFn
//////////

//////////
// for GlutReshapeFn
void mainReshapefn(int w, int h)
{
	main_window_size[0] = w;
	main_window_size[1] = h;
	ResetMainButtonMenu();
}

void editorReshapefn(int w, int h)
{
	editor_window_size[0] = w;
	editor_window_size[1] = h;
	ResetAuEditorSlider();
	ResetEyeEditorSlider();
	ResetTeethEditorSlider();
}
// for ReshapeFn
//////////
