#include "main.h"

int fileflag;
char filename[256];

static puDialogBox *dialog_box;
static puText      *dialog_box_message;
static puOneShot   *dialog_box_ok_button[2];
void clrear_file_cb_ok();
void eye_save_cb_ok();
void save_pnt_cb_ok();
void au_save_cb_ok();
void teeth_save_cb_ok();
void quit_cb_ok();

//////////
// for Menu "File" Callback
void main_file_cb(puObject *)
{
	menu_layer = 1;
	second_layer = MAIN_FILE_B;
	GetLayerButtons();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void main_edit_cb(puObject *)
{
	menu_layer = 1;
	second_layer = MAIN_EDIT_B;
	GetLayerButtons();
	glutSwapBuffers();	
	glutPostRedisplay();
}


void main_region_cb(puObject *)
{
	menu_layer = 1;
	second_layer = MAIN_REGION_B;
	GetLayerButtons();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void main_view_cb(puObject *)
{
	menu_layer = 1;
	second_layer = MAIN_VIEW_B;
	GetLayerButtons();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void main_help_cb(puObject *)
{
	menu_layer = 1;
	second_layer = MAIN_HELP_B;
	GetLayerButtons();
	glutSwapBuffers();	
	glutPostRedisplay();
}
// for Menu "File" Callback
//////////


//////////
// for Menu "File" Callback
void clear_file_cb(puObject *)
{
	if( file_b[FILE_NEW_EDIT_B]->isActive() ) {
		flag_of_ok_cansel = NEW_EDITTING;
		MakeMessageDialog( "Do you want new editting?", MS_WIDTH, MS_HEIGHT, false );
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void clrear_file_cb_ok()
{
	glutSetWindow( editor_window );
	glutHideWindow();
	glutSetWindow( main_window );
	editflag = false;
	m_pDocument->FileClear();
	ButtonStatusNewImage();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void open_face_cb(puObject *)
{
	if( file_b[FILE_OPEN_FACE_IMAGE_B]->isActive() ) {
		MakeFileDialog(IMAGE_FILE_OPEN, FS_TITLE_OPEN_IMG);
	}
}

void open_pnt_cb(puObject *)
{
	if( file_b[FILE_OPEN_PNT_B]->isActive() ) {
		MakeFileDialog(PNT_FILE_OPEN, FS_TITLE_OPEN_PNT);
	}
}

void save_pnt_cb(puObject *)
{
	if( file_b[FILE_SAVE_PNT_B]->isActive() ) {
		MakeFileDialog(PNT_FILE_SAVE, FS_TITLE_SAVE_PNT);
	}
}

void eye_open_cb(puObject *)
{
	MakeFileDialog(EYE_FILE_OPEN, FS_TITLE_OPEN_EYE);
}

void eye_save_cb(puObject *)
{
	MakeFileDialog(EYE_FILE_SAVE, FS_TITLE_SAVE_EYE);
}

void eye_tex_open_cb(puObject *)
{
	MakeFileDialog(EYE_IMAGE_OPEN, FS_TITLE_IMAG_EYE);
}

void au_open_cb(puObject *)
{
	MakeFileDialog(AU_FILE_OPEN, FS_TITLE_OPEN_AU);
}

void au_save_cb(puObject *)
{
	MakeFileDialog(AU_FILE_SAVE, FS_TITLE_SAVE_AU);
}

void teeth_save_cb(puObject *)
{
	MakeFileDialog(TEETH_FILE_SAVE, FS_TITLE_SAVE_TEETH);
}

void teeth_open_cb(puObject *)
{
	MakeFileDialog(TEETH_FILE_OPEN, FS_TITLE_OPEN_TEETH);
}

void quit_cb(puObject *)
{
	flag_of_ok_cansel = QUIT_PROCESS;
	MakeMessageDialog( "Do you want exiting?", MS_WIDTH, MS_HEIGHT, false );
}

void quit_cb_ok()
{
	exit(0);
}
// for Menu "File" Callback
//////////

//////////
// for Menu "Edit" Callback
void undo_cb(puObject *)
{
	if( edit_b[EDIT_UNDO_B]->isActive() ) {
		m_pView->EditUndo();
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void redo_cb(puObject *)
{
	if( edit_b[EDIT_REDO_B]->isActive() ) {
		m_pView->EditRedo();
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void reset_model_cb(puObject *)
{	
		m_pView->SetLocalTranslate( 0, 0.0 );
		m_pView->SetLocalTranslate( 1, 0.0 );
		m_pView->SetLocalTranslate( 2, 0.0 );
		m_pView->SetLocalRotate( 0, 0.0 );
		m_pView->SetLocalRotate( 1, 0.0 );
		m_pView->SetLocalRotate( 2, 0.0 );
		m_pView->SetLocalScale( 1.0 );
		glutSwapBuffers();	
		glutPostRedisplay();
}

void reset_all_cb(puObject *)
{
	if( edit_b[EDIT_RESET_WINDOW_B]->isActive() ) {		
		m_pView->SetGlobalTranslate( 0, 0.0 );
		m_pView->SetGlobalTranslate( 1, 0.0 );
		m_pView->SetGlobalTranslate( 2, 0.0 );
		m_pView->SetGlobalRotate( 0, 0.0 );
		m_pView->SetGlobalRotate( 1, 0.0 );
		m_pView->SetGlobalRotate( 2, 0.0 );
		m_pView->SetGlobalScale( 1.0 );
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void reset_window_cb(puObject *)
{
	if( edit_b[EDIT_UNDO_B]->isActive() ) {	
		if(m_pDocument->GetTexture()) {
			int x_size = m_pDocument->GetTexture()->GetWidth();
			int y_size = m_pDocument->GetTexture()->GetHeight();
			m_pView->RenewalDocument();
			glutReshapeWindow( x_size, x_size );
		}
		else {
			m_pView->RenewalDocument();
			glutReshapeWindow( MAIN_WIDTH, MAIN_HEIGHT );
		}
	}
}
// for Menu "Edit" Callback
//////////

//////////
// for Menu "Region" Callback
void select_neck_cb(puObject *)
{
	if( region_b[REGION_NECK_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_NECK);
		m_pView->SetFittingMode(TRANS_NECK);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void select_mouth_cb(puObject *)
{
	if( region_b[REGION_MOUTH_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_MOUTH);
		m_pView->SetFittingMode(TRANS_MOUTH);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
void select_nose_cb(puObject *)
{
	if( region_b[REGION_NOSE_B]->isActive() ) {	
		m_pView->SetEditRegion(REGION_BIT_NOSE);
		m_pView->SetFittingMode(TRANS_NOSE);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
void select_brows_cb(puObject *)
{
	if( region_b[REGION_BROWS_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_BROWS);
		m_pView->SetFittingMode(TRANS_BROW);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
void select_eyes_cb(puObject *)
{
	if( region_b[REGION_EYES_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_EYES);
		m_pView->SetFittingMode(TRANS_EYE);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
void select_outline_cb(puObject *)
{
	if( region_b[REGION_OUTLINE_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_OUTLINE);
		m_pView->SetFittingMode(TRANS_CONTOUR);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
void select_head_cb(puObject *)
{
	if( region_b[REGION_HEAD_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_HEAD);
		m_pView->SetFittingMode(TRANS_HEAD);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}

void select_with_around_cb(puObject *)
{
	if( region_b[REGION_WITH_AROUNT_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_WITHAROUND);
		m_pView->SetFittingMode(TRANS_WITHAROUND);
		glutSwapBuffers();	
		glutPostRedisplay();
		
	}
}

void select_any_points_cb(puObject *)
{
	if( region_b[REGION_ANY_POINTS_B]->isActive() ) {
		m_pView->SetEditRegion(REGION_BIT_ANYPOINTS);
		m_pView->SetFittingMode(TRANS_ALL);
		glutSwapBuffers();	
		glutPostRedisplay();
	}
}
// for Menu "Region" Callback
//////////

//////////
// for Menu "View" Callback
void view_color_cb(puObject *)
{
	m_pView->HiperColor();
	glutSwapBuffers();	
	glutPostRedisplay();
}

void view_editor_cb(puObject *)
{
	if( editflag == false ) {
		glutSetWindow (editor_window);
		glutShowWindow();
		glutReshapeWindow(EDITOR_WIDTH, EDITOR_HEIGHT);
		glutPositionWindow(EDITOR_X, EDITOR_Y);
		editflag = true;
	} else {
		glutSetWindow( editor_window );
		glutHideWindow();
		glutSetWindow( main_window );
		editflag = false;
	}
}


// for Menu "View" Callback
//////////

//////////
// for Menu "Help" Callback
void help_shortcut_cb(puObject *)
{
	MakeMessageDialog(help_how_to, MS_WIDTH, 350);
	glutSwapBuffers();	
	glutPostRedisplay();
}
void help_version_cb(puObject *)
{
	MakeMessageDialog(help_version_info);
	glutSwapBuffers();	
	glutPostRedisplay();
}
// for Menu "Help" Callback
//////////

//////////
// Button Action Control
void GetLayerButtons()
{
	static int old_layer = 0;

	if( old_layer == 0 && menu_layer == 1 ) {
		FirstLayerButtonAction(false);
		SecondLayerButtonAction(true);
		old_layer = menu_layer;
	} 
	else if( old_layer == 1 && menu_layer == 0 ) {
		FirstLayerButtonAction(true);
		SecondLayerButtonAction(false);
		old_layer = menu_layer;
	}
}

void FirstLayerButtonAction(bool flag)
{
	int i;
	if( flag == true ) {
		for( i = 0; i < MAIN_B_NUM; i++ ) main_b[i]->reveal();
	} else { 
		for( i = 0; i < MAIN_B_NUM; i++ ) main_b[i]->hide();
	}
}

void ButtonCloseAction(bool flag) 
{
	int i;
	if( flag == true ) {
		for( i = 0; i < MAIN_B_NUM; i++ ) main_b[i]->hide();
		for( i = 0; i < FILE_B_NUM; i++ ) file_b[i]->hide();
		for( i = 0; i < EDIT_B_NUM; i++ ) edit_b[i]->hide();
		for( i = 0; i < REGION_B_NUM; i++ ) region_b[i]->hide();
		for( i = 0; i < VIEW_B_NUM; i++ ) view_b[i]->hide();
		for( i = 0; i < HELP_B_NUM; i++ ) help_b[i]->hide();
	} else {
		if( menu_layer == 0 ) {
			for( i = 0; i < MAIN_B_NUM; i++ ) main_b[i]->reveal();
		}
		else {
			switch( second_layer ) {
			case MAIN_FILE_B:
					for( i = 0; i < FILE_B_NUM; i++ ) file_b[i]->reveal();
				break;
			case MAIN_EDIT_B:
					for( i = 0; i < EDIT_B_NUM; i++ ) edit_b[i]->reveal();
				break;
			case MAIN_REGION_B:
					for( i = 0; i < REGION_B_NUM; i++ ) region_b[i]->reveal();
				break;
			case MAIN_VIEW_B:
					for( i = 0; i < VIEW_B_NUM; i++ ) view_b[i]->reveal();
				break;
			case MAIN_HELP_B:
					for( i = 0; i < HELP_B_NUM; i++ ) help_b[i]->reveal();
				break;
			}
		}
	}
}


void SecondLayerButtonAction( bool flag)
{
	int i;
	switch(second_layer) {
	case MAIN_FILE_B:
		if( flag == true ) {
			for( i = 0; i < FILE_B_NUM; i++ ) file_b[i]->reveal();
		} else {  
			for( i = 0; i < FILE_B_NUM; i++ ) file_b[i]->hide();
		}
		break;
	case MAIN_EDIT_B:
		if( flag == true ) {
			for( i = 0; i < EDIT_B_NUM; i++ ) edit_b[i]->reveal();
		} else { 
			for( i = 0; i < EDIT_B_NUM; i++ ) edit_b[i]->hide();
		}
		break;
	case MAIN_REGION_B:
		if( flag == true ) {
			for( i = 0; i < REGION_B_NUM; i++ ) region_b[i]->reveal();
		} else { 
			for( i = 0; i < REGION_B_NUM; i++ ) region_b[i]->hide();
		}
		break;
	case MAIN_VIEW_B:
		if( flag == true ) {
			for( i = 0; i < VIEW_B_NUM; i++ ) view_b[i]->reveal();
		} else { 
			for( i = 0; i < VIEW_B_NUM; i++ ) view_b[i]->hide();
		}
		break;
	case MAIN_HELP_B:
		if( flag == true ) {
			for( i = 0; i < HELP_B_NUM; i++ ) help_b[i]->reveal();
		} else { 
			for( i = 0; i < HELP_B_NUM; i++ ) help_b[i]->hide();
		}
		break;
	}
}

void ButtonStatusFileOpen() 
{
	main_b[MAIN_FILE_B]->activate();
	file_b[FILE_NEW_EDIT_B]->activate();
	file_b[FILE_OPEN_FACE_IMAGE_B]->greyOut();
	file_b[FILE_OPEN_PNT_B]->activate();
	file_b[FILE_SAVE_PNT_B]->greyOut();
	file_b[FILE_OPEN_EYE_B]->greyOut();
	file_b[FILE_OPEN_TEETH_B]->greyOut();
	file_b[FILE_OPEN_AU_B]->greyOut();
	file_b[FILE_OPEN_EYE_TEX]->greyOut();

	main_b[MAIN_EDIT_B]->greyOut();
	edit_b[EDIT_UNDO_B]->greyOut();
	edit_b[EDIT_REDO_B]->greyOut();
	edit_b[EDIT_RESET_ALL_B]->greyOut();
	edit_b[EDIT_RESET_WINDOW_B]->greyOut();


	main_b[MAIN_REGION_B]->greyOut();
	region_b[REGION_ANY_POINTS_B]->greyOut();
	region_b[REGION_WITH_AROUNT_B]->greyOut();
	region_b[REGION_HEAD_B]->greyOut();
	region_b[REGION_OUTLINE_B]->greyOut();
	region_b[REGION_EYES_B]->greyOut();
	region_b[REGION_BROWS_B]->greyOut();
	region_b[REGION_NOSE_B]->greyOut();
	region_b[REGION_MOUTH_B]->greyOut();
	region_b[REGION_NECK_B]->greyOut();

	main_b[MAIN_VIEW_B]->greyOut();
	view_b[VIEW_EDITOR_B]->greyOut();
	view_b[VIEW_COLOR_B]->greyOut();

	main_b[MAIN_HELP_B]->activate();
	help_b[HELP_SHORTCUT_B]->activate();
	help_b[HELP_VERSION_B]->activate();
}

void ButtonStatusNewImage() 
{
	main_b[MAIN_FILE_B]->activate();
	file_b[FILE_NEW_EDIT_B]->greyOut();
	file_b[FILE_OPEN_FACE_IMAGE_B]->activate();
	file_b[FILE_OPEN_PNT_B]->greyOut();
	file_b[FILE_SAVE_PNT_B]->greyOut();
	file_b[FILE_OPEN_EYE_B]->greyOut();
	file_b[FILE_OPEN_TEETH_B]->greyOut();
	file_b[FILE_OPEN_AU_B]->greyOut();
	file_b[FILE_OPEN_EYE_TEX]->greyOut();

	main_b[MAIN_EDIT_B]->greyOut();
	edit_b[EDIT_UNDO_B]->greyOut();
	edit_b[EDIT_REDO_B]->greyOut();
	edit_b[EDIT_RESET_ALL_B]->greyOut();
	edit_b[EDIT_RESET_WINDOW_B]->greyOut();


	main_b[MAIN_REGION_B]->greyOut();
	region_b[REGION_ANY_POINTS_B]->greyOut();
	region_b[REGION_WITH_AROUNT_B]->greyOut();
	region_b[REGION_HEAD_B]->greyOut();
	region_b[REGION_OUTLINE_B]->greyOut();
	region_b[REGION_EYES_B]->greyOut();
	region_b[REGION_BROWS_B]->greyOut();
	region_b[REGION_NOSE_B]->greyOut();
	region_b[REGION_MOUTH_B]->greyOut();
	region_b[REGION_NECK_B]->greyOut();


	main_b[MAIN_VIEW_B]->greyOut();
	view_b[VIEW_EDITOR_B]->greyOut();
	view_b[VIEW_COLOR_B]->greyOut();

	main_b[MAIN_HELP_B]->activate();
	help_b[HELP_SHORTCUT_B]->activate();
	help_b[HELP_VERSION_B]->activate();
}

void ButtonStatusPntOpen() 
{
	main_b[MAIN_FILE_B]->activate();
	file_b[FILE_NEW_EDIT_B]->activate();
	file_b[FILE_OPEN_FACE_IMAGE_B]->greyOut();
	file_b[FILE_OPEN_PNT_B]->greyOut();
	file_b[FILE_SAVE_PNT_B]->activate();
	file_b[FILE_OPEN_EYE_B]->activate();
	file_b[FILE_OPEN_TEETH_B]->activate();
	file_b[FILE_OPEN_AU_B]->activate();
	file_b[FILE_OPEN_EYE_TEX]->activate();

	main_b[MAIN_EDIT_B]->activate();
	edit_b[EDIT_UNDO_B]->activate();
	edit_b[EDIT_REDO_B]->activate();
	edit_b[EDIT_RESET_ALL_B]->activate();
	edit_b[EDIT_RESET_WINDOW_B]->activate();

	main_b[MAIN_REGION_B]->activate();
	region_b[REGION_ANY_POINTS_B]->activate();
	region_b[REGION_WITH_AROUNT_B]->activate();
	region_b[REGION_HEAD_B]->activate();
	region_b[REGION_OUTLINE_B]->activate();
	region_b[REGION_EYES_B]->activate();
	region_b[REGION_BROWS_B]->activate();
	region_b[REGION_NOSE_B]->activate();
	region_b[REGION_MOUTH_B]->activate();
	region_b[REGION_NECK_B]->activate();

	main_b[MAIN_VIEW_B]->activate();
	view_b[VIEW_EDITOR_B]->activate();
	view_b[VIEW_COLOR_B]->activate();

	main_b[MAIN_HELP_B]->activate();
	help_b[HELP_SHORTCUT_B]->activate();
	help_b[HELP_VERSION_B]->activate();
}
// Button Action Control
//////////

//////////
// for Message Dialog
void MakeMessageDialog(const char *name, int width, int height, bool state)
{
	static char txt[ 1024 ];
	
	strcpy(txt, name);

	glutSetWindow (message_window);
	glutShowWindow();
	glutReshapeWindow ( width, height ) ;

	glutPositionWindow ( ( main_window_pos[0]  * 2 + main_window_size[0] - width ) / 2, 
		( main_window_pos[1]  * 2 + main_window_size[1] - height ) / 2 ) ;

	dialog_box = new puDialogBox ( 0, 0 ) ; // start x, y
	{
		new puFrame ( 0, 0, width, height ) ;
		dialog_box_message = new puText( 20, height - 50 );
		dialog_box_message->setLabel( txt );
		dialog_box_message->setColour( PUCOL_LABEL, MS_FONT_COLOUR );

		if ( state == true ) {
			dialog_box_ok_button[0] = new puOneShot( width / 2 - 30, 20, width / 2 + 30, 60 );
			dialog_box_ok_button[0]-> setLegend( "OK" );
			dialog_box_ok_button[0]-> makeReturnDefault( TRUE );
			dialog_box_ok_button[0]-> setCallback( go_away_cb );
		} else {
			dialog_box_ok_button[0] = new puOneShot( width / 2 - 70, 20, width / 2 - 10, 60 );
			dialog_box_ok_button[0]-> setLegend( "OK" );
			dialog_box_ok_button[0]-> makeReturnDefault( TRUE );
			dialog_box_ok_button[0]-> setCallback( ok_away_cb );
			dialog_box_ok_button[1] = new puOneShot( width / 2 + 10, 20, width / 2 + 70, 60 );
			dialog_box_ok_button[1]-> setLegend( "Cancel" );
			dialog_box_ok_button[1]-> makeReturnDefault( TRUE );
			dialog_box_ok_button[1]-> setCallback( cancel_away_cb );
		}

	}

  dialog_box->close();
	dialog_box->reveal();
}

void go_away_cb( puObject * )
{
	// Delete the dialog box when its 'OK' button is pressed.
	//puDeleteObject( dialog_box );
	delete dialog_box;
	//dialog_box = Delete;
	glutHideWindow();
	glutSetWindow( main_window );
}

void ok_away_cb( puObject * )
{
	// Delete the dialog box when its 'OK' button is pressed.
	//puDeleteObject( dialog_box );
	delete dialog_box;
	//dialog_box = Delete;
	glutHideWindow();
	glutSetWindow( main_window );

	switch (flag_of_ok_cansel) {
	case NEW_EDITTING:
		clrear_file_cb_ok();
		break;
	case PNT_FILE_SAVE:
		save_pnt_cb_ok();
		break;
	case EYE_FILE_SAVE:
		eye_save_cb_ok();
		break;
	case AU_FILE_SAVE:
		au_save_cb_ok();
		break;
	case TEETH_FILE_SAVE:
		teeth_save_cb_ok();
		break;
	case QUIT_PROCESS:
		quit_cb_ok();
		break;
	}
}

void cancel_away_cb( puObject * )
{
	// Delete the dialog box when its 'Cancel' button is pressed.
	//puDeleteObject( dialog_box );
	delete dialog_box;
	//dialog_box = Delete;
	glutHideWindow();
	glutSetWindow( main_window );
}

void messageWindowfn()
{

	glutSetWindow ( message_window );
	
	glClearColor ( 0.0f, 0.0f, 0.0f, 1.0f ) ;
	glClear      ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GREATER, 0.1f);


	puDisplay ( message_window ) ;

	glDisable(GL_BLEND);

	glutSwapBuffers();
	glutPostRedisplay();
}
// for Message Dialog
//////////


//////////
// for file select dialog
void MakeFileDialog(int flag, const char *name)
{
	fileflag = flag;
	int save_count = 0;  // Number of buttons in file picker
	glutSetWindow (file_select_window);
	glutShowWindow();
	glutReshapeWindow ( FS_WIDTH, FS_HEIGHT ) ;

	glutPositionWindow ( ( main_window_pos[0]  * 2 + main_window_size[0] - FS_WIDTH ) / 2, 
		( main_window_pos[1]  * 2 + main_window_size[1] - FS_HEIGHT ) / 2 ) ;
	if ( ++save_count > 2 ) save_count = 0 ;
	
	file_selector = new puFileSelector ( 0, 0, FS_WIDTH, FS_HEIGHT, save_count, current_floder, name );
	file_selector->setCallback( pick_cb );
	file_selector->setChildStyle( PUCLASS_ONESHOT, PUSTYLE_BOXED );
	file_selector->setChildBorderThickness(PUCLASS_ONESHOT, 5);
	file_selector->setChildColour( PUCLASS_SLIDER, 0, 0.5, 0.5, 0.5);
	file_selector->setChildColour( PUCLASS_FRAME, PUCOL_LABEL, FS_FONT_COLOUR);
	file_selector->setChildColour( PUCLASS_INPUT, PUCOL_LABEL, FS_FONT_COLOUR);
	file_selector->setChildColour( PUCLASS_LISTBOX, PUCOL_LABEL, FS_FONT_COLOUR);
	file_selector->setChildColour( PUCLASS_FRAME, FS_FONT_COLOUR);
	file_selector->setChildColour( PUCLASS_TEXT, PUCOL_LABEL, FS_FONT_COLOUR);
}

void GetCurrentFolder( char *folder, char *filename )
{
	char *pdest;
	int result;
	
	pdest = strrchr( filename, '\\' );
	result = pdest - filename + 1;
	if( pdest != NULL ) {
		strncpy( folder, filename, result );
	}
}

void fileSelectfn()
{

	glutSetWindow ( file_select_window );
	
	glClearColor ( 0.0f, 0.0f, 0.0f, 1.0f ) ;
	glClear      ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GREATER, 0.1f);

	puDisplay ( file_select_window ) ;

	glDisable(GL_BLEND);

	glutSwapBuffers();
	glutPostRedisplay();
}

void save_pnt_cb_ok()
{
	Wfm *wfm;

	wfm = m_pDocument->GetWorkWfm();
	wfm->save(filename);
	glutSwapBuffers();	
	glutPostRedisplay();
}

void eye_save_cb_ok()
{
	m_pDocument->EyeFileSave(filename);
	glutSwapBuffers();	
	glutPostRedisplay();
}

void au_save_cb_ok()
{
	Wfm *wfm, *wfm_temp;
	wfm = m_pDocument->GetWorkWfm();
	wfm_temp = m_pDocument->GetTempWfm();
	
	wfm->saveDiff(filename, wfm_temp);

	glutSwapBuffers();	
	glutPostRedisplay();
}

void teeth_save_cb_ok()
{
	m_pDocument->TeethFileSave(filename);
	glutSwapBuffers();
	glutPostRedisplay();
}

void pick_cb(puObject *)
{
	ObjModel *obj;
	char *file;	
	file_selector->getValue( &file );
	strcpy(filename, file );

	puDeleteObject( file_selector );
	file_selector = 0;
	glutHideWindow();
	glutSetWindow( main_window );
	
	switch( fileflag ) {
	case IMAGE_FILE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pDocument->ImageOpen(filename) == false ) {
				MakeMessageDialog("Connet open face image....");
			} else {
				ButtonStatusFileOpen();
				GetCurrentFolder( current_floder, filename );
			}
		}
		break;
	case PNT_FILE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pDocument->PntOpen(filename) == false ) {
				MakeMessageDialog("Connet open or Pnt version is differenct...");
			} else {
				m_pDialogEdit->SetRenewalInfo();
				ButtonStatusPntOpen();
				GetCurrentFolder( current_floder, filename );	
			}
		}
		break;
	case PNT_FILE_SAVE:
		if( filename[0] != 0 ) {
			GetCurrentFolder( current_floder, filename );
			flag_of_ok_cansel = PNT_FILE_SAVE;
			MakeMessageDialog( "Do you want to save this model file?", MS_WIDTH, MS_HEIGHT, false );
		}
		break;
	case EYE_FILE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pDocument->EyeFileOpen(filename) == false ) {
				MakeMessageDialog("Connet Open Eye Define file..." );
			}
			else {
				obj = m_pDocument->GetEyeObject();
				obj->ReCalcTexture(m_pDocument->GetEyeTexScale());
				m_pDialogEdit->SetRecreateEyeCallList();
				editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_LEFT]->setValue((float)(m_pDocument->GetEyeLLocalTrans()[2]));
				editor_eye_sld[EDITOR_EYE_SLIDER_TRANS_Z_RIGHT]->setValue((float)(m_pDocument->GetEyeRLocalTrans()[2]));
				editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_LEFT]->setValue((float)(m_pDocument->GetEyeLLocalRot()[0]));
				editor_eye_sld[EDITOR_EYE_SLIDER_ROT_X_RIGHT]->setValue((float)(m_pDocument->GetEyeRLocalRot()[0]));
				editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_LEFT]->setValue((float)(m_pDocument->GetEyeLLocalRot()[1]));
				editor_eye_sld[EDITOR_EYE_SLIDER_ROT_Y_RIGHT]->setValue((float)(m_pDocument->GetEyeRLocalRot()[1]));
				editor_eye_sld[EDITOR_EYE_SLIDER_SCALE]->setValue((float)(m_pDocument->GetEyeTexScale()));

				GetCurrentFolder( current_floder, filename );
			}
		}
		break;
	case EYE_FILE_SAVE:
		if( filename[0] != 0 ) {
			GetCurrentFolder( current_floder, filename );
			flag_of_ok_cansel = EYE_FILE_SAVE;
			MakeMessageDialog( "Do you want to save the eye define file?", MS_WIDTH, MS_HEIGHT, false );
		}
		break;
	case EYE_IMAGE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pDocument->EyeTextureOpen(filename) == false ) {
				MakeMessageDialog("Connet Open" );
			}
			else {
				obj = m_pDocument->GetEyeObject();
				obj->ReCalcTexture(m_pDocument->GetEyeTexScale());
				m_pDialogEdit->SetRecreateEyeCallList();
				GetCurrentFolder( current_floder, filename );
			}
		}
		break;
	case AU_FILE_SAVE:
		if( filename[0] != 0 ) {
			GetCurrentFolder( current_floder, filename );
			flag_of_ok_cansel = AU_FILE_SAVE;
			MakeMessageDialog( "Do you want to save your desien au file?", MS_WIDTH, MS_HEIGHT, false );
		}
		break;
	case TEETH_FILE_SAVE:
		if( filename[0] != 0 ) {
			GetCurrentFolder( current_floder, filename );
			flag_of_ok_cansel = TEETH_FILE_SAVE;
			MakeMessageDialog( "Do you want to save the teeth define file?", MS_WIDTH, MS_HEIGHT, false );
		}
		break;
	case AU_FILE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pAUMove->openUserDefAUData(filename) == false ) {
				MakeMessageDialog("Connet Open AU file..." );
			}
			else {
				GetCurrentFolder( current_floder, filename );
			}
		}
		break;
	case TEETH_FILE_OPEN:
		if( filename[0] != 0 ) {
			if( m_pDocument->TeethFileOpen(filename) == false ) {
				MakeMessageDialog("Connet Open Teeth Define file..." );
			}
			else {
				teeth_slider[EDITOR_TEETH_SLIDER_DIF_RED]->setValue(m_pDocument->GetTeethDifColor()[0]);
				teeth_slider[EDITOR_TEETH_SLIDER_DIF_BLUE]->setValue(m_pDocument->GetTeethDifColor()[1]);
				teeth_slider[EDITOR_TEETH_SLIDER_DIF_GREEN]->setValue(m_pDocument->GetTeethDifColor()[2]);

				GetCurrentFolder( current_floder, filename );
			}
		}
		break;
	default:
		break;
	}
	glutSwapBuffers();	
	glutPostRedisplay();
}
// for file select dialog
//////////

