#!/bin/csh -f
#
#	julian test run script 
#

#### setup section begin
# package top dir
set topdir=../../..
# model to use
set hmm=../../../../phone_m/jnas/ptm-3000x64/gid/hmmdefs,tmix.gz
set hmmlist=../../../../phone_m/jnas/logicalTri
#### setup section end

# determine which binary to use...
set OSTYPE=`uname`
switch ($OSTYPE)
case SunOS:
    set JULIAN=${topdir}/bin/sol2/julian
    breaksw
case IRIX:
    set JULIAN=${topdir}/bin/irix/julian
    breaksw
case Linux:
    set JULIAN=${topdir}/bin/linux/julian
    breaksw
endsw

if ($#argv == 0) then
	echo "usage: $0 gramprefix [julian_options]..."
	echo "  JULIAN binary = $JULIAN"
	echo "            HMM = $hmm"
	exit
endif

set gram=$1
shift
$JULIAN -h $hmm -hlist $hmmlist -v ${gram}.dict -dfa ${gram}.dfa -demo -input mic
