/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* htk_defs.h --- defines to use HTK format files */

/* $Id: htk_defs.h,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#ifndef __SENT_HTK_DEFS_H__
#define __SENT_HTK_DEFS_H__

/* parameter format info */
/* only part of these can be used so far */
enum parameter_type {
  F_WAVEFORM,
  F_LPC,			/* LPC --- linear prediction coef. */
  F_LPREFC,			/* linear prediction refrection coef. */
  F_LPCEPSTRA,			/* LPC cepstrum */
  F_LPDELCEP,
  F_IREFC,
  F_MFCC,			/* mel-frequency cepstral coef. */
  F_FBANK,			/* log-scale filterbank parameter */
  F_MELSPEC,			/* mel-scale filterbank parameter */
  F_USER,
  F_DISCRETE,			/* discrete */
  F_ERR_INVALID			/* ERROR */
};

/* additional parameter qualifier */
#define F_ENERGY     0x0040	/* _E log energy coef. */
#define F_ENERGY_SUP 0x0080	/* _N (with _E) suppress absolute energy */
#define F_DELTA      0x0100 	/* _D delta (first-order regression) coef. */
#define F_ACCL       0x0200	/* _A (with _D) acceleration (second-order) coef. */
#define F_COMPRESS   0x0400	/* _C compressed */
#define F_CEPNORM    0x0800	/* _Z cepstral mean normalization */
#define F_CHECKSUM   0x1000	/* _K CRC checksum added */
#define F_ZEROTH     0x2000	/* _0 (with MFCC) 0'th cepstral parameter */

#define F_BASEMASK   0x003f

/* covariance matrix type: only C_INV_DIAG supported */
enum{
  C_DIAG_C,
  C_INV_DIAG,
  C_FULL,
  C_LLT,
  C_XFORM};

/* duration type: only D_NULL is supported */
enum{
  D_NULL,
  D_POISSON,
  D_GAMMA,
  D_GEN};

/* HMM Type structure */
typedef struct {
  char *name;			/* name in hmmdefs */
  short type;			/* type id */
  char *desc;			/* description */
  boolean supported;		/* TRUE if can use */
} OptionStr;


#endif /* __SENT_HTK_DEFS_H__ */
