/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* rdhmmdef_data.c --- read in hmmdefs (data = HMM) */

/* $Id: rdhmmdef_data.c,v 1.3 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>

extern char *rdhmmdef_token;	/* defined in rdhmmdef.c */

/* malloc new */
HTK_HMM_Data *
htk_hmmdata_new()
{
  HTK_HMM_Data *new;

  new = (HTK_HMM_Data *)mybmalloc(sizeof(HTK_HMM_Data));

  new->name = NULL;
  new->state_num = 0;
  new->s = NULL;
  new->tr = NULL;
  new->next = NULL;

  return(new);
}

/* add new to global structure */
static void
htk_hmmdata_add(HTK_HMM_INFO *hmm, HTK_HMM_Data *new)
{
  HTK_HMM_Data *match;
  /* link data structure */
  new->next = hmm->start;
  hmm->start = new;

  if (new->name == NULL) {
    /* HMM must have a name */
    rderr("Error: HMM has no name");
  } else {
    /* add index to search index tree */
    if (hmm->physical_root == NULL) {
      hmm->physical_root = aptree_make_root_node(new);
    } else {
      match = aptree_search_data(new->name, hmm->physical_root);
      if (strmatch(match->name, new->name)) {
	/* HMM of the same name should not be defined */
	j_printerr("Error: HMM \"%s\" is defined more than twice\n", new->name);
	rderr(NULL);
      } else {
	aptree_add_entry(new->name, new, match->name, &(hmm->physical_root));
      }
    }
  }
}

/* read in model */
static HTK_HMM_Data *
htk_hmmdata_read(FILE *fp, HTK_HMM_INFO *hmm)
{
  HTK_HMM_Data *new;
  int i;
  short sid;

  new = htk_hmmdata_new();

  /* begin tag */
  if (!currentis("BEGINHMM")) rderr("<BEGINHMM> not found");
  read_token(fp);

  /* read global opt if any */
  /* read_global_opt(fp, &(new->opt)); */

  /* num of state */
  if (!currentis("NUMSTATES")) rderr("<NUMSTATES> not found");
  read_token(fp);
  NoTokErr("state num not found\n");
  new->state_num = atoi(rdhmmdef_token);
  read_token(fp);

  /* malloc state */
  new->s = (HTK_HMM_State **)mybmalloc(sizeof(HTK_HMM_State *) * new->state_num);
  for(i=0;i<new->state_num;i++) {
    new->s[i] = NULL;
  }

  /* read/set each state info */
  for (;;) {
    if (!currentis("STATE")) break;
    read_token(fp); NoTokErr("STATE id not found");
    sid = atoi(rdhmmdef_token) - 1;
    read_token(fp);
    new->s[sid] = get_state_data(fp, hmm);
  }

  /* read/set transition info */
  new->tr = get_trans_data(fp, hmm);
  if ((new->tr)->statenum != new->state_num) {
    rderr("# of transition != # of state");
  }

  /* read/set duration */

  /* end tag */
  if (!currentis("ENDHMM")) rderr("<ENDHMM> not found");
  read_token(fp);

  return(new);
}  


/* HMM model definition */
void
def_HMM(
	char *name,		/* should not be freed after */
	FILE *fp,
	HTK_HMM_INFO *hmm)
{
  HTK_HMM_Data *new;

  /* read in HMM model data from fp, and return newly malloced HTK_HMM_Data */
  new = htk_hmmdata_read(fp, hmm);

  /* set name and add the new data to the main structure */
  new->name = name;
  htk_hmmdata_add(hmm, new);
}
