/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* strcasecmp.c --- strcasecmp() and strncasecmp() implement for
   non BSD-compliant environment */

/* $Id: strcasecmp.c,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>

#ifndef HAVE_STRCASECMP

#include <string.h>

int
strcasecmp(char *s1, char *s2)
{
  int c1, c2;

  do {
    c1 = (*s1 >= 'a' && *s1 <= 'z') ? *s1 - 040 : *s1;
    c2 = (*s2 >= 'a' && *s2 <= 'z') ? *s2 - 040 : *s2;
    if (c1 != c2) break;
  }  while (*(s1++) && *(s2++));
  return(c1 - c2);
}

int
strncasecmp(char *s1, char *s2, size_t n)
{
  int c1, c2;
  do {
    c1 = (*s1 >= 'a' && *s1 <= 'z') ? *s1 - 040 : *s1;
    c2 = (*s2 >= 'a' && *s2 <= 'z') ? *s2 - 040 : *s2;
    if (c1 != c2) break;
  }  while (*(s1++) && *(s2++) && (--n));
  return(c1 - c2);
}

#endif /* ~HAVE_STRCASECMP */
