/* Copyright (c) 2000-2003                             */
/*   Yamashita Lab., Ritsumeikan University            */
/*   Takao Kobayashi, Takashi Masuko, Masatsune Tamura */
/*   Tokyo Institute of Technology                     */
/*   Keiichi Tokuda, Takayoshi Yoshimura, Heiga Zen    */
/*   Nagoya Institute of Technology                    */
/*   All rights reserved                               */

#ifndef _SYNTHESIS_H_
#define _SYNTHESIS_H_

typedef enum {NON,SILB,SILE,PAU} SILENCE;
typedef enum {NO,YES} BOOLEAN_WIN;

/* f */

typedef struct _phoneme {
	char *phoneme;
	double time;
	double ctime;	/* O܂ł̗ݐώԁBԒČŐݒ */
	struct _phoneme *next;
	struct _phoneme *prev;
	struct _mora *parent;
	int sid;	/* speaker ID */
	double alpha;	/* warping parameter */
} PHONEME;

#ifndef WIN32
PHONEME *phhead;
PHONEME *phtail;
#endif
#ifdef WIN32
extern PHONEME *phhead;
extern PHONEME *phtail;
#endif

/* [ */

typedef struct _mora {
	char *yomi;     /* Ji\L */
	int position;
	int acdist;
	BOOLEAN_WIN chouonka;
	BOOLEAN_WIN devoiced;
	SILENCE silence;
	PHONEME *phead;
	PHONEME *ptail;
	struct _mora *next;
	struct _mora *prev;
	struct _morph *parent;
} MORA;

#ifndef WIN32
MORA *mrhead;
MORA *mrtail;
#endif
#ifdef WIN32
extern MORA *mrhead;
extern MORA *mrtail;
#endif

typedef struct _accent{
	char prepos; /* si: V, A, N, *(all), -(None) */
	int form;   /* ANZgl */
	int ctype;  /* ANZg */
	int ctype2;  /* ANZg (tŁAsꂪLjAjɂ
	                ANZglςꍇ (F6F9) B) */
} ACCENT;

#define MAX_ACCENT      4

/* `ԑf */
typedef struct _morph {
	char *kanji;    /* \L */
	char *pron;     /* Ji\LF⣂́uǂ݁vo */
	int nmora;
	int nbyte;		/* \Lł̕ */
	int hinshiID;
	int katsuyogataID;
	int katsuyokeiID;
	int accentType;
	ACCENT accent[MAX_ACCENT];
	int n_accent;
	struct _morph *submorph;
	SILENCE silence;
	MORA *mrhead;
	MORA *mrtail;
	struct _morph *next;
	struct _morph *prev;
	struct _aphrase *parent;
} MORPH;

#ifndef WIN32
MORPH *mphead;
MORPH *mptail;
#endif
#ifdef WIN32
extern MORPH *mphead;
extern MORPH *mptail;
#endif

/* ANZg */
typedef struct _aphrase {
	int nmora;
	int accentType;
	int position;		/* ċCił̃ANZg̈ʒu */
	SILENCE silence;
	BOOLEAN_WIN interrogative;
	MORPH *mphead;
	MORPH *mptail;
	struct _aphrase *next;
	struct _aphrase *prev;
	struct _breath *parent;
} APHRASE;

#ifndef WIN32
APHRASE *ahead;
APHRASE *atail;
#endif
#ifdef WIN32
extern APHRASE *ahead;
extern APHRASE *atail;
#endif

/* ċCi */
typedef struct _breath {
	int nmora;
	int position;   /* ł̌ċCïʒuB|[Y̌ċCi
	                   Ȃ邪ɂ͂ꂸA position  -1 */
	SILENCE silence;
	APHRASE *ahead;
	APHRASE *atail;
	struct _breath *next;
	struct _breath *prev;
	struct _sentence *parent;
} BREATH;

#ifndef WIN32
BREATH *bhead;
BREATH *btail;
#endif
#ifdef WIN32
extern BREATH *bhead;
extern BREATH *btail;
#endif

/*  */
typedef struct _sentence {
	int nmora;
	int nbreath;	/* |[YȊǑċCi̐ */
	BREATH *bhead;
	BREATH *btail;
	struct _sentence *prev;
	struct _sentence *next;
} SENTENCE;

#ifndef WIN32
SENTENCE *shead;
SENTENCE *stail;
SENTENCE *sentence;
#endif
#ifdef WIN32
extern SENTENCE *shead;
extern SENTENCE *stail;
extern SENTENCE *sentence;
#endif

typedef struct _wave
{
  short *data;
  int rate;
} WAVE;

#ifndef WIN32
WAVE wave;
#endif
#ifdef WIN32
extern WAVE wave;
#endif

typedef struct _param
{
  double *data;
  int rate;
} PARAM;

#ifndef WIN32
PARAM power;
PARAM f0;
PARAM alpha;
#endif
#ifdef WIN32
extern PARAM power;
extern PARAM f0;
extern PARAM alpha;
#endif

#define MAX_UTTER 9192
extern char chasen_input[MAX_UTTER];

#endif //_SYNTHESIS_H_
