/*
 * fastcgi.c - FastCGI interface
 *
 *   Copyright (c) 2004 Kimura Fuyuki, All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *   3. Neither the name of the authors nor the names of its contributors
 *      may be used to endorse or promote products derived from this
 *      software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Id: fastcgi.c,v 1.3 2006/01/14 04:18:31 shirok Exp $
 */

#include "fastcgi.h"

extern void Scm_Init_fcgi(ScmModule *module);

static int fcgi_filler(ScmPort *p, int cnt)
{
    int nread = 0, r;
    FCGX_Stream *stream = p->src.buf.data;
    char *datptr = p->src.buf.end;

    while (nread == 0) {
        r = FCGX_GetStr(datptr, cnt-nread, stream);
        if (r < cnt-nread) {
            nread += r;
            break;
        } else {
            datptr += r;
            nread += r;
        }
    }
    return nread;
}

static int fcgi_flusher(ScmPort *p, int cnt, int forcep)
{
    int nwrote = 0, r;
    int datsiz = SCM_PORT_BUFFER_AVAIL(p);
    FCGX_Stream *stream = p->src.buf.data;
    char *datptr = p->src.buf.buffer;

    while ((!forcep && nwrote == 0)
           || (forcep && nwrote < cnt)) {
        r = FCGX_PutStr(datptr, datsiz-nwrote, stream);
        if (r < 0) {
            p->error = TRUE;
            Scm_SysError("FCGX_PutStr() failed on %S", p);
        } else {
            datptr += r;
            nwrote += r;
        }
    }
    return nwrote;
}

ScmObj Scm_MakePortWithFcgxStream(FCGX_Stream *stream)
{
    ScmObj p;
    ScmPortBuffer bufrec;

    bufrec.buffer = NULL;
    bufrec.size = 0;
    bufrec.mode = SCM_PORT_BUFFER_FULL;
    bufrec.filler = fcgi_filler;
    bufrec.flusher = fcgi_flusher;

    /* Don't close underlying stream explicitly; leave it to FCGX_Accept */
    bufrec.closer = NULL;

    bufrec.ready = NULL;
    bufrec.filenum = NULL;
    bufrec.seeker = NULL;
    bufrec.data = stream;

    p = Scm_MakeBufferedPort(SCM_CLASS_PORT, SCM_MAKE_STR("(fastcgi)"),
                             stream->isReader?SCM_PORT_INPUT:SCM_PORT_OUTPUT,
                             TRUE, &bufrec);
    return p;
}

ScmObj Scm_MakeFcgxStream(FCGX_Stream *stream)
{
    ScmFcgxStream *s = SCM_NEW(ScmFcgxStream);
    SCM_SET_CLASS(s, SCM_CLASS_FCGX_STREAM);
    s->stream = stream;
    return SCM_OBJ(s);
}

ScmObj Scm_Init_fastcgi(void)
{
    ScmModule *mod;

    SCM_INIT_EXTENSION(fastcgi);
    mod = SCM_MODULE(SCM_FIND_MODULE("www.fastcgi", TRUE));
    Scm_Init_fcgi(mod);
}
