
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#include <math.h>

_inline void bios_soft_reset()
{	/*CPUƓRAM̏*/
	console_print("swi 0 (SoftReset)");
	agb_initialize_register();
	arm.reg[15] = (!InWRam[0x7FFA])?0x08000000:0x02000000;
	agb_initialize_memory();
}

_inline void bios_register_ram_reset()
{	/*tOƓRAM̏*/
	console_print("swi 01h (RegisterRamReset)");
	memset(InWRam, 0, 0x7E00);	/*3007E00h-3007FFFh͏Ȃ*/
	CPSR	=	0x0000001F;	/*R16==CPSR Xe[^XWX^*/
}

_inline void bios_halt()
{
	console_print("swi 02h (Halt)");
}

_inline void bios_stop()
{
	console_print("swi 03h (Stop)");
}

_inline void bios_intr_wait()
{
	console_print("swi 04h (IntrWait)");
}

_inline void bios_vblank_intr_wait()
{
	console_print("swi 05h (VBlankIntrWait)");
}

_inline void bios_div()
{
	console_print("swi 06h (Div)");
	arm.reg[1] = arm.reg[0] % arm.reg[1];
	arm.reg[3] = abs(arm.reg[0] / arm.reg[1]);
	arm.reg[0] = arm.reg[0] / arm.reg[1];
}

_inline void bios_div_arm()
{
	console_print("swi 07h (DivArm)");
	arm.reg[1] = arm.reg[1] % arm.reg[0];
	arm.reg[3] = abs(arm.reg[1] / arm.reg[0]);
	arm.reg[0] = arm.reg[1] / arm.reg[0];
}

_inline void bios_sqrt()
{
	console_print("swi 08h (Sqrt)");
	arm.reg[0] = (u32)sqrt(arm.reg[0]);
}

_inline void bios_arc_tan()
{
	console_print("swi 09h (ArcTan)");
	arm.reg[0] = (u32)tan(arm.reg[0]);
}

_inline void bios_arc_tan2()
{
	console_print("swi 0Ah (ArcTan2)");
	arm.reg[0] = (u32)tan(arm.reg[0]);
}
