
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/


inline void agb_draw_mode0_bg(u16 *pmap16, u32 bg)
{	/*mode 0 ^C*/
	u32	x, y, tile_x, tile_y;
	u32	base_char, base_map;
	u16	temp16;
	u16	*bgcnt;
	u16 *ppal16;
	u8	*vram;

	bgcnt = &io_lcd->bg0cnt;
	bgcnt += bg;

	ppal16	= (u16*)PalRam;
	base_char = ((*bgcnt>>2) & 3) * 256 * 64;	/*16KBP*/
	base_map = ((*bgcnt>>8) & 0x1F) * 1024 * 2;	/*2KBP*/
	for(y = 0; y < LCD_Y; y += 8){
		for(x = 0; x < LCD_X; x += 8){
			vram = &VRam[VRam[base_map + (x + y * ((*bgcnt & BIT_14_)?64:32)) / 4] * 64 + base_char];
			for(tile_y = 0; tile_y < 8; tile_y++){
				for(tile_x = 0; tile_x < 8; tile_x++){
					if(*vram){
						temp16 = ppal16[*vram++];
						temp16 = SWAP_RB(temp16);
						pmap16[tile_x + x + (tile_y + y) * LCD_X] = temp16;
					}
				}
			}
		}
	}
}

inline void agb_draw_mode3_bg(u16 *pmap16)
{	/*mode 3 rbg}bv*/
	s32 scr_x, scr_y;
	u16	temp16;
	u16 *pvram16;

	pvram16 = (u16*)VRam;
	for(scr_y = 0; scr_y < LCD_Y; scr_y++){
		for(scr_x = 0; scr_x < LCD_X; scr_x++){
			temp16 = *pvram16++;
			*pmap16++ = SWAP_RB(temp16);
		}
	}
/*
	s32 buf_x, buf_y;
	s32	init_x, init_y;
	s32	buf_offset;
	u32	temp32;

	temp32	= io_lcd->bg2x;
	init_x	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_x	= init_x - (0x80000<<1);
	}

	temp32	= io_lcd->bg2y;
	init_y	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_y	= init_y - (0x80000<<1);
	}

	for(scr_y = 0, buf_y = init_y; scr_y < LCD_Y; scr_y++, buf_y++){
		buf_offset = (buf_y * LCD_X)<<1;
		pvram16 = (u16*)&VRam[buf_offset];
		for(scr_x = 0, buf_x = init_x; scr_x < LCD_X; scr_x++, buf_x++){
			if(buf_x >= 0 && buf_y >= 0 &&
				buf_x < LCD_X && buf_y < LCD_Y){
				temp16 = *pvram16++;
				temp16 = SWAP_RB(temp16);
			}else{
				temp16 = 0;
			}
			*pmap16++ = temp16;
		}
	}
*/
}

inline void agb_draw_mode4_bg(u16 *pmap16)
{	/*mode 4 pbg*/
	s32 scr_x, scr_y;
	u16	temp16;
	u16 *ppal16;
	u8	*vram;

	ppal16 = (u16*)PalRam;
	vram = &VRam[(io_lcd->dispcnt & BIT_4_)?LCD_X * LCD_Y:0];	/*obNobt@̑I*/
	for(scr_y = 0; scr_y < LCD_Y; scr_y++){
		for(scr_x = 0; scr_x < LCD_X; scr_x++){
			temp16 = ppal16[*vram++];
			*pmap16++ = SWAP_RB(temp16);
		}
	}
/*
	s32 buf_x, buf_y;
	s32	init_x, init_y;
	s32	buf_offset;
	u32	temp32;
	u8	*bbuf;

	temp32	= io_lcd->bg2x;
	init_x	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_x	= init_x - (0x80000<<1);
	}

	temp32	= io_lcd->bg2y;
	init_y	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_y	= init_y - (0x80000<<1);
	}

	ppal16 = (u16*)PalRam;
	bbuf = &VRam[(io_lcd->dispcnt & BIT_4_)?LCD_X * LCD_Y:0];
	for(scr_y = 0, buf_y = init_y; scr_y < LCD_Y; scr_y++, buf_y++){
		buf_offset = buf_y * LCD_X;
		vram = &bbuf[buf_offset];
		for(scr_x = 0, buf_x = init_x; scr_x < LCD_X; scr_x++, buf_x++){
			if(buf_x >= 0 && buf_y >= 0 &&
				buf_x < LCD_X && buf_y < LCD_Y){
				temp16 = ppal16[*vram++];
				temp16 = SWAP_RB(temp16);
			}else{
				temp16 = 0;
			}
			*pmap16++ = temp16;
		}
	}
*/
}

inline void agb_draw_mode5_bg(u16 *pmap16)
{	/*mode 5 rbg}bv*/
	s32 scr_x, scr_y;
	u16	temp16;
	u16 *pvram16;

	pvram16 = (u16*)&VRam[(io_lcd->dispcnt & BIT_4_)?160 * 128 * 2:0];	/*obNobt@̑I*/
	for(scr_y = 0; scr_y < 128; scr_y++){
		for(scr_x = 0; scr_x < 160; scr_x++){
			temp16 = *pvram16++;
			temp16 = SWAP_RB(temp16);
			*pmap16++ = temp16;
		}
		pmap16 += LCD_X - 160;
	}
/*
	s32 buf_x, buf_y;
	s32	init_x, init_y;
	s32	buf_offset;
	u32	temp32;

	temp32	= io_lcd->bg2x;
	init_x	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_x	= init_x - (0x80000<<1);
	}

	temp32	= io_lcd->bg2y;
	init_y	= (temp32>>8) & 0xFFFFF;
	if(temp32 & BIT_27_){
		init_y	= init_y - (0x80000<<1);
	}

	for(scr_y = 0, buf_y = init_y; scr_y < LCD_Y; scr_y++, buf_y++){
		buf_offset = (buf_y * 160)<<1;
		pvram16 = (u16*)&VRam[buf_offset];
		for(scr_x = 0, buf_x = init_x; scr_x < LCD_X; scr_x++, buf_x++){
			if(buf_x >= 0 && buf_y >= 0 &&
				buf_x < 160 && buf_y < 128){
				temp16 = *pvram16++;
				temp16 = SWAP_RB(temp16);
			}else{
				temp16 = 0;
			}
			*pmap16++ = temp16;
		}
	}
*/
}

void CChildView::agb_draw_lcd()
{
	u16	dispcnt;
	u16 *pmap16;
	s32	i;

	dispcnt = io_lcd->dispcnt;
	pmap16 = (u16*)pBitmap;

	switch((u8)(dispcnt & 7)){
	case 0:
	case 1:
	case 2:
		memset(pBitmap, 0, LCD_X * LCD_Y *2);
		for(i = 3; i >= 0; i--){	/*DxɂBG̕`揇*/
			if((io_lcd->bg0cnt & 0x03)==i){
				if(dispcnt & BIT_8_)agb_draw_mode0_bg(pmap16, 0);
			}
			if((io_lcd->bg1cnt & 0x03)==i){
				if(dispcnt & BIT_9_)agb_draw_mode0_bg(pmap16, 1);
			}
			if((io_lcd->bg2cnt & 0x03)==i){
				if(dispcnt & BIT_10_)agb_draw_mode0_bg(pmap16, 2);
			}
			if((io_lcd->bg3cnt & 0x03)==i){
				if(dispcnt & BIT_11_)agb_draw_mode0_bg(pmap16, 3);
			}
		}
		break;
	case 4:
	case 6:
		agb_draw_mode4_bg(pmap16);
		break;
	case 5:
		agb_draw_mode5_bg(pmap16);
		break;
	case 3:
	default:
		agb_draw_mode3_bg(pmap16);
		break;
	}

	hDC = GetDC()->m_hDC;
	StretchBlt(hDC, 0, 0, clientSize.right, clientSize.bottom, hMemDC,
					0, 0, LCD_X, LCD_Y, SRCCOPY);
	ReleaseDC(GetDC());
}

inline void agb_draw_line()
{

}

