
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_DEFINES_
#define	_DEFINES_


#include "types.h"
#include "gba.h"

#ifdef _DEBUG
#define	_TITLE_		"Debug"
#else
#define	_TITLE_		"GameboyAdvanceVM"
#endif

typedef struct{
	u8	low;
	u8	high;
}REG8;

typedef struct{
	u16	low;
	u16	high;
}REG16;

typedef union{
	REG8	reg8;
	u16		reg16;
}P16;

typedef union{
	REG16	reg16;
	u32		reg32;
}P32;

typedef struct{
	u32 reg[17];
	u32 cycle;
	u32	opcode;
	int	running;
}ARM7TDMI;

typedef	struct{
	u16	dispcnt;
	u16 notused0;
	u16	dispstat;
	u16	vcount;
	
	u16	bg0cnt;
	u16	bg1cnt;
	u16	bg2cnt;
	u16	bg3cnt;

	u16	bg0hofs;
	u16	bg0vofs;
	u16	bg1hofs;
	u16	bg1vofs;
	u16	bg2hofs;
	u16	bg2vofs;
	u16	bg3hofs;
	u16	bg3vofs;

	u16	bg2pa;
	u16	bg2pb;
	u16	bg2pc;
	u16	bg2pd;

	u32	bg2x;
	u32	bg2y;

	u16	bg3pa;
	u16	bg3pb;
	u16	bg3pc;
	u16	bg3pd;

	u32	bg3x;
	u32	bg3y;

	u16	win0h;
	u16	win1h;
	u16	win0v;
	u16	win1v;
	u16	winin;
	u16	winout;
	u16	mosaic;

	u16	notused1;

	u16	bldcnt;
	u16	bldalpha;
	u16	bldy;
}AGBIOLCD;

typedef struct{
	u32	dma0sad;
	u32	dma0dad;
	u16	dma0cnt_l;
	u16	dma0cnt_h;
	u32	dma1sad;
	u32	dma1dad;
	u16	dma1cnt_l;
	u16	dma1cnt_h;
	u32	dma2sad;
	u32	dma2dad;
	u16	dma2cnt_l;
	u16	dma2cnt_h;
	u32	dma3sad;
	u32	dma3dad;
	u16	dma3cnt_l;
	u16	dma3cnt_h;
}AGBIODMA;

typedef struct{
	u16	tm0cnt_l;
	u16	tm0cnt_h;
	u16	tm1cnt_l;
	u16	tm1cnt_h;
	u16	tm2cnt_l;
	u16	tm2cnt_h;
	u16	tm3nt_l;
	u16	tm3cnt_h;
}AGBIOTM;

typedef struct{
	u16	keyinput;
	u16	keycnt;
}AGBIOKEY;

typedef struct{
	u16	ie;
	u16	If;
	u16	waitcnt;
	u16	notused0;
	u16	ime;
	u16	notused1;
}AGBIOIRQ;

#define	R0		arm.reg[0]
#define	R1		arm.reg[1]
#define	R2		arm.reg[2]
#define	R3		arm.reg[3]
#define	R4		arm.reg[4]
#define	R5		arm.reg[5]
#define	R6		arm.reg[6]
#define	R7		arm.reg[7]
#define	R8		arm.reg[8]
#define	R9		arm.reg[9]
#define	R10		arm.reg[10]
#define	R11		arm.reg[11]
#define	R12		arm.reg[12]
#define	R13		arm.reg[13]
#define	R14		arm.reg[14]
#define	R15		arm.reg[15]
#define	R16		arm.reg[16]
#define	SR		arm.reg[13]
#define	SP		arm.reg[13]
#define	LR		arm.reg[14]
#define	PC		arm.reg[15]
#define	CPSR	arm.reg[16]
#define CLK		Cycle
#define	CPUIsRunning	arm.running

#define	N_	0x80000000	/* Negative/Less Than*/
#define	Z_	0x40000000	/* Zero/Equal*/
#define	C_	0x20000000	/* Carry/Borrow/Extend*/
#define	V_	0x10000000	/* Overflow*/
#define	I_	0x00000080	/* IRQ Disable*/
#define	F_	0x00000040	/* FIQ Disable*/
#define	T_	0x00000020	/* THUMB State*/
#define	M4_	0x00000010	/* Mode 4-0*/
#define	M3_	0x00000008
#define	M2_	0x00000004
#define	M1_	0x00000002
#define	M0_	0x00000001

#define	BIT_0_	0x00000001
#define	BIT_1_	0x00000002
#define	BIT_2_	0x00000004
#define	BIT_3_	0x00000008
#define	BIT_4_	0x00000010
#define	BIT_5_	0x00000020
#define	BIT_6_	0x00000040
#define	BIT_7_	0x00000080
#define	BIT_8_	0x00000100
#define	BIT_9_	0x00000200
#define	BIT_10_	0x00000400
#define	BIT_11_	0x00000800
#define	BIT_12_	0x00001000
#define	BIT_13_	0x00002000
#define	BIT_14_	0x00004000
#define	BIT_15_	0x00008000
#define	BIT_16_	0x00010000
#define	BIT_17_	0x00020000
#define	BIT_18_	0x00040000
#define	BIT_19_	0x00080000
#define	BIT_20_	0x00100000
#define	BIT_21_	0x00200000
#define	BIT_22_	0x00400000
#define	BIT_23_	0x00800000
#define	BIT_24_	0x01000000
#define	BIT_25_	0x02000000
#define	BIT_26_	0x04000000
#define	BIT_27_	0x08000000
#define	BIT_28_	0x10000000
#define	BIT_29_	0x20000000
#define	BIT_30_	0x40000000
#define	BIT_31_	0x80000000
#define	BIT_32_	0x100000000

#define	BIT_A_	0x00000400
#define	BIT_B_	0x00000800
#define	BIT_C_	0x00001000
#define	BIT_D_	0x00002000
#define	BIT_E_	0x00004000
#define	BIT_F_	0x00008000

#define	SF(_flag)	arm.reg[16]|=(_flag)
#define	RF(_flag)	arm.reg[16]&=~(_flag)

#define	FN	(arm.reg[16] & 0x80000000)
#define	FZ	(arm.reg[16] & 0x40000000)
#define	FC	(arm.reg[16] & 0x20000000)
#define	FV	(arm.reg[16] & 0x10000000)

#define	LSB_FC	((arm.reg[16]>>29) & 1)

#define	LCD_X		240
#define	LCD_Y		160
#define	SIZE_SYSROM	(0x4000 + 4)
#define	SIZE_EXWRAM	(0x40000 + 4)
#define	SIZE_INWRAM	(0x8000 + 4)
#define	SIZE_IORAM	(0x400 + 4)
#define	SIZE_PALRAM	(0x400 + 4)
#define	SIZE_VRAM	(0x18000 + 4)
#define	SIZE_OAM	(0x400 + 4)

#define	OPCODE		agb_read_mem32(arm.reg[15])

/*BGRRGBɕϊ*/
#define	SWAP_RB(col)	((col&0x7F00)>>10) | (col&0x03E0) | ((col&0x001F)<<10)

#ifdef	WIN32_MAIN
#define	console_print(_str_)	m_pTraceDlg->m_lstTrace.AddString(_str_)
#define	WM_DRAW_LCD		(WM_USER + 10)
#define	WM_DEBUG_NEXT	(WM_USER + 11)
#else
#define	console_print(_str_)
#endif	/*WIN32_MAIN*/

#ifndef	_GBAEMU_
extern ARM7TDMI arm;
#endif


#endif	/*_DEFINES_*/
