
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_EXTERNS_
#define	_EXTERNS_

#include "../include/defines.h"

extern u8	SysRom[SIZE_SYSROM];
extern u8	ExWRam[SIZE_EXWRAM];
extern u8	InWRam[SIZE_INWRAM];
extern u8	IoRam[SIZE_IORAM];
extern u8	PalRam[SIZE_PALRAM];
extern u8	VRam[SIZE_VRAM];
extern u8	Oam[SIZE_OAM];
extern u8	*Rom;

extern ARM7TDMI arm;
extern AGBIOLCD *io_lcd;
extern AGBIODMA *io_dma;
extern AGBIOTM  *io_tm;
extern AGBIOKEY *io_key;

extern u32	filesize;
extern int htime;

extern u32	FrameCount;

extern u32	BreakPoint1;
extern u32	BreakPoint2;
extern u32	BreakPoint3;
extern u32	BreakPoint4;
extern BOOL fAutoUpdate;
extern BOOL fAutoRun;
extern BOOL fBreak;
extern BOOL fNext;
extern BOOL fFps;
extern BOOL fVsync;

extern BOOL fRegisterDlg;
extern BOOL fDisassemblerDlg;
extern BOOL fMemoryDlg;
extern BOOL fOamDlg;
extern BOOL fDispcntDlg;
extern BOOL fTraceDlg;
extern BOOL fHardioDlg;
extern BOOL fTileDlg;
extern RECT clientSize;

extern u16	FrameBuffer[240 * 160];

extern u8	agb_size_sprite[16][2];

extern u8 agb_read_mem8(u32 adr);
extern u16 agb_read_mem16(u32 adr);
extern u32 agb_read_mem32(u32 adr);
extern void agb_write_mem16(u32 adr, u16 val);


#endif	/*_EXTERNS_*/
