
/*	
	GameboyAdvanceVM 
		- Nintendo GameboyAdvance Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbaemu/
*/

#ifndef	_GLOBALS_
#define	_GLOBALS_


u8	SysRom[SIZE_SYSROM];
u8	ExWRam[SIZE_EXWRAM];
u8	InWRam[SIZE_INWRAM];
u8	IoRam[SIZE_IORAM];
u8	PalRam[SIZE_PALRAM];
u8	VRam[SIZE_VRAM];
u8	Oam[SIZE_OAM];
u8	*Rom;

ARM7TDMI arm;
AGBIOLCD *io_lcd = (AGBIOLCD*)&IoRam[0x000];
AGBIODMA *io_dma = (AGBIODMA*)&IoRam[0x0B0];
AGBIOTM	 *io_tm  = (AGBIOTM*)&IoRam[0x100];
AGBIOKEY *io_key = (AGBIOKEY*)&IoRam[0x130];
AGBIOIRQ *io_irq = (AGBIOIRQ*)&IoRam[0x200];

u32	filesize;

s32 htime;

u32	FrameCount;
u32	FrameRate;
u32	FrameSkip;

u32	BreakPoint1;
u32	BreakPoint2;
u32	BreakPoint3;
u32	BreakPoint4;

BOOL fEnableBios;
BOOL fAutoUpdate;
BOOL fAutoRun;
BOOL fBreak;
BOOL fNext;
BOOL fFps;
BOOL fVsync;

BOOL fRegisterDlg;
BOOL fDisassemblerDlg;
BOOL fMemoryDlg;
BOOL fOamDlg;
BOOL fDispcntDlg;
BOOL fTraceDlg;
BOOL fHardioDlg;
BOOL fTileDlg;
RECT clientSize;

u16	FrameBuffer[240 * 160];

u8	agb_size_sprite[16][2] = 
{	/*XvCgTCYe[u*/
	8, 8,
	16, 16,
	32, 32,
	64, 64,
	16, 8,
	32, 8,
	32, 16,
	64, 32,
	8, 16,
	8, 32,
	16, 32,
	32, 64,
	0, 0,
	0, 0,
	0, 0,
	0, 0,
};


#endif	/*_GLOBALS_*/
