// DispcntDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "DispcntDlg.h"

#define	WIN32_MAIN
#include "../include/externs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern DWORD dwSize;
LPBITMAPINFO disp_info;

/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg _CAO


CDispcntDlg::CDispcntDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDispcntDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDispcntDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDispcntDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDispcntDlg, CDialog)
	//{{AFX_MSG_MAP(CDispcntDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_BN_CLICKED(IDC_RADIO_MODE0, OnRadioMode0)
	ON_BN_CLICKED(IDC_RADIO_MODE1, OnRadioMode1)
	ON_BN_CLICKED(IDC_RADIO_MODE2, OnRadioMode2)
	ON_BN_CLICKED(IDC_RADIO_MODE3, OnRadioMode3)
	ON_BN_CLICKED(IDC_RADIO_MODE4, OnRadioMode4)
	ON_BN_CLICKED(IDC_RADIO_MODE5, OnRadioMode5)
	ON_BN_CLICKED(IDC_RADIO_MODE6, OnRadioMode6)
	ON_BN_CLICKED(IDC_RADIO_MODE7, OnRadioMode7)
	ON_BN_CLICKED(IDC_BUTTON_DUMMY_PALETTE, OnButtonDummyPalette)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDispcntDlg bZ[W nh

void CDispcntDlg::OnOK()
{
	OnClose();
}

void CDispcntDlg::OnCancel()
{
	OnClose();
}

BOOL CDispcntDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	disp_info = (LPBITMAPINFO)new char[dwSize];

	memset(disp_info, 0, sizeof(BITMAPINFOHEADER));
	disp_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	disp_info->bmiHeader.biWidth	= 240;
	disp_info->bmiHeader.biHeight	= -160;
	disp_info->bmiHeader.biPlanes	= 1;
	disp_info->bmiHeader.biBitCount	= 16;

	memset(DispBuffer, 0, 240 * 160 * 2);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_DISPCNT_LCD), 0, 10, 10,
					240, 160, SWP_NOACTIVATE | SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_PALETTE), 0, 10, 180,
					240, 220, SWP_NOACTIVATE | SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDispcntDlg::ShowDispcnt()
{
	u32	dispcnt;
	CButton* pBPchk;

	DrawDispcntPlatte();

	dispcnt = agb_read_mem32(REG_DISPCNT);

	m_temp_mode = dispcnt & 7;

	switch((u8)m_temp_mode){
	case 0:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE0);
		break;
	case 1:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE1);
		break;
	case 2:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE2);
		break;
	case 3:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE3);
		break;
	case 4:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE4);
		break;
	case 5:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE5);
		break;
	case 6:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE6);
		break;
	case 7:
		CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE7);
		break;
	}

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG0);
	pBPchk->SetCheck((dispcnt & BG0_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG1);
	pBPchk->SetCheck((dispcnt & BG1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG2);
	pBPchk->SetCheck((dispcnt & BG2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BG3);
	pBPchk->SetCheck((dispcnt & OBJ_ENABLE)?1:0);
	
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN0);
	pBPchk->SetCheck((dispcnt & WIN1_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN1);
	pBPchk->SetCheck((dispcnt & WIN2_ENABLE)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_WIN2);
	pBPchk->SetCheck((dispcnt & WINOBJ_ENABLE)?1:0);

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BACKBUFFER);
	pBPchk->SetCheck((dispcnt & BACKBUFFER)?1:0);
}

void CDispcntDlg::DrawDispcntLcd()
{	/*obNobt@\*/
	u32		i;
	u16		temp;
	HBITMAP	hBitmap, hOldmap;
	HDC		hDC, hMemDC;

	hDC = GetDlgItem(IDC_DISPCNT_LCD)->GetDC()->m_hDC;

	/*mode 4 pbg*/
	if(m_temp_mode == 4){
		for(i=0; i<(LCD_X * LCD_Y); i++){
			temp = PalRam[VRam[i]<<1] | (PalRam[(VRam[i]<<1) + 1]<<8);
			temp = SWAP_RB(temp);
			DispBuffer[i<<1]	= (u8)temp;
			DispBuffer[(i<<1) + 1]	= (u8)(temp>>8);
		}
	/*mode 3 rbg}bv*/
	}else if(m_temp_mode == 3){
		for(i=0; i<(LCD_X * LCD_Y * 2); i+=2){
			temp = VRam[i] | (VRam[i + 1]<<8);
			temp = SWAP_RB(temp);	/*BGRRGB֕ϊ*/
			DispBuffer[i]		= (u8)temp;
			DispBuffer[i + 1]	= (u8)(temp>>8);
		}
	}

	hMemDC	= CreateCompatibleDC(hDC);
	hBitmap	= CreateDIBitmap(hDC, &disp_info->bmiHeader, CBM_INIT, 
								DispBuffer, disp_info, DIB_RGB_COLORS);
	hOldmap	= (HBITMAP)SelectObject(hMemDC, hBitmap);
	StretchBlt(hDC, 0, 0, 240, 160, hMemDC, 0, 0, 240, 160, SRCCOPY);
	DeleteObject(hBitmap);
}

void CDispcntDlg::DrawDispcntPlatte()
{
	u32		x, y, offset_x, offset_y;
	u32		color32;
	u16		color16;
	RECT	rect;
	CDC		*pDC;

	offset_x = 20;
	offset_y = 200;

	pDC = this->GetDC();
	for(y = 0; y < 16; y++){
		for(x = 0; x < 16; x++){
			rect.left	= x * 14 + offset_x;
			rect.top	= y * 12 + offset_y;
			rect.right	= rect.left + 10;
			rect.bottom	= rect.top + 8;
			color16		= PalRam[(x + y * 16) * 2] | (PalRam[(x + y * 16) * 2 + 1]<<8);
			color16		= SWAP_RB(color16);
			color32		= RGB(((color16>>10) & 0x1F)<<3, 
							((color16>>5) & 0x1F)<<3, 
							((color16>>0) & 0x1F)<<3);
			pDC->FillSolidRect(&rect, (COLORREF)color32);
		}
	}

	ReleaseDC(pDC);
}

void CDispcntDlg::OnClose() 
{
	fDispcntDlg	= FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

BOOL CDispcntDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(WM_KEYDOWN==pMsg->message){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return FALSE;
		case VK_RETURN:
			return FALSE;
		default:
			break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CDispcntDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	DrawDispcntLcd();
	DrawDispcntPlatte();
	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CDispcntDlg::OnButtonUpdate() 
{
	ShowDispcnt();
	DrawDispcntLcd();
	DrawDispcntPlatte();
}

void CDispcntDlg::OnRadioMode0() 
{
	m_temp_mode = 0;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE0);
}

void CDispcntDlg::OnRadioMode1() 
{
	m_temp_mode = 1;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE1);
}

void CDispcntDlg::OnRadioMode2() 
{
	m_temp_mode = 2;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE2);
}

void CDispcntDlg::OnRadioMode3() 
{
	m_temp_mode = 3;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE3);
}

void CDispcntDlg::OnRadioMode4() 
{
	m_temp_mode = 4;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE4);
}

void CDispcntDlg::OnRadioMode5() 
{
	m_temp_mode = 5;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE5);
}

void CDispcntDlg::OnRadioMode6() 
{
	m_temp_mode = 6;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE6);
}

void CDispcntDlg::OnRadioMode7() 
{
	m_temp_mode = 7;
	DrawDispcntLcd();
	CheckRadioButton(IDC_RADIO_MODE0, IDC_RADIO_MODE7, IDC_RADIO_MODE7);
}

void CDispcntDlg::OnButtonDummyPalette() 
{
	int i, j, k;

	for(i = j = 0; i < 0x400; i += 2){
		k = j>>2;
		PalRam[i] = ((k&0x1F)<<5) | (k&0x1F);
		PalRam[i + 1] = (((k&0x1F)<<10) | ((k&0x1F)<<5))>>8;
		j++;
	}

	ShowDispcnt();
}
