// HardioDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbaemu.h"
#include "HardioDlg.h"

#define	WIN32_MAIN
#include "../include/hextoint.h"
#include "../include/externs.h"
#include "../include/io_table.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHardioDlg _CAO


CHardioDlg::CHardioDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHardioDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardioDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CHardioDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardioDlg)
	DDX_Control(pDX, IDC_LIST_TYPE, m_lstIo);
	DDX_Control(pDX, IDC_COMBO_TYPE, m_cmbIo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardioDlg, CDialog)
	//{{AFX_MSG_MAP(CHardioDlg)
	ON_WM_CLOSE()
	ON_CBN_SELCHANGE(IDC_COMBO_TYPE, OnSelchangeComboType)
	ON_LBN_SELCHANGE(IDC_LIST_TYPE, OnSelchangeListType)
	ON_BN_CLICKED(IDC_CHECK_DEFINED, OnCheckDefined)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, OnButtonUpdate)
	ON_BN_CLICKED(IDC_CHECK_BIT0, OnCheckBit0)
	ON_BN_CLICKED(IDC_CHECK_BIT1, OnCheckBit1)
	ON_BN_CLICKED(IDC_CHECK_BIT2, OnCheckBit2)
	ON_BN_CLICKED(IDC_CHECK_BIT3, OnCheckBit3)
	ON_BN_CLICKED(IDC_CHECK_BIT4, OnCheckBit4)
	ON_BN_CLICKED(IDC_CHECK_BIT5, OnCheckBit5)
	ON_BN_CLICKED(IDC_CHECK_BIT6, OnCheckBit6)
	ON_BN_CLICKED(IDC_CHECK_BIT7, OnCheckBit7)
	ON_BN_CLICKED(IDC_CHECK_BIT8, OnCheckBit8)
	ON_BN_CLICKED(IDC_CHECK_BIT9, OnCheckBit9)
	ON_BN_CLICKED(IDC_CHECK_BIT10, OnCheckBit10)
	ON_BN_CLICKED(IDC_CHECK_BIT11, OnCheckBit11)
	ON_BN_CLICKED(IDC_CHECK_BIT12, OnCheckBit12)
	ON_BN_CLICKED(IDC_CHECK_BIT13, OnCheckBit13)
	ON_BN_CLICKED(IDC_CHECK_BIT14, OnCheckBit14)
	ON_BN_CLICKED(IDC_CHECK_BIT15, OnCheckBit15)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardioDlg bZ[W nh

void CHardioDlg::OnOK()
{
	OnClose();
}

void CHardioDlg::OnCancel()
{
	OnClose();
}

BOOL CHardioDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	int i;
	char str[128];

	for(i = 0; i < 8; i++){
		sprintf(str, "%03Xh %s", iotype_offset_table[i], ioname_table[i]);
		m_cmbIo.AddString(str);
	}
	m_cmbIo.SetCurSel(0);

	for(i = 0; i < 43; i++){
		sprintf(str, "%03Xh %s", i * 2, _lcd_ioname_table[i]);
		m_lstIo.AddString(str);
	}
	m_lstIo.SetCurSel(0);

	sprintf(str, "%08X", 0x04000000);
	SetDlgItemText(IDC_EDIT_IO_ADDRESS, str);
/*
	CFont* m_pFont = new CFont;
	m_pFont->CreatePointFont(8, _T("Courier"));	// tHg
	m_lstIo.SetFont(m_pFont);
*/
	m_io_types	=	0;
	m_io_regs	=	0;
	m_fDefname	=	FALSE;

	OnSelchangeComboType();
	OnSelchangeListType();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CHardioDlg::OnClose() 
{
	fHardioDlg	= FALSE;
	EndDialog(0);
	//CDialog::OnClose();
}

void CHardioDlg::ClickedShowHardio()
{
	u32 address, value;
	char str[128];
	CButton* pBPchk;

	GetDlgItemText(IDC_EDIT_IO_ADDRESS, str, sizeof(str));
	address = HexToInt(str);

	value	= agb_read_mem16(address);

	sprintf(str, "%X", value);
	SetDlgItemText(IDC_EDIT_IO_VALUE, str);

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT0);
	pBPchk->SetCheck((value & BIT_0_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT1);
	pBPchk->SetCheck((value & BIT_1_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT2);
	pBPchk->SetCheck((value & BIT_2_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT3);
	pBPchk->SetCheck((value & BIT_3_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT4);
	pBPchk->SetCheck((value & BIT_4_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT5);
	pBPchk->SetCheck((value & BIT_5_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT6);
	pBPchk->SetCheck((value & BIT_6_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT7);
	pBPchk->SetCheck((value & BIT_7_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT8);
	pBPchk->SetCheck((value & BIT_8_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT9);
	pBPchk->SetCheck((value & BIT_9_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT10);
	pBPchk->SetCheck((value & BIT_10_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT11);
	pBPchk->SetCheck((value & BIT_11_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT12);
	pBPchk->SetCheck((value & BIT_12_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT13);
	pBPchk->SetCheck((value & BIT_13_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT14);
	pBPchk->SetCheck((value & BIT_14_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT15);
	pBPchk->SetCheck((value & BIT_15_)?1:0);
}

void CHardioDlg::ShowHardio()
{
	u32 address, value;
	char str[128];
	CButton* pBPchk;

	m_io_types	= m_cmbIo.GetCurSel();
	m_io_regs	= m_lstIo.GetCurSel();
	address = iotype_offset_table[m_io_types] + m_io_regs * 2 + 0x04000000;
	sprintf(str, "%08X", address);
	SetDlgItemText(IDC_EDIT_IO_ADDRESS, str);

	value	= agb_read_mem16(address);

	sprintf(str, "%X", value);
	SetDlgItemText(IDC_EDIT_IO_VALUE, str);

	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT0);
	pBPchk->SetCheck((value & BIT_0_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT1);
	pBPchk->SetCheck((value & BIT_1_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT2);
	pBPchk->SetCheck((value & BIT_2_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT3);
	pBPchk->SetCheck((value & BIT_3_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT4);
	pBPchk->SetCheck((value & BIT_4_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT5);
	pBPchk->SetCheck((value & BIT_5_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT6);
	pBPchk->SetCheck((value & BIT_6_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT7);
	pBPchk->SetCheck((value & BIT_7_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT8);
	pBPchk->SetCheck((value & BIT_8_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT9);
	pBPchk->SetCheck((value & BIT_9_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT10);
	pBPchk->SetCheck((value & BIT_10_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT11);
	pBPchk->SetCheck((value & BIT_11_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT12);
	pBPchk->SetCheck((value & BIT_12_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT13);
	pBPchk->SetCheck((value & BIT_13_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT14);
	pBPchk->SetCheck((value & BIT_14_)?1:0);
	pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BIT15);
	pBPchk->SetCheck((value & BIT_15_)?1:0);
}

void CHardioDlg::OnSelchangeComboType() 
{
	u32 i;
	char str[128];

	switch((BYTE)m_cmbIo.GetCurSel()){
	case 0:
		m_lstIo.ResetContent();
		for(i = 0; i < 43; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[0], 
				m_fDefname?lcd_ioname_table[i]:_lcd_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 1:
		m_lstIo.ResetContent();
		for(i = 0; i < 36; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[1], 
				m_fDefname?sound_ioname_table[i]:_sound_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 2:
		m_lstIo.ResetContent();
		for(i = 0; i < 24; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[2], 
				m_fDefname?dma_ioname_table[i]:_dma_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 3:
		m_lstIo.ResetContent();
		for(i = 0; i < 8; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[3], 
				m_fDefname?timer_ioname_table[i]:_timer_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 4:
		m_lstIo.ResetContent();
		for(i = 0; i < 6; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[4], 
				m_fDefname?sio1_ioname_table[i]:_sio1_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 5:
		m_lstIo.ResetContent();
		for(i = 0; i < 2; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[5], 
				m_fDefname?key_ioname_table[i]:_key_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 6:
		m_lstIo.ResetContent();
		for(i = 0; i < 19; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[6], 
				m_fDefname?sio2_ioname_table[i]:_sio2_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	case 7:
		m_lstIo.ResetContent();
		for(i = 0; i < 5; i++){
			sprintf(str, "%03Xh %s", i * 2 + iotype_offset_table[7], 
				m_fDefname?irq_ioname_table[i]:_irq_ioname_table[i]);
			m_lstIo.AddString(str);
		}
		break;
	}
	m_lstIo.SetCurSel(0);

	ShowHardio();
}

void CHardioDlg::OnSelchangeListType() 
{	/*`FbN{bNX̕Ɩ*/
	u32	index;
	char **str_ptr;

	index = m_lstIo.GetCurSel();
	str_ptr = lcd_flagname_table[index];

	SetDlgItemText(IDC_CHECK_BIT0, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT0)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT1, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT1)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT2, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT2)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT3, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT3)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT4, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT4)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT5, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT5)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT6, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT6)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT7, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT7)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT8, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT8)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT9, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT9)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT10, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT10)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT11, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT11)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT12, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT12)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT13, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT13)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT14, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT14)->EnableWindow(**str_ptr++);
	SetDlgItemText(IDC_CHECK_BIT15, *str_ptr);
	GetDlgItem(IDC_CHECK_BIT15)->EnableWindow(**str_ptr++);

	ShowHardio();
}

void CHardioDlg::OnCheckDefined() 
{
	m_fDefname = !m_fDefname;
	OnSelchangeComboType();
}

void CHardioDlg::OnButtonUpdate() 
{
	ShowHardio();
}

void CHardioDlg::OnCheckBit0() 
{
	BitChange(0);
}

void CHardioDlg::OnCheckBit1() 
{
	BitChange(1);
}

void CHardioDlg::OnCheckBit2() 
{
	BitChange(2);
}

void CHardioDlg::OnCheckBit3() 
{
	BitChange(3);
}

void CHardioDlg::OnCheckBit4() 
{
	BitChange(4);
}

void CHardioDlg::OnCheckBit5() 
{
	BitChange(5);
}

void CHardioDlg::OnCheckBit6() 
{
	BitChange(6);
}

void CHardioDlg::OnCheckBit7() 
{
	BitChange(7);
}

void CHardioDlg::OnCheckBit8() 
{
	BitChange(8);
}

void CHardioDlg::OnCheckBit9() 
{
	BitChange(9);
}

void CHardioDlg::OnCheckBit10() 
{
	BitChange(10);
}

void CHardioDlg::OnCheckBit11() 
{
	BitChange(11);
}

void CHardioDlg::OnCheckBit12() 
{
	BitChange(12);
}

void CHardioDlg::OnCheckBit13() 
{
	BitChange(13);
}

void CHardioDlg::OnCheckBit14() 
{
	BitChange(14);
}

void CHardioDlg::OnCheckBit15() 
{
	BitChange(15);
}

void CHardioDlg::BitChange(unsigned int bit)
{
	u32	address, value;
	char str[32];

	GetDlgItemText(IDC_EDIT_IO_ADDRESS, str, 32);

	address = HexToInt(str);
	value	= agb_read_mem16(address);

	if(value & (1<<bit)){
		value &= ~(1<<bit);
	}else{
		value |= (1<<bit);
	}

	agb_write_mem16(address, value);

	sprintf(str, "%X", value);
	SetDlgItemText(IDC_EDIT_IO_VALUE, str);
}
