
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/



#define POP(high,low)	low=RMem((cpu.SP)++);high=RMem((cpu.SP)++)

_inline void PUSH(u8 high, u8 low)
{
	WMem(--cpu.SP,high);
	WMem(--cpu.SP,low);
}

_inline void ADC(u8 dest)
{
	RF(_N);
	if((((cpu.A) & 0x0F)+(dest & 0x0F)+FC)>0x0F)SF(_H);else RF(_H);
	if(((cpu.A)+(dest)+FC)>0xFF)SF(_C);else RF(_C);
	cpu.A+=dest+FC;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void ADD(u8 dest)
{
	RF(_N);
	if((((cpu.A) & 0x0F)+((dest) & 0x0F))>0x0F)SF(_H);else RF(_H);
	if(((cpu.A)+(dest))>0xFF)SF(_C);else RF(_C);
	cpu.A+=dest;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void ADDHL(u16 dest)
{
	RF(_N);
	if((((cpu.HL) & 0x0FFF)+((dest) & 0x0FFF))>0x0FFF)SF(_H);else RF(_H);
	if(((cpu.HL)+(dest))>0xFFFF)SF(_C);else RF(_C);
	cpu.HL+=dest;
	if(cpu.HL)RF(_Z);else SF(_Z);
}

_inline void AND(u8 dest)
{
	RF(_N);
	SF(_H);
	RF(_C);
	cpu.A&=dest;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void CALL()
{
	u16 tmp16;

	tmp16=SOURCE;
	cpu.PC+=3;
	PUSH(cpu.PCH,cpu.PCL);
	cpu.PC=tmp16;
}

_inline void CP(u8 dest){
	if((cpu.A)==dest)SF(_Z);else RF(_Z); SF(_N);
	if(((cpu.A) & 0x0F)<((dest) & 0x0F))SF(_H);else RF(_H);
	if((cpu.A)<(dest))SF(_C);else RF(_C);
}

_inline void DAA()
{
	u8	tmp8, low, high;

	tmp8=0;
	low=(cpu.A) & 0x0F;
	high=(cpu.A) & 0xF0;

	if(FN){
		if(FH && low>=0x06){
			tmp8-=0x06;
			high+=0x10;
		}
		if(FC && high<=0x70)tmp8-=0x60;
	}else{
		if(FH && low<=0x02)tmp8=0x06;
		else if(!FH && low>=0x0A){
			tmp8=0x06;
			high+=0x10;
		}
		if((FC && high<=0x30)||(!FC && high>=0xA0))tmp8+=0x60;
	}

	if(((tmp8&0x0F)+(cpu.A&0x0F))>0x0F)SF(_H);else RF(_H);
	if((tmp8+(cpu.A))>0xFF)SF(_C);else RF(_C);
	cpu.A+=tmp8;
	if(cpu.A)RF(_Z);else SF(_Z);
}

#define DECB(dest)	SF(_N);if(dest & 0x0F)RF(_H);else SF(_H);\
		dest--; if(dest)RF(_Z);else SF(_Z)

#define DECW(dest)		(dest)--

#define INCW(dest)		(dest)++

_inline void JP()
{
	cpu.PC=SOURCE;
}

_inline void JR()
{
	cpu.PC+=(s8)DEST;
}

#define LD(dest,src)	(dest)=(src)

#define INCB(dest)	RF(_N);if(dest & 0x0F)RF(_H);else SF(_H);\
		(dest)++; if(dest)RF(_Z);else SF(_Z)

_inline void OR(u8 dest)
{
	RF(_N);
	RF(_H);
	RF(_C);
	cpu.A|=dest;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void RET()
{
	cpu.PC=RMem(cpu.SP)+((RMem((u16)(cpu.SP+1)))<<8);
	cpu.SP+=2;
}

_inline void RST(u8 dest)
{
	PUSH(cpu.PCH,cpu.PCL);
	cpu.PC=dest;
}

_inline void SBC(u8 dest)
{
	SF(_N);
	if((cpu.A & 0x0F)<((dest+FC) & 0x0F))SF(_H);else RF(_H);
	if(cpu.A<(dest+FC))SF(_C);else RF(_C);
	cpu.A-=dest+FC;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void SUB(u8 dest)
{
	SF(_N);
	if((cpu.A & 0x0F)<(dest & 0x0F))SF(_H);else RF(_H);
	if(cpu.A<dest)SF(_C);else RF(_C);
	cpu.A-=dest;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void XOR(u8 dest)
{
	RF(_N);
	RF(_H);
	RF(_C);
	cpu.A^=dest;
	if(cpu.A)RF(_Z);else SF(_Z);
}

_inline void UnknowOpcode()
{
	static u8 opcode;

	opcode=RMem(cpu.PC);

	CPUIsRunning=0;
#ifdef	_WIN32_GDI
		char str[50];
		sprintf(str, "Unknow opcode \"%02Xh\" at %04Xh, bank #%d", opcode, cpu.PC, mbc);
		GBEmu.MessageBox(str, NULL, MB_ICONSTOP);
#endif	/*_WIN32_GDI*/
}


static const u8 Cycles[256]={
	 4,12, 8, 8, 4, 4, 8, 4,20, 8, 8, 8, 4, 4, 8, 4,
	 4,12, 8, 8, 4, 4, 8, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 8,12, 8, 8, 4, 4, 8, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 8,12, 8, 8,12,12,12, 4, 8, 8, 8, 8, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 8, 8, 8, 8, 8, 8, 4, 8, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 4, 4, 4, 4, 4, 4, 8, 4, 4, 4, 4, 4, 4, 4, 8, 4,
	 8, 8,12,12,12,16, 8,32, 8, 8,12, 0,12,12, 8,32,
	 8, 8,12, 0,12,16, 8,32, 8, 8,12, 0,12, 0, 8,32,
	12, 8, 8, 0, 0,16, 8,32,16, 4,16, 0, 0, 0, 8,32, 
	12, 8, 8, 4, 0,16, 8,32,12, 8,16, 4, 0, 0, 8,32,
};

static const u8 Cycles_cb[256]={
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
	 8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
	 8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
	 8, 8, 8, 8, 8, 8,12, 8, 8, 8, 8, 8, 8, 8,12, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
	 8, 8, 8, 8, 8, 8,16, 8, 8, 8, 8, 8, 8, 8,16, 8,
};

static const u8 PC_table[256]={
	1,3,1,1,1,1,2,1,3,1,1,1,1,1,2,1,/*0*/
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,/*1*/
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,/*2*/
	2,3,1,1,1,1,2,1,2,1,1,1,1,1,2,1,/*3*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*4*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*5*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*6*/
	1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,/*7*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*8*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*9*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*A*/
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,/*B*/
	0,1,0,0,0,1,2,1,0,0,0,0,0,0,2,1,/*C*/
	0,1,0,0,0,1,2,1,0,0,0,0,0,0,2,1,/*D*/
	2,1,1,0,0,1,2,1,2,0,3,0,0,0,2,1,/*E*/
	2,1,1,1,0,1,2,1,2,1,3,1,0,0,2,1,/*F*/
/*	0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F*/
};


static void Cpu(){
	static u16 tmp16;
	static u8 tmp8;
	static u8 opcode;

	opcode=RMem(cpu.PC);

	switch(opcode){

	case 0x00 : break;/*NOP*/
	case 0x01 : LD(cpu.BC,SOURCE);break;	/*LD BC nn*/
	case 0x02 : WMem(cpu.BC,cpu.A);break;
	case 0x03 : INCW(cpu.BC);break;
	case 0x04 : INCB(cpu.B);break;
	case 0x05 : DECB(cpu.B);break;
	case 0x06 : LD(cpu.B,DEST);break;
	case 0x07 : RF(_N);RF(_H);
		if(cpu.A & 0x80)SF(_C);else RF(_C);
		cpu.A=((cpu.A<<1)|(cpu.A>>7));
		if(cpu.A)RF(_Z);else SF(_Z);break;	/*RLCA*/
	case 0x08 : tmp16=SOURCE;
		WMem(tmp16++,(u8)(cpu.SP));
		WMem(tmp16,(u8)(cpu.SP>>8));break;	/*LD (nn),SP*/
	case 0x09 : ADDHL(cpu.BC);break;
	case 0x0A : LD(cpu.A,RMem(cpu.BC));break;
	case 0x0B : DECW(cpu.BC);break;
	case 0x0C : INCB(cpu.C);break;
	case 0x0D : DECB(cpu.C);break;
	case 0x0E : LD(cpu.C,DEST);break;
	case 0x0F : RF(_N);RF(_H);
		if(cpu.A & 0x01)SF(_C);else RF(_C);
		cpu.A=((cpu.A>>1)|(cpu.A<<7));
		if(cpu.A)RF(_Z);else SF(_Z);break;	/*RRCA*/
	case 0x10 : if(DEST==0x00)cpu.stop=1;break;	/*STOP*/
	case 0x11 : LD(cpu.DE,SOURCE);break;	/*LD DE,nn*/
	case 0x12 : WMem(cpu.DE,cpu.A);break;
	case 0x13 : INCW(cpu.DE);break;
	case 0x14 : INCB(cpu.D);break;
	case 0x15 : DECB(cpu.D);break;
	case 0x16 : LD(cpu.D,DEST);break;
	case 0x17 : RF(_N);RF(_H);
		if(cpu.A & 0x80)SF(_C);else RF(_C);
		cpu.A=((cpu.A<<1)|FC);
		if(cpu.A)RF(_Z);else SF(_Z);break;	/*RLA*/
	case 0x18 : JR();break;
	case 0x19 : ADDHL(cpu.DE);break;
	case 0x1A : LD(cpu.A,RMem(cpu.DE));break;
	case 0x1B : DECW(cpu.DE);break;
	case 0x1C : INCB(cpu.E);break;
	case 0x1D : DECB(cpu.E);break;
	case 0x1E : LD(cpu.E,DEST);break;
	case 0x1F : RF(_N);RF(_H);
		if(cpu.A & 0x01)SF(_C);else RF(_C);
		cpu.A=(u8)((cpu.A>>1)|((cpu.F&_C)<<3));
		if(cpu.A)RF(_Z);else SF(_Z);break;	/*RRA*/
	case 0x20 : if(!FZ)JR();break;
	case 0x21 : LD(cpu.HL,SOURCE);break;	/*LD HL,nn*/
	case 0x22 : WMem(cpu.HL++,cpu.A);break;	/*LDI*/
	case 0x23 : INCW(cpu.HL);break;
	case 0x24 : INCB(cpu.H);break;
	case 0x25 : DECB(cpu.H);break;
	case 0x26 : LD(cpu.H,DEST);break;
	case 0x27 : DAA();break;/*DAA*/
	case 0x28 : if(FZ)JR();break;
	case 0x29 : ADDHL(cpu.HL);break;
	case 0x2A : cpu.A=RMem(cpu.HL++);break;
	case 0x2B : DECW(cpu.HL);break;
	case 0x2C : INCB(cpu.L);break;
	case 0x2D : DECB(cpu.L);break;
	case 0x2E : LD(cpu.L,DEST);break;
	case 0x2F : SF(_N);SF(_H);cpu.A=~cpu.A;break;	/*CPL*/
	case 0x30 : if(!FC)JR();break;
	case 0x31 : LD(cpu.SP,SOURCE);break;
	case 0x32 : WMem(cpu.HL--,cpu.A);break;	/*LDD*/
	case 0x33 : INCW(cpu.SP);break;
	case 0x34 : tmp8=RMem(cpu.HL);
		RF(_N);if((tmp8 & 0x0F)==0x0F)SF(_H);else RF(_H);
		tmp8++; if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;	/*INC (HL)*/
	case 0x35 :	tmp8=RMem(cpu.HL);
		SF(_N);if(tmp8 & 0x0F)RF(_H);else SF(_H);
		tmp8--; if(tmp8)RF(_Z);else SF(_Z);
		WMem(cpu.HL,tmp8);break;	/*DEC (HL)*/
	case 0x36 : WMem(cpu.HL,DEST);break;
	case 0x37 : RF(_N);RF(_H);SF(_C);break;	/*SCF*/
	case 0x38 : if(FC)JR();break;
	case 0x39 : ADDHL(cpu.SP);break;
	case 0x3A : cpu.A=RMem(cpu.HL--);break;
	case 0x3B : DECW(cpu.SP);break;
	case 0x3C : INCB(cpu.A);break;
	case 0x3D : DECB(cpu.A);break;
	case 0x3E : LD(cpu.A,DEST);break;
	case 0x3F : RF(_N);RF(_H);if(!FC)SF(_C);else RF(_C);break;	/*CCF*/
	case 0x40 : LD(cpu.B,cpu.B);break;
	case 0x41 : LD(cpu.B,cpu.C);break;
	case 0x42 : LD(cpu.B,cpu.D);break;
	case 0x43 : LD(cpu.B,cpu.E);break;
	case 0x44 : LD(cpu.B,cpu.H);break;
	case 0x45 : LD(cpu.B,cpu.L);break;
	case 0x46 : LD(cpu.B,RMem(cpu.HL));break;
	case 0x47 : LD(cpu.B,cpu.A);break;
	case 0x48 : LD(cpu.C,cpu.B);break;
	case 0x49 : LD(cpu.C,cpu.C);break;
	case 0x4A : LD(cpu.C,cpu.D);break;
	case 0x4B : LD(cpu.C,cpu.E);break;
	case 0x4C : LD(cpu.C,cpu.H);break;
	case 0x4D : LD(cpu.C,cpu.L);break;
	case 0x4E : LD(cpu.C,RMem(cpu.HL));break;
	case 0x4F : LD(cpu.C,cpu.A);break;
	case 0x50 : LD(cpu.D,cpu.B);break;
	case 0x51 : LD(cpu.D,cpu.C);break;
	case 0x52 : LD(cpu.D,cpu.D);break;
	case 0x53 : LD(cpu.D,cpu.E);break;
	case 0x54 : LD(cpu.D,cpu.H);break;
	case 0x55 : LD(cpu.D,cpu.L);break;
	case 0x56 : LD(cpu.D,RMem(cpu.HL));break;
	case 0x57 : LD(cpu.D,cpu.A);break;
	case 0x58 : LD(cpu.E,cpu.B);break;
	case 0x59 : LD(cpu.E,cpu.C);break;
	case 0x5A : LD(cpu.E,cpu.D);break;
	case 0x5B : LD(cpu.E,cpu.E);break;
	case 0x5C : LD(cpu.E,cpu.H);break;
	case 0x5D : LD(cpu.E,cpu.L);break;
	case 0x5E : LD(cpu.E,RMem(cpu.HL));break;
	case 0x5F : LD(cpu.E,cpu.A);break;
	case 0x60 : LD(cpu.H,cpu.B);break;
	case 0x61 : LD(cpu.H,cpu.C);break;
	case 0x62 : LD(cpu.H,cpu.D);break;
	case 0x63 : LD(cpu.H,cpu.E);break;
	case 0x64 : LD(cpu.H,cpu.H);break;
	case 0x65 : LD(cpu.H,cpu.L);break;
	case 0x66 : LD(cpu.H,RMem(cpu.HL));break;
	case 0x67 : LD(cpu.H,cpu.A);break;
	case 0x68 : LD(cpu.L,cpu.B);break;
	case 0x69 : LD(cpu.L,cpu.C);break;
	case 0x6A : LD(cpu.L,cpu.D);break;
	case 0x6B : LD(cpu.L,cpu.E);break;
	case 0x6C : LD(cpu.L,cpu.H);break;
	case 0x6D : LD(cpu.L,cpu.L);break;
	case 0x6E : LD(cpu.L,RMem(cpu.HL));break;
	case 0x6F : LD(cpu.L,cpu.A);break;
	case 0x70 : WMem(cpu.HL,cpu.B);break;
	case 0x71 : WMem(cpu.HL,cpu.C);break;
	case 0x72 : WMem(cpu.HL,cpu.D);break;
	case 0x73 : WMem(cpu.HL,cpu.E);break;
	case 0x74 : WMem(cpu.HL,cpu.H);break;
	case 0x75 : WMem(cpu.HL,cpu.L);break;
	case 0x76 : cpu.halt=cpu.ime=1;break;	/*HALT*/
	case 0x77 : WMem(cpu.HL,cpu.A);break;
	case 0x78 : LD(cpu.A,cpu.B);break;
	case 0x79 : LD(cpu.A,cpu.C);break;
	case 0x7A : LD(cpu.A,cpu.D);break;
	case 0x7B : LD(cpu.A,cpu.E);break;
	case 0x7C : LD(cpu.A,cpu.H);break;
	case 0x7D : LD(cpu.A,cpu.L);break;
	case 0x7E : LD(cpu.A,RMem(cpu.HL));break;
	case 0x7F : LD(cpu.A,cpu.A);break;
	case 0x80 : ADD(cpu.B);break;
	case 0x81 : ADD(cpu.C);break;
	case 0x82 : ADD(cpu.D);break;
	case 0x83 : ADD(cpu.E);break;
	case 0x84 : ADD(cpu.H);break;
	case 0x85 : ADD(cpu.L);break;
	case 0x86 : tmp8=RMem(cpu.HL);ADD(tmp8);break;
	case 0x87 : ADD(cpu.A);break;
	case 0x88 : ADC(cpu.B);break;
	case 0x89 : ADC(cpu.C);break;
	case 0x8A : ADC(cpu.D);break;
	case 0x8B : ADC(cpu.E);break;
	case 0x8C : ADC(cpu.H);break;
	case 0x8D : ADC(cpu.L);break;
	case 0x8E : tmp8=RMem(cpu.HL);ADC(tmp8);break;
	case 0x8F : ADC(cpu.A);break;
	case 0x90 :	SUB(cpu.B);break;
	case 0x91 :	SUB(cpu.C);break;
	case 0x92 :	SUB(cpu.D);break;
	case 0x93 :	SUB(cpu.E);break;
	case 0x94 :	SUB(cpu.H);break;
	case 0x95 :	SUB(cpu.L);break;
	case 0x96 :	tmp8=RMem(cpu.HL);SUB(tmp8);break;
	case 0x97 :	SUB(cpu.A);break;
	case 0x98 :	SBC(cpu.B);break;
	case 0x99 :	SBC(cpu.C);break;
	case 0x9A :	SBC(cpu.D);break;
	case 0x9B :	SBC(cpu.E);break;
	case 0x9C :	SBC(cpu.H);break;
	case 0x9D :	SBC(cpu.L);break;
	case 0x9E :	tmp8=RMem(cpu.HL);SBC(tmp8);break;
	case 0x9F :	SBC(cpu.A);break;
	case 0xA0 : AND(cpu.B);break;
	case 0xA1 : AND(cpu.C);break;
	case 0xA2 : AND(cpu.D);break;
	case 0xA3 : AND(cpu.E);break;
	case 0xA4 : AND(cpu.H);break;
	case 0xA5 : AND(cpu.L);break;
	case 0xA6 : tmp8=RMem(cpu.HL);AND(tmp8);break;
	case 0xA7 : AND(cpu.A);break;
	case 0xA8 :	XOR(cpu.B);break;
	case 0xA9 :	XOR(cpu.C);break;
	case 0xAA :	XOR(cpu.D);break;
	case 0xAB :	XOR(cpu.E);break;
	case 0xAC :	XOR(cpu.H);break;
	case 0xAD :	XOR(cpu.L);break;
	case 0xAE :	tmp8=RMem(cpu.HL);XOR(tmp8);break;
	case 0xAF :	XOR(cpu.A);break;
	case 0xB0 :	OR(cpu.B);break;
	case 0xB1 :	OR(cpu.C);break;
	case 0xB2 :	OR(cpu.D);break;
	case 0xB3 :	OR(cpu.E);break;
	case 0xB4 :	OR(cpu.H);break;
	case 0xB5 :	OR(cpu.L);break;
	case 0xB6 :	tmp8=RMem(cpu.HL);OR(tmp8);break;
	case 0xB7 :	OR(cpu.A);break;
	case 0xB8 :	CP(cpu.B);break;
	case 0xB9 :	CP(cpu.C);break;
	case 0xBA :	CP(cpu.D);break;
	case 0xBB :	CP(cpu.E);break;
	case 0xBC :	CP(cpu.H);break;
	case 0xBD :	CP(cpu.L);break;
	case 0xBE :	tmp8=RMem(cpu.HL);CP(tmp8);break;
	case 0xBF :	CP(cpu.A);break;
	case 0xC0 : if(!FZ){RET();}else cpu.PC++; break;
	case 0xC1 : POP(cpu.B,cpu.C);break;
	case 0xC2 : if(!FZ){JP();} else cpu.PC+=3; break;
	case 0xC3 : JP();break;
	case 0xC4 : if(!FZ){CALL();}else cpu.PC+=3; break;
	case 0xC5 : PUSH(cpu.B,cpu.C);break;
	case 0xC6 : tmp8=DEST;ADD(tmp8);break;
	case 0xC7 : RST(0x00);break;
	case 0xC8 : if(FZ){RET();}else cpu.PC++; break;
	case 0xC9 : RET();break;
	case 0xCA : if(FZ){JP();} else cpu.PC+=3; break;
	case 0xCB : UnknowOpcode();/*CB prefix*/
	case 0xCC : if(FZ){CALL();}else cpu.PC+=3; break;
	case 0xCD : CALL();break;
	case 0xCE : tmp8=DEST;ADC(tmp8);break;
	case 0xCF : RST(0x08);break;
	case 0xD0 : if(!FC){RET();}else cpu.PC++; break;
	case 0xD1 : POP(cpu.D,cpu.E);break;
	case 0xD2 : if(!FC){JP();} else cpu.PC+=3; break;
	case 0xD3 : UnknowOpcode();/***/
	case 0xD4 : if(!FC){CALL();}else cpu.PC+=3; break;
	case 0xD5 : PUSH(cpu.D,cpu.E);break;
	case 0xD6 :	tmp8=DEST;SUB(tmp8);break;
	case 0xD7 : RST(0x10);break;
	case 0xD8 : if(FC){RET();}else cpu.PC++; break;
	case 0xD9 : RET();cpu.ime=1;EndInterrupt();break;	/*RETI*/
	case 0xDA : if(FC){JP();} else cpu.PC+=3; break;
	case 0xDB : UnknowOpcode();/***/
	case 0xDC : if(FC){CALL();}else cpu.PC+=3; break;
	case 0xDD : UnknowOpcode();/***/
	case 0xDE :	tmp8=DEST;SBC(tmp8);break;
	case 0xDF : RST(0x18);break;
	case 0xE0 :	WMem((u16)(0xFF00+DEST),cpu.A);break;	/*LD (n),A*/
	case 0xE1 : POP(cpu.H,cpu.L);break;
	case 0xE2 : WMem((u16)(0xFF00+(cpu.C)),cpu.A);break;	/*LD (C),A*/
	case 0xE3 : UnknowOpcode();/***/
	case 0xE4 : UnknowOpcode();/***/
	case 0xE5 : PUSH(cpu.H,cpu.L);break;
	case 0xE6 : tmp8=DEST;AND(tmp8);break;
	case 0xE7 : RST(0x20);break;
	case 0xE8 : tmp8=DEST;
		RF(_Z);RF(_N);RF(_H);
		if((cpu.SP+(s8)tmp8)>0xFFFF)SF(_C);else RF(_C);
		cpu.SP+=(s8)tmp8;break;	/*ADDSP*/
	case 0xE9 : cpu.PC=cpu.HL;break;	/*JP (HL)****************/
	case 0xEA : WMem(SOURCE,cpu.A);break;
	case 0xEB : UnknowOpcode();/***/
	case 0xEC : UnknowOpcode();/***/
	case 0xED : UnknowOpcode();/***/
	case 0xEE :	tmp8=DEST;XOR(tmp8);break;
	case 0xEF : RST(0x28);break;
	case 0xF0 : LD(cpu.A,RMem((u16)(0xFF00+DEST)));break;	/*LD A,(n)*/
	case 0xF1 : POP(cpu.A,cpu.F);break;
	case 0xF2 : LD(cpu.A,RMem((u16)(0xFF00+(cpu.C))));break;	/*LD A,(C)*/
	case 0xF3 : cpu.ime=0;break;/*DI*/
	case 0xF4 : UnknowOpcode();/***/
	case 0xF5 : PUSH(cpu.A,cpu.F);break;
	case 0xF6 :	OR(DEST);break;
	case 0xF7 : RST(0x30);break;
	case 0xF8 : RF(_Z);RF(_N);RF(_H);
		if(((cpu.SP)+(s8)DEST)>0xFFFF)SF(_C);else RF(_C);
		cpu.HL=(cpu.SP)+(s8)DEST;break;	/*LDHL SP,n*/
	case 0xF9 : LD(cpu.SP,cpu.HL);break;	/*LD SP,HL*/
	case 0xFA : LD(cpu.A,RMem(SOURCE));break;
	case 0xFB : cpu.ime=1;EndInterrupt();break;	/*EI*/
	case 0xFC :	UnknowOpcode();/***/
	case 0xFD :	UnknowOpcode();/***/
	case 0xFE :	tmp8=DEST;CP(tmp8);break;
	case 0xFF : RST(0x38);break;

#ifdef	_WIN32_GDI
	default   : __assume(0);
#endif	/*_WIN32_GDI*/

	}

}

