
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include <SDL_video.h>

void InitializeRegister();
_inline void EndInterrupt();
_inline void Interrupt(int irq);
int InitializeVideo(unsigned long);
void InitializeRegister();
void InitializeMemory();
_inline void LCDDraw();
static void DrawLine();
int OpenROM(char* filename);
void CloseROM();

#undef	_WIN32
#define	_SDL

#include "../include/defines.h"
#include "../gbcore/memory.c"
#include "../gbcore/cpu.c"
#include "../gbcore/video.c"
#include "../gbcore/mainloop.c"
	

int main(int argc, char* argv[])
{
	int index;
	u32 flags;

	SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER);
	
	if(argv[1]==NULL){
		/* t@C̎w肪Ȃ΃wv\*/
		printf("GameboyVM SDL version 0.05 for Windows  <Build date 20 July 2002>\n");
		printf("Copyright 2002 by Y_N <y_n@users.sourceforge.jp>\n");
		printf("Project Homepage : https://sourceforge.jp/projects/gbemu/\n");
		printf("Usage : GameboyVM [filename] [options]\n");
		printf("\t-f Full screen mode\n");
		printf("\t-m Use hardware video memory\n");
		printf("\t-a Use hardware accelation\n");
		printf("\t-s VSync...\n");
		exit(1);
	}
	
	index = 2;
	flags = SDL_SWSURFACE;
	while(argv[index]!=NULL){
		if(strcmp(argv[index], "-m")==0)flags=SDL_HWSURFACE;
		if(strcmp(argv[index], "-f")==0)flags|=SDL_FULLSCREEN;
		if(strcmp(argv[index], "-a")==0)flags|=SDL_HWACCEL;
		index++;
	}
	
	if(OpenROM(argv[1]))exit(0);
	if(InitializeVideo(flags))exit(0);
	InitializeMemory();
	InitializeRegister();
	MainLoop();
	CloseROM();

	return 0;
}


int InitializeVideo(unsigned long flags)
{	/* T[tF[X̎擾ɎsꍇOȊOA*/
	Surface = SDL_SetVideoMode(160, 144, 8, flags);
	if(Surface==NULL)return 1;
	SDL_WM_SetCaption("GameboyVM", NULL);
	Surface->pixels = FrameBuffer;
	bmp_info = Surface->format;
	colors[0].r =
	colors[0].g =
	colors[0].b = Colours[0];
	colors[1].r =
	colors[1].g =
	colors[1].b = Colours[1];
	colors[2].r =
	colors[2].g =
	colors[2].b = Colours[2];
	colors[3].r =
	colors[3].g =
	colors[3].b = Colours[3];
	SDL_SetColors(Surface, colors, 0, 4);

	return 0;
}


int OpenROM(char* filename)
{
	if(filename==NULL)return 1;
	fp = fopen(filename ,"rb");
	fread(ROM, 1, ROM_SIZE, fp);

	return 0;
}

void CloseROM() 
{
	CPUIsRunning=0;
	SDL_FreeSurface(Surface);
	if(fp!=NULL)fclose(fp);
	SDL_Quit();
}

_inline void LCDDraw()
{
	SDL_UpdateRect(Surface, 0, 0, 0, 0);
}

