// MemDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "MemDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern UINT mbc;
extern BYTE Rmem(WORD);
extern bool fMemDlg;
extern UINT HexToInt(char*);

/////////////////////////////////////////////////////////////////////////////
// CMemDlg _CAO


CMemDlg::CMemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemDlg)
	m_txtAddress = _T("");
	m_iBank = 1;
	//}}AFX_DATA_INIT
}


void CMemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemDlg)
	DDX_Control(pDX, IDC_MEM_SCROLLBAR, m_scrMem);
	DDX_Control(pDX, IDC_ADR_CMB, m_Memcmb);
	DDX_Control(pDX, IDC_MEMORY_LIST, m_Memlst);
	DDX_Text(pDX, IDC_EDIT_ADR, m_txtAddress);
	DDV_MaxChars(pDX, m_txtAddress, 4);
	DDX_Text(pDX, IDC_BANK, m_iBank);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMemDlg, CDialog)
	//{{AFX_MSG_MAP(CMemDlg)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_DUMP, OnDump)
	ON_CBN_SELCHANGE(IDC_ADR_CMB, OnSelchangeAdrCmb)
	ON_BN_CLICKED(IDC_GO, OnGo)
	ON_WM_SIZE()
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemDlg bZ[W nh

BOOL CMemDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0, 448, 90);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_MEMORY_LIST), 0, 2, 23, 
					430, 85, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_MEM_SCROLLBAR), 0, 430, 23, 
					18, 85, SWP_NOACTIVATE|SWP_NOZORDER);

	m_scrMem.SetScrollRange(0, 0x800, TRUE);

	m_Memcmb.SetCurSel(8);	/*ݒIOWX^*/
	MemAdr=0xFF00;
	m_scrMem.SetScrollPos(MemAdr>>5, TRUE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMemDlg::OnClose() 
{	// tO߂ă_CAO
	fMemDlg=false;	
	CDialog::OnClose();
}

void CMemDlg::ShowMemory()
{	// _v\
	CString MemLine="";
	int ly, lx, ml;
	char tm[5];

	ml=MemAdr;

	CFont* pFont = new CFont;
	pFont->CreatePointFont(10, _T("Courier"));	// tHg
	m_Memlst.SetFont(pFont);

	m_Memlst.ResetContent();
	m_Memlst.AddString("     +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F");
	
	for(ly=0; ly<5; ly++){
		_itoa((int)ml, tm, 16);
		if(strlen(tm)==1)MemLine="000";
		else if(strlen(tm)==2)MemLine="00";
		else if(strlen(tm)==3)MemLine="0";
		else MemLine="\0";
		MemLine+=tm;
		for(lx=0; lx<16; lx++,ml++){
			_itoa((int)Rmem(ml), tm, 16);
			if(strlen(tm)==1)MemLine=MemLine+" 0";
			else MemLine=MemLine+" ";
			MemLine+=tm;
		}
		m_Memlst.AddString(MemLine);
	}

	UpdateData(true);
	m_iBank=mbc;
	UpdateData(false);
}

void CMemDlg::OnDump() 
{	// \eXV
	ShowMemory();
}

void CMemDlg::OnSelchangeAdrCmb() 
{	// R{{bNXIɕ\ꂽAhXֈړ
	switch((BYTE)m_Memcmb.GetCurSel()){
	case 0 :MemAdr=0x0000;break;
	case 1 :MemAdr=0x4000;break;
	case 2 :MemAdr=0x8000;break;
	case 3 :MemAdr=0xA000;break;
	case 4 :MemAdr=0xC000;break;
	case 5 :MemAdr=0xE000;break;
	case 6 :MemAdr=0xFE00;break;
	case 7 :MemAdr=0xFEA0;break;
	case 8 :MemAdr=0xFF00;break;
	case 9 :MemAdr=0xFF80;break;
	case 10 :MemAdr=0xFFB0;break;
	default:break;
	}
	m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
	ShowMemory();
}

void CMemDlg::OnGo() 
{	// ͂ꂽAhXփWv
	UINT i;

	UpdateData(true);
	i=HexToInt(m_txtAddress.GetBuffer(10));
	UpdateData(false);
	if(i==0xFFFFFFFF||i==0xFFFFFFFE){	/*16iȊO̐l͂ꂽ*/
		MessageBox("Please input the number of Hex.", NULL, MB_ICONSTOP);
		return;
	}
	i-=(i&0x000F);	/*P͍폜*/
	if(i>0xFFB0)i=0xFFB0;
	MemAdr=i;
	m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
	ShowMemory();
}

void CMemDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

}

void CMemDlg::OnOK()
{

}

void CMemDlg::OnCancel()
{
	EndDialog(0);
}

BOOL CMemDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		case VK_DOWN:
			if((MemAdr+0x10)>=0xFFB0)MemAdr=0xFFB0;
			else MemAdr+=0x10;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		case VK_UP:
			if((MemAdr-0x10)<=0x0000)MemAdr=0x0000;
			else MemAdr-=0x10;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		default: break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CMemDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UINT ScrPos=m_scrMem.GetScrollPos();
	switch(nSBCode) {
		case SB_LINEUP:	/*XN[o[̃{^*/
			if((MemAdr-0x10)<=0x0000)MemAdr=0x0000;
			else MemAdr-=0x10;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		case SB_LINEDOWN:
			if((MemAdr+0x10)>=0xFFB0)MemAdr=0xFFB0;
			else MemAdr+=0x10;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		case SB_PAGEUP:	/*XN[o[̗]*/
			if((MemAdr-0x50)<=0x0000)MemAdr=0x0000;
			else MemAdr-=0x50;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		case SB_PAGEDOWN:
			if((MemAdr+0x50)>=0xFFB0)MemAdr=0xFFB0;
			else MemAdr+=0x50;
			m_scrMem.SetScrollPos(MemAdr>>5, TRUE);
			ShowMemory();
			break;
		case SB_THUMBPOSITION:	/*XN[o[̂܂*/
		case SB_THUMBTRACK:
			MemAdr=nPos<<5;
			if(nPos==0x800)MemAdr=0xFFB0;
			m_scrMem.SetScrollPos(nPos, TRUE);
			ShowMemory();
			break;
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}
