
/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/


static void ExecuteCPU(int);

void InitializeRegister()
{ /*CPUWX^̏*/
	cpu.AF=0x01B0;
	cpu.BC=0x0013;
	cpu.DE=0x00D8;
	cpu.HL=0x014D;
	cpu.SP=0xFFFE;
	cpu.PC=0x0100;
    cpu.ime=0;
    cpu.halt=0;
    cpu.stop=0;
	keyflag=0xFF;
	keyint=0;
	mbc=1;
	rambc=0;
	e_rambc=0;
    CPUIsRunning=1;
	irq_type=-1;
	irqs[0]=0;
	irqs[1]=0;
	irqs[2]=0;
	irqs[3]=0;
	irqs[4]=0;
}

_inline void EndInterrupt()
{
	u32	irq_sp;

	MEM[R_IF]&=~bit_mask[irq_type];
	irqs[irq_type]=0;
	irq_type=-1;

	for(irq_sp=0; irq_sp<5; irq_sp++){
		if(irqs[irq_sp]){	/*荞ݏɔ荞݂s*/
			cpu.ime=0;
			MEM[R_IF]|=bit_mask[irq_sp];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
			PUSH(cpu.PCH,cpu.PCL);
			cpu.PC=irq_adr[irq_sp];
			irq_type=irq_sp;
			return;
		}
	}
}

_inline void Interrupt(int irq)
{
	if((MEM[R_IE] & bit_mask[irq]) && cpu.ime){
		if(irq_type==-1){
			cpu.ime=0;
			MEM[R_IF]|=bit_mask[irq];
			if(cpu.halt){
				cpu.halt=0;
				cpu.PC++;
			}
			PUSH(cpu.PCH,cpu.PCL);
			cpu.PC=irq_adr[irq];
			irq_type=irq;
		}else{
			irqs[irq]=1;
		}
	}
}


#ifdef	_WIN32_GDI
void CGBEmuDlg::MainLoop()
#endif
#ifdef	_WINCE_GDI
void CGBEmuDlg::MainLoop()
#endif
#ifdef	_SDL
static void MainLoop()
#endif
#ifdef	_WIN32_LITE
static void MainLoop()
#endif
{
	static DWORD WaitTime;	/*^C}[1000/59.73=16.74*/

#ifdef	_WIN32_GDI
	fTMain=true;
#endif

	WaitTime = timeGetTime() + 17;

	while(CPUIsRunning){

		/*0̎ V-Sync*/
		DrawLCD();
		FrameCount++;
#ifdef	_WIN32_GDI
		if(fSound && (MEM[R_NR52]&0x80))PlayGBSound();
		if(fFps)ShowFps();
#endif	/*_WIN32_GDI*/
#ifdef	_SDL
		SDLEventLoop();
		ShowFps();
#endif	/*_SDL*/
		while((WaitTime > timeGetTime()) && fVsync){Sleep(1);};	/*ҋ@*/
		WaitTime = timeGetTime() + 17;

		if(MEM[R_LCDC]&0x80){
			while(MEM[R_LY]<144){
				MEM[R_LY]++;

				MEM[R_STAT]&=~0x07;
				if(MEM[R_LY]==MEM[R_LYC]){
					MEM[R_STAT]|=0x04;/*LYC01*/
					if(MEM[R_STAT]&0x40)Interrupt(IRQ_LCDC);	/*LY==LYC*/
				}
				
				MEM[R_STAT]&=~0x01;
				MEM[R_STAT]|=0x02;
				if(MEM[R_STAT]&0x20)Interrupt(IRQ_LCDC);	/*Mode10*/
				ExecuteCPU(80);

				MEM[R_STAT]|=0x03;	/*mode11*/
				ExecuteCPU(172);
				
				MEM[R_STAT]&=~0x03;
				if(MEM[R_STAT]&0x08)Interrupt(IRQ_LCDC);	/*mode00*/
				ExecuteCPU(204);

#ifdef	_WIN32_GDI
				if(f16Dib)DrawLine16();else
#endif	/*_WIN32_GDI*/
				DrawLine();
			}

		}
		/* AJn V-blank*/
		MEM[R_STAT]&=~0x03;
		MEM[R_STAT]|=0x01;
		Interrupt(IRQ_VBLANK);
		if(MEM[R_STAT]&0x10)Interrupt(IRQ_LCDC);	/*Mode01*/
		
		while(MEM[R_LY]<154){
			MEM[R_LY]++;

			MEM[R_STAT]&=~0x07;
			if(MEM[R_LY]==MEM[R_LYC]){
				MEM[R_STAT]|=0x04;/*LYC01*/
				if(MEM[R_STAT]&0x40)Interrupt(IRQ_LCDC);	/*LY==LYC*/
			}
			ExecuteCPU(456);
		}
		MEM[R_LY]=0;
	}

#ifdef	_WIN32_GDI
	fTMain=false;	/*XbhItO*/
#endif
}



static void ExecuteCPU(int clk)
{
	static long ttime;
	static u32 r_div;
	static u32 cycle;
	static u32 tmppc;
	static const u32 tac_table[]={4096, 262144, 65536, 16384};

	while(clk>=0){
		if(RMem(cpu.PC)==0xCB){
			cycle=Cycles_cb[RMem(cpu.PC)];
			tmppc=2;
			Cpu_cb();	
		}else{
			cycle=Cycles[RMem(cpu.PC)];
			tmppc=PC_table[RMem(cpu.PC)];
			Cpu();
		}

		cpu.PC+=tmppc;

		clk-=cycle;

		r_div+=cycle;	/*256NbNłP*/
		if(r_div>=256){
			r_div-=256;
			MEM[R_DIV]++;
		}

		if(MEM[R_TAC]&0x04){  /*TIMA^C}[Jn*/
			ttime+=cycle;
			if((tac_table[(MEM[R_TAC]&0x03)]-ttime)<=0){	/*̓NbN̑I*/
				ttime-=tac_table[(MEM[R_TAC]&0x03)];
				MEM[R_TIMA]++;
				if(!MEM[R_TIMA]){	/*if((u8)(MEM[R_TIMA]+1)==0){*/
					MEM[R_TIMA]=MEM[R_TMA];
					Interrupt(IRQ_TIMER);
				}
			}
		}

		if(MEM[R_SC]==0x80){	/*f[^]*/
			MEM[R_SC]&=~0x80;
			MEM[R_SB]=0xFF;	/*Ms*/
			Interrupt(IRQ_SERIAL);
		}

		if(keyint){	/*{^̒e*/
			/*if(keyint==1)Interrupt(IRQ_KEY);*/	/*High-to-Low*/
			keyint=0;
		}

#ifdef	_WIN32_GDI
		if(fSound)Sound_ch1(cycle);
//		if(fNext)DebugNextStep();
//		if(fBreak)DebugBreakPoint();
		if(fAsmDlg)while(fStop)Sleep(10);
		else while(!fActive)Sleep(10);
#endif	/*_WIN32_GDI*/

	}
}


