

/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/

#include "../include/defines.h"



int CheckExtensionName(char* filename, char* extension)
{	/*t@CƊgqvOȊOԂ*/
	UINT	flen, xlen;

	flen = strlen(filename);	/*t@C̕*/
	xlen = strlen(extension);	/*gq̕*/

	if(extension[xlen]=='*')return 0;/*SẴt@C*/

	while(xlen!=0){
		if(isupper(filename[flen]))filename[flen]+=0x20;
		if(isupper(extension[xlen]))extension[xlen]+=0x20;
		if(filename[flen]!=extension[xlen])return 0;
		flen--;
		xlen--;
	}

	return 1;
}


int IsGBFilename(char* filename)
{	/*gq.gb(*.gbc;*.bin)ȂOȊOԂ*/
	int i;
	char tmpch;

	for(i=0; filename[i]!='\0'; i++){}
	tmpch=filename[i-1];
	if(tmpch=='c'||tmpch=='C'){
		tmpch=filename[i-2];
		if(tmpch=='b'||tmpch=='B'){
			tmpch=filename[i-3];
			if(tmpch=='g'||tmpch=='G'){/*GBCt@C*/
				return 1;
			}
		}
	}
	if(tmpch=='n'||tmpch=='N'){
		tmpch=filename[i-2];
		if(tmpch=='i'||tmpch=='I'){
			tmpch=filename[i-3];
			if(tmpch=='b'||tmpch=='B'){/*BINt@C*/
				return 1;
			}
		}
	}
	tmpch=filename[i-1];
	if(tmpch=='b'||tmpch=='B'){
		tmpch=filename[i-2];
		if(tmpch=='g'||tmpch=='G'){/*GB*/
			return 1;
		}		
	}

	return 0;
}

int OpenRomFile(char* filename)
{	/*t@C̓ǂݍ݂ƃ̊m*/
	u8 s_rom/*, s_ram*/;
	u32 i;
	u8	Header[0x151];

	fp = fopen(filename ,"rb");
	fread(Header, 1, 0x150, fp);	/*wb_[ǂݍ*/
	s_rom = rom_size[(Header[0x148])];	/*ROM̃TCY擾*/
/*	s_ram = ram_size[(Header[0x149])];*/	/*RAM̃TCY擾*/
	fclose(fp);

	fp = fopen(filename ,"rb");

	CloseGBMemory();

	/*ROMTCY̕m*/
	for(i=0; i<s_rom; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(ROM[i]==NULL)return 1;
		fread(ROM[i], 1, BANK_SIZE, fp);
	}
	/*RAMTCY̕m*/
/*	for(i=0; i<s_ram; i++){
		ROM[i] = (u8*)malloc(BANK_SIZE);
		if(RAM[i]==NULL)return 1;
		fread(RAM[i], 1, BANK_SIZE, fp);
	}VCł͕s̂ŃRgAEg*/

	return 0;
}

#ifdef	_WIN32_GDI
int OpenZipRomFile(char* filename)
{	/*ZIPt@CROM̓ǂݍ݂ƃ̊m*/	
	u8	s_rom/*, s_ram*/;
	u32 i;
	int		err, sizeRead;
	char	strConFilename[512];
	char*	pConFileName, *p;
	unzFile	hUnzipFile = NULL;
	unz_file_info	fileInfo;

	hUnzipFile = unzOpen(filename);
	if(hUnzipFile == NULL)return FALSE;

	do{
		err = unzGetCurrentFileInfo(hUnzipFile, &fileInfo, strConFilename, 
									sizeof(strConFilename), NULL, 0, NULL, 0);
		if(err!=UNZ_OK){
			unzClose(hUnzipFile);
			return 1;	/*ZIPt@C*/
		}

		p = pConFileName = strConFilename;	/*t@Co*/
		while(*p!='\0'){
			if (*p=='\\' ||*p=='/')pConFileName=p+1;
			p++;
		}

		if(IsGBFilename(strConFilename)){	/*GBt@Cgq̔*/
			if(unzOpenCurrentFile(hUnzipFile)!=UNZ_OK){
				unzClose(hUnzipFile);
				return 2;	/*w肳ꂽt@CĂ*/
			}
			ROM[0] = (u8*)malloc(BANK_SIZE);
			if(ROM[0]==NULL)return 3;	/*̊mۂɎs*/
			sizeRead = unzReadCurrentFile(hUnzipFile, (void*)ROM[0], BANK_SIZE);
			s_rom = rom_size[(ROM[0][0x148])];
			for(i=1; i<s_rom; i++){
				ROM[i] = (u8*)malloc(BANK_SIZE);
				if(ROM[i]==NULL)return 3;
				sizeRead = unzReadCurrentFile(hUnzipFile, (void*)ROM[i], BANK_SIZE);
			}
		}

		unzCloseCurrentFile(hUnzipFile);

		if(IsGBFilename(strConFilename))break;/*ROMt@Cǂ񂾂I*/

	}while(unzGoToNextFile(hUnzipFile) != UNZ_END_OF_LIST_OF_FILE);

	unzClose(hUnzipFile);

	return 0;
}
#endif	/*_WIN32_GDI*/

int CloseGBMemory()
{	/*GB̉*/
	u8 s_rom/*, s_ram*/;
	u32 i;

	if(ROM[0]==NULL)return 0;
	s_rom=rom_size[(ROM[0][0x148])];
/*	s_ram=rom_size[(ROM[0][0x149])];*/

	for(i=0; i<s_rom; i++){
		free(ROM[i]);
		ROM[i]=NULL;
	}

/*	for(i=0; i<s_rom; i++){
		free(RAM[i]);
		RAM[i]=NULL;
	}*/

	return 0;
}

void StaticOpenRomFile(char* filename)
{	/*ÓIROMɃt@Cǂݍ*/
	fp = fopen(filename ,"rb");
	fread(ROM, 1, BANK_SIZE*32, fp);
}


