

/*	
	GameboyVM - Nintendo Gameboy Emulator
		Copyright 2002 Y_N y_n@users.sourceforge.jp
		Homepage https://sourceforge.jp/projects/gbemu/
*/


#include "../include/defines.h"


static void DrawLine()
{	/*8bitpbg*/
	static s32	fba, offset, tma_offset;
	static u16	tdba, tda, tma, tmpx;
	static u8	tdd, tds, tilebit, tmp8;
	static u8	Start, tpy, mpy, mpx;
	static u8	bgp0, bgp1, bgp2, bgp3, obp0, obp1, obp2;

	static u8 LineBuffer[176];

	/*if(MEM[R_LY]>=144)return;*/	/*A͕`悵Ȃ*/

	tma_offset=0;

	bgp0=MEM[R_BGP]&0x03;	/*BG,WNDppbg*/
	bgp1=(MEM[R_BGP]>>2)&0x03+4;
	bgp2=(MEM[R_BGP]>>4)&0x03+8;
	bgp3=(MEM[R_BGP]>>6)&0x03+12;

	memset(LineBuffer, 0, 176);

	if(MEM[R_LCDC]&0x10){	/*^Cf[^̃x[XAhX̑I*/
		tdba=0x8000;
		offset=0x00;
	}else{
		tdba=0x8800;
		offset=0x80;	/*t*/
	}

	Start=MEM[R_SCX];
	mpx=Start>>3;	/*^C}bvX*/
	Start&=7;	/*^Cf[^̃CX*/

	tpy=MEM[R_SCY]+MEM[R_LY];
	mpy=tpy>>3;	/*^C}bvY*/
	tpy&=7;	/*^Cf[^̃CY*/

	if((MEM[R_LCDC]&0x01) && EnableBG){	/*BG̕\*/
		tma=(MEM[R_LCDC]&0x08)?0x9C00:0x9800;	/*^C}bṽAhXI*/
		tma+=mpx+(mpy<<5);
		for(tmpx=0; tmpx<168; tmpx+=8){
			if((31-mpx)<(tmpx>>3))tma_offset=32;	/*^C̃I[o[bv*/
/*			if(offset)tda=0x9000+((s8)(MEM[(tma++)-tma_offset])<<4)+(tpy<<1);
			else tda=tdba+((u8)(MEM[(tma++)-tma_offset])<<4)+(tpy<<1);*/
			tda=tdba+((u8)(MEM[(tma++)-tma_offset]-offset)<<4)+(tpy<<1);
			tdd=MEM[tda++];
			tds=MEM[tda];
			fba=tmpx+8;
			for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
				if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp0;
				if(tdd&~tds&tilebit)LineBuffer[fba]=bgp1;
				if(~tdd&tds&tilebit)LineBuffer[fba]=bgp2;
				if(tdd&tds&tilebit)LineBuffer[fba]=bgp3;
			}
		}
	}

	if((MEM[R_LCDC]&0x20) && EnableWND){	/*EBhE̕\*/
		if(MEM[R_WY]<144 && MEM[R_LY]>=MEM[R_WY] && MEM[R_WX]<167 && MEM[R_WX]>=7){
			tpy=MEM[R_LY]-MEM[R_WY];
			mpy=tpy>>3;	/*^C}bvY*/
			tpy&=7;	/*^Cf[^̃CY*/
			tma=(MEM[R_LCDC]&0x40)?0x9C00:0x9800;
			tma+=mpy<<5;
			for(tmpx=MEM[R_WX]; tmpx<168; tmpx+=8){
				tda=tdba+((u8)(MEM[tma++]+offset)<<4)+(tpy<<1);
				tdd=MEM[tda++];
				tds=MEM[tda];
				fba=tmpx+Start;
				for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
					if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp0;
					if(tdd&~tds&tilebit)LineBuffer[fba]=bgp1;
					if(~tdd&tds&tilebit)LineBuffer[fba]=bgp2;
					if(tdd&tds&tilebit)LineBuffer[fba]=bgp3;
				}
			}
		}
	}

	if((MEM[R_LCDC]&0x02) && EnableOBJ){	/*XvCg̕\*/
		for(tma=0xFE02; tma<0xFEA2; tma+=4){
			if(OBJ_X && OBJ_Y){	/*XvCg͈͊Oɂ:Е̍WO*/
				fba=0;	/*͈͓ɏ*/
				tpy=MEM[R_LY]-OBJ_Y+16;
				if(MEM[R_LCDC]&0x04){	/*8*16[h*/
					if(tpy>=16)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma]&0xFE;	/*LSB͖*/
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x1E-offset;	/*Y]*/
				}else{	/*8*8[h*/
					if(tpy>=8)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma];
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x0E-offset;	/*Y]*/
				}
				if(0<=fba && fba<176){	/*XvCgʊȌꍇI[o[t[*/
					tda=0x8000+(tmp8<<4)+offset;
					tdd=MEM[tda++];
					tds=MEM[tda];	
					/*OBJppbg, ʂQrbg͓F*/
					obp0=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>2):0x03&(MEM[R_OBP0]>>2);
					obp1=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>4):0x03&(MEM[R_OBP0]>>4);
					obp2=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>6):0x03&(MEM[R_OBP0]>>6);
					for(tilebit=OBJ_F&0x20?0x01:0x80; tilebit;	/*XvCĝX]*/
						tilebit=OBJ_F&0x20?tilebit*2:tilebit/2, fba++){
						if(OBJ_F & 0x80){	/*DxႢXvCg̕\*/
							if(!LineBuffer[fba]){	/*pbgԍO*/
								if(tdd&~tds&tilebit)LineBuffer[fba]=obp0;
								if(~tdd&tds&tilebit)LineBuffer[fba]=obp1;
								if(tdd&tds&tilebit)LineBuffer[fba]=obp2;
							}
						}else{	/*DxXvCg\*/
							if(tdd&~tds&tilebit)LineBuffer[fba]=obp0;
							if(~tdd&tds&tilebit)LineBuffer[fba]=obp1;
							if(tdd&tds&tilebit)LineBuffer[fba]=obp2;
						}
					}
				}
			}
		}
	}

	Start+=8;
	fba=MEM[R_LY]*160;
	for(tmpx=0; tmpx<160; tmpx++){
		FrameBuffer[fba+tmpx]=LineBuffer[tmpx+Start];
	}

}



#ifdef	_WIN32_GDI
static void DrawLine16()
{	/*16bitrbg}bv*/
	static u32	fba, offset, tma_offset;
	static u16	tdba, tda, tma, tmpx;
	static u8	tdd, tds, tilebit, tmp8;
	static u8	Start, tpy, mpy, mpx;
	static u16	bgp0, bgp1, bgp2, bgp3, obp0, obp1, obp2;

	static u16	LineBuffer[176];

	/*if(MEM[R_LY]>=144)return;*/	/*A͕`悵Ȃ*/

	tma_offset=0;

	bgp0=Colours16[(MEM[R_BGP]&0x03)];	/*BG,WNDppbg*/
	bgp1=Colours16[(MEM[R_BGP]>>2&0x03)]+1;
	bgp2=Colours16[(MEM[R_BGP]>>4&0x03)]+32;
	bgp3=Colours16[(MEM[R_BGP]>>6&0x03)]+1024;

	memset(LineBuffer, 0, 176);

	if(MEM[R_LCDC]&0x10){	/*^Cf[^̃x[XAhX̑I*/
		tdba = 0x8000;
		offset = 0x00;
	}else{
		tdba = 0x8800;
		offset = 0x80;	/*t*/
	}

	Start=MEM[R_SCX];
	mpx=Start>>3;	/*^C}bvX*/
	Start&=7;	/*^Cf[^̃CX*/
	
	tpy=MEM[R_SCY]+MEM[R_LY];
	mpy=tpy>>3;	/*^C}bvY*/
	tpy&=7;	/*^Cf[^̃CY*/

	if((MEM[R_LCDC]&0x01) && EnableBG){	/*BG̕\*/
		tma=(MEM[R_LCDC]&0x08)?0x9C00:0x9800;	/*^C}bṽAhXI*/
		tma+=mpx+(mpy<<5);
		for(tmpx=0; tmpx<168; tmpx+=8){
			if((31-mpx)<(tmpx>>3))tma_offset=32;	/*^C̃I[o[bv*/
			tda=tdba+((u8)(MEM[(tma++)-tma_offset]-offset)<<4)+(tpy<<1);
			tdd=MEM[tda++];
			tds=MEM[tda];
			fba=tmpx+8;
			for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
				if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp0;
				if(tdd&~tds&tilebit)LineBuffer[fba]=bgp1;
				if(~tdd&tds&tilebit)LineBuffer[fba]=bgp2;
				if(tdd&tds&tilebit)LineBuffer[fba]=bgp3;
			}
		}
	}

	if((MEM[R_LCDC]&0x20) && EnableWND){	/*EBhE̕\*/
		if(MEM[R_WY]<144 && MEM[R_LY]>=MEM[R_WY] && MEM[R_WX]<167 && MEM[R_WX]>=7){
			tpy=MEM[R_LY]-MEM[R_WY];
			mpy=tpy>>3;	/*^C}bvY*/
			tpy&=7;	/*^Cf[^̃CY*/
			tma=(MEM[R_LCDC]&0x40)?0x9C00:0x9800;
			tma+=mpy<<5;
			for(tmpx=MEM[R_WX]; tmpx<168; tmpx+=8){
				tda=tdba+((u8)(MEM[tma++]+offset)<<4)+(tpy<<1);
				tdd=MEM[tda++];
				tds=MEM[tda];
				fba=tmpx+Start;
				for(tilebit=0x80; tilebit; tilebit>>=1, fba++){
					if(~tdd&~tds&tilebit)LineBuffer[fba]=bgp0;
					if(tdd&~tds&tilebit)LineBuffer[fba]=bgp1;
					if(~tdd&tds&tilebit)LineBuffer[fba]=bgp2;
					if(tdd&tds&tilebit)LineBuffer[fba]=bgp3;
				}
			}
		}
	}

	if((MEM[R_LCDC]&0x02) && EnableOBJ){
		for(tma=0xFE02; tma<0xFEA2; tma+=4){
			if(OBJ_X && OBJ_Y){	/*XvCg͈͊Oɂ:Е̍WO*/
				fba=0;	/*͈͓ɏ*/
				tpy=MEM[R_LY]-OBJ_Y+16;
				if(MEM[R_LCDC]&0x04){	/*8*16[h*/
					if(tpy>=16)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma]&0xFE;	/*LSB͖*/
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x1E-offset;	/*Y]*/
				}else{	/*8*8[h*/
					if(tpy>=8)fba=255;	/*YW͈͊O*/
					else fba=OBJ_X+Start;
					tmp8=MEM[tma];
					offset=tpy<<1;
					if(OBJ_F&0x40)offset=0x0E-offset;	/*Y]*/
				}
				if(0<=fba && fba<176){	/*XvCgʊȌꍇI[o[t[*/
					tda=0x8000+(tmp8<<4)+offset;
					tdd=MEM[tda++];
					tds=MEM[tda];	
					/*OBJppbg, ʂQrbg͓F*/
					obp0=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>2):0x03&(MEM[R_OBP0]>>2);
					obp1=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>4):0x03&(MEM[R_OBP0]>>4);
					obp2=(OBJ_F&0x10)?0x03&(MEM[R_OBP1]>>6):0x03&(MEM[R_OBP0]>>6);
					obp0=Colours16[(obp0)];
					obp1=Colours16[(obp1)];
					obp2=Colours16[(obp2)];
					for(tilebit=OBJ_F&0x20?0x01:0x80; tilebit;	/*XvCĝX]*/
						tilebit=OBJ_F&0x20?tilebit*2:tilebit/2, fba++){
						if(OBJ_F & 0x80){	/*DxႢXvCg̕\*/
							if(LineBuffer[fba]==Colours16[0]){	/*pbgԍO*/
								if(tdd&~tds&tilebit)LineBuffer[fba]=obp0;
								if(~tdd&tds&tilebit)LineBuffer[fba]=obp1;
								if(tdd&tds&tilebit)LineBuffer[fba]=obp2;
							}
						}else{	/*DxXvCg\*/
							if(tdd&~tds&tilebit)LineBuffer[fba]=obp0;
							if(~tdd&tds&tilebit)LineBuffer[fba]=obp1;
							if(tdd&tds&tilebit)LineBuffer[fba]=obp2;
						}
					}
				}
			}
		}
	}

	Start+=8;
	fba=MEM[R_LY]*160;
	for(tmpx=0; tmpx<160; tmpx++){
		FrameBuffer16[fba+tmpx]=LineBuffer[tmpx+Start];
	}
}


#include "2xsai.c"

#endif	/*_WIN32_GDI*/

