// Disasm.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "Disasm.h"
#include "GBEmuDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//---------------------------------  ^`
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef signed char s8;
typedef signed short s16;
typedef signed int s32;
typedef unsigned char byte;
typedef unsigned short hword;
typedef unsigned int word;

extern BYTE MEM[0x10000];
extern u8 Rmem(u16);
extern bool fAsmDlg, fStop, fNext, fBreak;
extern u16	bp1, bp2, bp3;
extern u32 HexToInt(char *hexstr);

/*
typedef struct {
	unsigned char lowbyte;
	unsigned char highbyte;
}REG8;

typedef union {
	REG8 reg8;
	unsigned short	reg16;
}REGPAIR;

typedef struct{		// CPUWX^
	REGPAIR af;		// AL[[^AėpWX^
	REGPAIR bc;
	REGPAIR de;
	REGPAIR hl;
	unsigned short	sp;			//@X^bN|C^
	REGPAIR pc;		// vOJE^
	unsigned char	ime;		// 荞݃}X^[tO
	unsigned char	halt;
	unsigned char	stop;
	unsigned char running;	// C[v̓tO
}CPU_REGS;
*/

typedef struct{		// CPUWX^
	unsigned short	af;		// AL[[^AėpWX^
	unsigned short	bc;
	unsigned short	de;
	unsigned short	hl;
	unsigned short	sp;			//@X^bN|C^
	unsigned short	pc;		// vOJE^
	unsigned char	ime;		// 荞݃}X^[tO
	unsigned char	halt;
	unsigned char	stop;
	unsigned char	running;	// C[v̓tO
}CPU_REGS;

extern CPU_REGS cpu;

#define		A		(u8)(cpu.af>>8)
#define		F		(u8)cpu.af
#define		B		(u8)(cpu.bc>>8)
#define		C		(u8)cpu.bc
#define		D		(u8)(cpu.de>>8)
#define		E		(u8)cpu.de
#define		H		(u8)(cpu.hl>>8)
#define		L		(u8)cpu.hl

#define		AF		cpu.af
#define		BC		cpu.bc
#define		DE		cpu.de
#define		HL		cpu.hl
#define		SP		cpu.sp
#define		PC		cpu.pc

#define		IME		cpu.ime
#define		HALT	cpu.halt
#define		STOP	cpu.stop
#define		CPUIsRunning	cpu.running

/*--------------------------------- tO̓ǂݏ}N*/
#define	_Z	0x80
#define _N	0x40
#define _H	0x20
#define _C	0x10
#define SF(_flag)	AF|=_flag
#define RF(_flag)	AF&=~_flag
#define FZ	((F>>7)&0x01)
#define FN	((F>>6)&0x01)
#define FH	((F>>5)&0x01)
#define FC	((F>>4)&0x01)

u8 source[256]=
{
	0,2,0,0,0,0,1,0,
	2,0,0,0,0,0,1,0,
	0,2,0,0,0,0,1,0,
	3,0,0,0,0,0,1,0,
	3,2,0,0,0,0,1,0,
	3,0,0,0,0,0,1,0,
	3,2,0,0,0,0,1,0,
	3,0,0,0,0,0,1,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,2,2,2,0,1,0,
	0,0,2,4,2,2,1,0,
	0,0,2,1,2,0,1,0,
	0,0,2,1,2,0,1,0,
	1,0,0,0,2,0,1,0,
	1,0,2,0,2,0,1,0,
	1,0,0,0,2,0,1,0,
	0,0,2,0,2,0,1,0,
};

static char *mnemonic[256]=
{
	"nop"      ,"ld bc,%02x%02x","ld (bc),a", "inc bc", "inc b" ,"dec b"    ,"ld b,%02x" ,"rlca"     ,
	"ld (%02x%02x),sp","add hl,bc", "ld a,(bc)", "dec bc" ,"inc c" ,"dec c" ,"ld c,%02x" ,"rrca"     ,
	"stop"     ,"ld de,%02x%02x","ld (de),a","inc de" ,"inc d" ,"dec d" ,"ld d,%02x"     ,"rla"      ,
	"jr %02x"   ,"add hl,de","ld a,(de)","dec de"    ,"inc e"    ,"dec e"    ,"ld e,%02x","rra"      ,
	"jr nz,%02x","ld hl,%02x%02x","ldi (hl),a","inc hl"    ,"inc h"    ,"dec h"    ,"ld h,%02x","daa",
	"jr z,%02x" ,"add hl,hl","ldi a,(hl)","dec hl"    ,"inc l"    ,"dec l"    ,"ld l,%02x"    ,"cpl" ,
	"jr nc,%02x","ld sp,%02x%02x","ldd (hl),a","inc sp","inc (hl)","dec (hl)","ld (hl),%02x","scf"   ,
	"jr c,%02x" ,"add hl,sp","ldd a,(hl)","dec sp"  ,"inc a"    ,"dec a"    ,"ld a,%02x" ,"ccf"      ,
	"ld b,b"   ,"ld b,c"   ,"ld b,d"   ,"ld b,e"    ,"ld b,h"   ,"ld b,l"   ,"ld b,(hl)" ,"ld b,a"   ,
	"ld c,b"   ,"ld c,c"   ,"ld c,d"   ,"ld c,e"    ,"ld c,h"   ,"ld c,l"   ,"ld c,(hl)" ,"ld c,a"   ,
	"ld d,b"   ,"ld d,c"   ,"ld d,d"   ,"ld d,e"    ,"ld d,h"   ,"ld d,l"   ,"ld d,(hl)" ,"ld d,a"   ,
	"ld e,b"   ,"ld e,c"   ,"ld e,d"   ,"ld e,e"    ,"ld e,h"   ,"ld e,l"   ,"ld e,(hl)" ,"ld e,a"   ,
	"ld h,b"   ,"ld h,c"   ,"ld h,d"   ,"ld h,e"    ,"ld h,h"   ,"ld h,l"   ,"ld h,(hl)" ,"ld h,a"   ,
	"ld l,b"   ,"ld l,c"   ,"ld l,d"   ,"ld l,e"    ,"ld l,h"   ,"ld l,l"   ,"ld l,(hl)" ,"ld l,a"   ,
	"ld (hl),b","ld (hl),c","ld (hl),d","ld (hl),e" ,"ld (hl),h","ld (hl),l","halt"      ,"ld (hl),a",
	"ld a,b"   ,"ld a,c"   ,"ld a,d"   ,"ld a,e"    ,"ld a,h"   ,"ld a,l"   ,"ld a,(hl)" ,"ld a,a"   ,
	"add a,b"  ,"add a,c"  ,"add a,d"  ,"add a,e"   ,"add a,h"  ,"add a,l"  ,"add a,(hl)","add a,a"  ,
	"adc a,b"  ,"adc a,c"  ,"adc a,d"  ,"adc a,e"   ,"adc a,h"  ,"adc a,l"  ,"adc a,(hl)","adc a,a"  ,
	"sub b"    ,"sub c"    ,"sub d"    ,"sub e"     ,"sub h"    ,"sub l"    ,"sub (hl)"  ,"sub a"    ,
	"sbc a,b"  ,"sbc a,c"  ,"sbc a,d"  ,"sbc a,e"   ,"sbc a,h"  ,"sbc a,l"  ,"sbc a,(hl)","sbc a,a"  ,
	"and b"    ,"and c"    ,"and d"    ,"and e"     ,"and h"    ,"and l"    ,"and (hl)"  ,"and a"    ,
	"xor b"    ,"xor c"    ,"xor d"    ,"xor e"     ,"xor h"    ,"xor l"    ,"xor (hl)"  ,"xor a"    ,
	"or b"     ,"or c"     ,"or d"     ,"or e"      ,"or h"     ,"or l"     ,"or (hl)"   ,"or a"     ,
	"cp b"     ,"cp c"     ,"cp d"     ,"cp e"      ,"cp h"     ,"cp l"     ,"cp (hl)"   ,"cp a"     ,
	"ret nz"   ,"pop bc"   ,"jp nz,%02x%02x","jp %02x%02x"      ,"call nz,%02x%02x","push bc"  ,"add a,%02x"   ,"rst 00h"  ,
	"ret z"    ,"ret"      ,"jp z,%02x%02x","cb, "  ,"call z,%02x%02x" ,"call %02x%02x"   ,"adc a,%02x"   ,"rst 08h"  ,
	"ret nc"   ,"pop de"   ,"jp nc,%02x%02x","out (%02x),a","call nc,%02x%02x","push de"  ,"sub %02x"     ,"rst 10h"  ,
	"ret c"    ,"reti"     ,"jp c,%02x%02x","in a,(%02x)","call c,%02x%02x" ,"dd"       ,"sbc a,%02x"   ,"rst 18h"  ,
	"ld (0xff00+%02x),a" ,"pop hl"   ,"ld $ff00(c),a","@"     ,"call po,%02x%02x","push hl","and %02x"  ,"rst 20h"  ,
	"add sp,%02x","jp hl"  ,"ld (%02x%02x),a","@"   ,"call pe,%02x%02x","ed"       ,"xor %02x"     ,"rst 28h"  ,
	"ld a,(0xff00+%02x)" ,"pop af"   ,"ld a,$ff00(c)","di"    ,"call p,%02x%02x" ,"push af"  ,"or %02x"      ,"rst 30h"  ,
	"ld hl,sp" ,"ld sp,hl" ,"ld a,(%02x%02x)","ei"  ,"call m,%02x%02x" ,"fd"       ,"cp %02x"      ,"rst 38h",
};


static char *mnemonic_cb[256]=
{
	"rlc b"  ,"rlc c"  ,"rlc d"  ,"rlc e"  ,"rlc h"  ,"rlc l"  ,"rlc (hl)"  ,"rlc a"  ,
	"rrc b"  ,"rrc c"  ,"rrc d"  ,"rrc e"  ,"rrc h"  ,"rrc l"  ,"rrc (hl)"  ,"rrc a"  ,
	"rl b"   ,"rl c"   ,"rl d"   ,"rl e"   ,"rl h"   ,"rl l"   ,"rl (hl)"   ,"rl a"   ,
	"rr b"   ,"rr c"   ,"rr d"   ,"rr e"   ,"rr h"   ,"rr l"   ,"rr (hl)"   ,"rr a"   ,
	"sla b"  ,"sla c"  ,"sla d"  ,"sla e"  ,"sla h"  ,"sla l"  ,"sla (hl)"  ,"sla a"  ,
	"sra b"  ,"sra c"  ,"sra d"  ,"sra e"  ,"sra h"  ,"sra l"  ,"sra (hl)"  ,"sra a"  ,
	"swap b"  ,"swap c"  ,"swap d"  ,"swap e"  ,"swap h"  ,"swap l"  ,"swap (hl)"  ,"swap a"  ,
	"srl b"  ,"srl c"  ,"srl d"  ,"srl e"  ,"srl h"  ,"srl l"  ,"srl (hl)"  ,"srl a"  ,
	"bit 0,b","bit 0,c","bit 0,d","bit 0,e","bit 0,h","bit 0,l","bit 0,(hl)","bit 0,a",
	"bit 1,b","bit 1,c","bit 1,d","bit 1,e","bit 1,h","bit 1,l","bit 1,(hl)","bit 1,a",
	"bit 2,b","bit 2,c","bit 2,d","bit 2,e","bit 2,h","bit 2,l","bit 2,(hl)","bit 2,a",
	"bit 3,b","bit 3,c","bit 3,d","bit 3,e","bit 3,h","bit 3,l","bit 3,(hl)","bit 3,a",
	"bit 4,b","bit 4,c","bit 4,d","bit 4,e","bit 4,h","bit 4,l","bit 4,(hl)","bit 4,a",
	"bit 5,b","bit 5,c","bit 5,d","bit 5,e","bit 5,h","bit 5,l","bit 5,(hl)","bit 5,a",
	"bit 6,b","bit 6,c","bit 6,d","bit 6,e","bit 6,h","bit 6,l","bit 6,(hl)","bit 6,a",
	"bit 7,b","bit 7,c","bit 7,d","bit 7,e","bit 7,h","bit 7,l","bit 7,(hl)","bit 7,a",
	"res 0,b","res 0,c","res 0,d","res 0,e","res 0,h","res 0,l","res 0,(hl)","res 0,a",
	"res 1,b","res 1,c","res 1,d","res 1,e","res 1,h","res 1,l","res 1,(hl)","res 1,a",
	"res 2,b","res 2,c","res 2,d","res 2,e","res 2,h","res 2,l","res 2,(hl)","res 2,a",
	"res 3,b","res 3,c","res 3,d","res 3,e","res 3,h","res 3,l","res 3,(hl)","res 3,a",
	"res 4,b","res 4,c","res 4,d","res 4,e","res 4,h","res 4,l","res 4,(hl)","res 4,a",
	"res 5,b","res 5,c","res 5,d","res 5,e","res 5,h","res 5,l","res 5,(hl)","res 5,a",
	"res 6,b","res 6,c","res 6,d","res 6,e","res 6,h","res 6,l","res 6,(hl)","res 6,a",
	"res 7,b","res 7,c","res 7,d","res 7,e","res 7,h","res 7,l","res 7,(hl)","res 7,a",
	"set 0,b","set 0,c","set 0,d","set 0,e","set 0,h","set 0,l","set 0,(hl)","set 0,a",
	"set 1,b","set 1,c","set 1,d","set 1,e","set 1,h","set 1,l","set 1,(hl)","set 1,a",
	"set 2,b","set 2,c","set 2,d","set 2,e","set 2,h","set 2,l","set 2,(hl)","set 2,a",
	"set 3,b","set 3,c","set 3,d","set 3,e","set 3,h","set 3,l","set 3,(hl)","set 3,a",
	"set 4,b","set 4,c","set 4,d","set 4,e","set 4,h","set 4,l","set 4,(hl)","set 4,a",
	"set 5,b","set 5,c","set 5,d","set 5,e","set 5,h","set 5,l","set 5,(hl)","set 5,a",
	"set 6,b","set 6,c","set 6,d","set 6,e","set 6,h","set 6,l","set 6,(hl)","set 6,a",
	"set 7,b","set 7,c","set 7,d","set 7,e","set 7,h","set 7,l","set 7,(hl)","set 7,a"
};


/////////////////////////////////////////////////////////////////////////////
// CDisasm _CAO


CDisasm::CDisasm(CWnd* pParent /*=NULL*/)
	: CDialog(CDisasm::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDisasm)
	m_fC = FALSE;
	m_fH = FALSE;
	m_fIME = FALSE;
	m_fN = FALSE;
	m_fZ = FALSE;
	m_txtAF = _T("");
	m_txtBC = _T("");
	m_txtDE = _T("");
	m_txtHL = _T("");
	m_txtPC = _T("");
	m_txtSP = _T("");
	m_fInt1 = FALSE;
	m_fInt2 = FALSE;
	m_fInt3 = FALSE;
	m_fInt4 = FALSE;
	m_fInt5 = FALSE;
	m_txtBreak1 = _T("");
	m_txtBreak2 = _T("");
	m_txtBreak3 = _T("");
	m_fBreak = FALSE;
	m_txtGoto = _T("");
	m_txtMode = _T("");
	//}}AFX_DATA_INIT

	m_pTDasm=NULL;
}


void CDisasm::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDisasm)
	DDX_Control(pDX, IDC_STACK_LIST, m_lstStack);
	DDX_Control(pDX, IDC_DISASM_LIST, m_lstDasm);
	DDX_Check(pDX, IDC_FLAG_C, m_fC);
	DDX_Check(pDX, IDC_FLAG_H, m_fH);
	DDX_Check(pDX, IDC_FLAG_IME, m_fIME);
	DDX_Check(pDX, IDC_FLAG_N, m_fN);
	DDX_Check(pDX, IDC_FLAG_Z, m_fZ);
	DDX_Text(pDX, IDC_REG_AF, m_txtAF);
	DDX_Text(pDX, IDC_REG_BC, m_txtBC);
	DDX_Text(pDX, IDC_REG_DE, m_txtDE);
	DDX_Text(pDX, IDC_REG_HL, m_txtHL);
	DDX_Text(pDX, IDC_REG_PC, m_txtPC);
	DDX_Text(pDX, IDC_REG_SP, m_txtSP);
	DDX_Check(pDX, IDC_INTERRUPT1, m_fInt1);
	DDX_Check(pDX, IDC_INTERRUPT2, m_fInt2);
	DDX_Check(pDX, IDC_INTERRUPT3, m_fInt3);
	DDX_Check(pDX, IDC_INTERRUPT4, m_fInt4);
	DDX_Check(pDX, IDC_INTERRUPT5, m_fInt5);
	DDX_Text(pDX, IDC_BREAK_POINT1, m_txtBreak1);
	DDV_MaxChars(pDX, m_txtBreak1, 4);
	DDX_Text(pDX, IDC_BREAK_POINT2, m_txtBreak2);
	DDV_MaxChars(pDX, m_txtBreak2, 4);
	DDX_Text(pDX, IDC_BREAK_POINT3, m_txtBreak3);
	DDV_MaxChars(pDX, m_txtBreak3, 4);
	DDX_Check(pDX, IDC_CHECK_BREAK, m_fBreak);
	DDX_Text(pDX, IDC_EDIT_GOTO, m_txtGoto);
	DDV_MaxChars(pDX, m_txtGoto, 4);
	DDX_Text(pDX, IDC_MODE_FLAG, m_txtMode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDisasm, CDialog)
	//{{AFX_MSG_MAP(CDisasm)
	ON_WM_CLOSE()
	ON_WM_ACTIVATE()
	ON_BN_CLICKED(IDC_GOTO, OnGoto)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_RUN, OnRun)
	ON_BN_CLICKED(IDC_NEXT, OnNext)
	ON_BN_CLICKED(IDC_CHECK_BREAK, OnCheckBreak)
	ON_EN_KILLFOCUS(IDC_BREAK_POINT1, OnKillfocusBreakPoint1)
	ON_EN_KILLFOCUS(IDC_BREAK_POINT2, OnKillfocusBreakPoint2)
	ON_EN_KILLFOCUS(IDC_BREAK_POINT3, OnKillfocusBreakPoint3)
	ON_BN_CLICKED(IDC_FLAG_Z, OnFlagZ)
	ON_BN_CLICKED(IDC_FLAG_N, OnFlagN)
	ON_BN_CLICKED(IDC_FLAG_H, OnFlagH)
	ON_BN_CLICKED(IDC_FLAG_C, OnFlagC)
	ON_BN_CLICKED(IDC_FLAG_IME, OnFlagIme)
	ON_BN_CLICKED(IDC_INTERRUPT1, OnInterrupt1)
	ON_BN_CLICKED(IDC_INTERRUPT2, OnInterrupt2)
	ON_BN_CLICKED(IDC_INTERRUPT3, OnInterrupt3)
	ON_BN_CLICKED(IDC_INTERRUPT4, OnInterrupt4)
	ON_BN_CLICKED(IDC_INTERRUPT5, OnInterrupt5)
	ON_BN_CLICKED(IDC_RESET, OnReset)
	ON_LBN_DBLCLK(IDC_DISASM_LIST, OnDblclkDisasmList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDisasm bZ[W nh

void CDisasm::OnClose() 
{
	fAsmDlg=false;
	fStop=false;
	Sleep(300);
	CDialog::OnClose();
}

void CDisasm::ShowDebug()
{
	UpdateRegs();
	UpdateStack(true);
//	UpdateDisasm();
	CString Message;
	Message.LoadString(IDS_DISASSEMBLING);
	Message.Format(Message, 0);

	CDialog::SetWindowText(Message);
	m_pTDasm = AfxBeginThread(ThreadDasm, this);
}

void CDisasm::UpdateStack(BOOL fUpdate)
{
	char spbuf[20];
	char sdatabuf[10];
	u16 sp, tmpsp;
	int offset;

	if(fUpdate){
		sp=((offset=SP-6)<0)?0:SP+offset;
		tmpsp=((offset=sp+10)>0xFFFF)?sp+offset-0xFFFF:sp+10;
		m_lstStack.ResetContent();
		for(; sp<tmpsp; sp+=2){	// X^bNf[^̕\
			_itoa(sp, spbuf, 16);
			strcat(spbuf, " :  ");
			_itoa(MEM[sp+1], sdatabuf, 16);
			if(strlen(sdatabuf)<=1){	// h~
				sdatabuf[1]=sdatabuf[0];
				sdatabuf[0]='0';
				sdatabuf[2]='\0';
			}
			strcat(spbuf, sdatabuf);
			_itoa(MEM[sp], sdatabuf, 16);
			if(strlen(sdatabuf)<=1){	// h~
				sdatabuf[1]=sdatabuf[0];
				sdatabuf[0]='0';
				sdatabuf[2]='\0';
			}
			strcat(spbuf, sdatabuf);
			m_lstStack.AddString(spbuf);
		}
	}
	
	_itoa(SP, spbuf, 16);
	m_lstStack.SelectString(-1,spbuf);	//|C^̃Z̑I
}

void CDisasm::UpdateRegs()
{
	char strbuf[20];

	UpdateData(true);
	m_fZ=(FZ)?true:false;
	m_fN=(FN)?true:false;
	m_fH=(FH)?true:false;
	m_fC=(FC)?true:false;
	m_fIME=(IME)?true:false;
	m_fInt1=(MEM[0xFFFF]&0x01)?true:false;
	m_fInt2=(MEM[0xFFFF]&0x02)?true:false;
	m_fInt3=(MEM[0xFFFF]&0x04)?true:false;
	m_fInt4=(MEM[0xFFFF]&0x08)?true:false;
	m_fInt5=(MEM[0xFFFF]&0x10)?true:false;
	_itoa(AF, strbuf, 16);
	m_txtAF=strbuf;
	_itoa(BC, strbuf, 16);
	m_txtBC=strbuf;
	_itoa(DE, strbuf, 16);
	m_txtDE=strbuf;
	_itoa(HL, strbuf, 16);
	m_txtHL=strbuf;
	_itoa(SP, strbuf, 16);
	m_txtSP=strbuf;
	_itoa(PC, strbuf, 16);
	m_txtPC=strbuf;
	switch((BYTE)(MEM[0xFF41]&3)){
	case 0 :strcpy(strbuf, "H-blank");break;
	case 1 :strcpy(strbuf, "V-blank");break;
	case 2 :strcpy(strbuf, "OAM");break;
	case 3 :strcpy(strbuf, "OAM/VRAM");break;
	}
	m_txtMode=strbuf;
	UpdateData(false);
}

void CDisasm::SetDisasm()
{
	CString prefix;
	prefix.Format("%04x", PC);
	m_lstDasm.SelectString(0, prefix);
}

void CDisasm::UpdateDisasm()
{
	u16 pc=0;//x0150;
	u8 opcode;
	char opstr[20];
	CString outstr;
	CString Message;
	DWORD UpdateTime = GetTickCount() + 100;

	m_lstDasm.ResetContent();
	while(pc<0x8000){
		opcode=Rmem(pc);
		strcpy(opstr, "%04x :  ");
		strcat(opstr, mnemonic[opcode]);
		switch(source[opcode]){
			case 1: // Prbg
				outstr.Format(opstr, pc, Rmem(pc+1));
				pc++;
				break;
			case 2:	// Qrbg
				outstr.Format(opstr, pc, Rmem(pc+2), Rmem(pc+1));
				pc+=2;
				break;
			case 3:	// tPrbg
				outstr.Format(opstr, pc, Rmem(pc+1));
				pc++;
				break;
			case 4:	// CBvtBbNX
				strcat(opstr, mnemonic_cb[(Rmem(pc+1))]);
				outstr.Format(opstr, pc);
				pc++;
				break;
			default:
				outstr.Format(opstr, pc);
		}
		pc++;
		m_lstDasm.AddString(outstr);
		if(UpdateTime<GetTickCount()){
			UpdateTime = GetTickCount() + 100;
			Message.LoadString(IDS_DISASSEMBLING);
			Message.Format(Message, (u16)(pc)/333);
			CDialog::SetWindowText(Message);
		}
	}

	Message.LoadString(IDS_DEBUGGER_TITLE);
	CDialog::SetWindowText(Message);
}

UINT CDisasm::ThreadDasm(LPVOID pParam)
{
	((CDisasm*)pParam)->UpdateDisasm();

	return 0;
}

void CDisasm::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	
	if(nState!=WA_INACTIVE){
		UpdateStack(true);
		UpdateRegs();
		SetDisasm();
		if(!fStop)CDialog::SetWindowText("Debugger - Stop");
	}
}


void CDisasm::OnGoto() 
{
	UpdateData(true);
	if(HexToInt(m_txtGoto.GetBuffer(10))!=0xFFFFFFFF){
		PC=HexToInt(m_txtGoto.GetBuffer(10));
		UpdateRegs();
	}else{
		MessageBox("Please input the number of Hex.", NULL, MB_ICONSTOP);
		GetDlgItem(IDC_EDIT_GOTO)->SetFocus();
	}
	UpdateData(false);
	
	m_txtGoto.ReleaseBuffer();
}

void CDisasm::OnStop() 
{
	fStop=true;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
	UpdateRegs();
	UpdateStack(true);
	SetDisasm();
	
	CDialog::SetWindowText("Debugger - Stop");
}

void CDisasm::OnRun() 
{
	fStop=false;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
	
	CDialog::SetWindowText("Debugger - Running..");
}

void CDisasm::OnNext() 
{
	fNext=true;
	fStop=false;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
	
	CDialog::SetWindowText("Debugger");
}

void CDisasm::OnCheckBreak() 
{
	CButton* pBPchk = (CButton*)GetDlgItem(IDC_CHECK_BREAK);
	if(fBreak){
		pBPchk->SetCheck(0);
		fBreak=false;
		GetDlgItem(IDC_BREAK_POINT1)->EnableWindow(true);
		GetDlgItem(IDC_BREAK_POINT2)->EnableWindow(true);
		GetDlgItem(IDC_BREAK_POINT3)->EnableWindow(true);
	}else{
		pBPchk->SetCheck(1);
		fBreak=true;
		GetDlgItem(IDC_BREAK_POINT1)->EnableWindow(false);
		GetDlgItem(IDC_BREAK_POINT2)->EnableWindow(false);
		GetDlgItem(IDC_BREAK_POINT3)->EnableWindow(false);
		UpdateData(true);
		bp1=(u16)HexToInt(m_txtBreak1.GetBuffer(10));
		m_txtBreak1.ReleaseBuffer();
		bp2=(u16)HexToInt(m_txtBreak2.GetBuffer(10));
		m_txtBreak2.ReleaseBuffer();
		bp3=(u16)HexToInt(m_txtBreak3.GetBuffer(10));
		m_txtBreak3.ReleaseBuffer();
		UpdateData(false);
	}
}

void CDisasm::OnKillfocusBreakPoint1() 
{
	UpdateData(true);
	if(HexToInt(m_txtBreak1.GetBuffer(10))==0xFFFFFFFF)
		MessageBox("Please input the number of Hex.", NULL, MB_ICONSTOP);
	UpdateData(false);

	m_txtBreak1.ReleaseBuffer();
}

void CDisasm::OnKillfocusBreakPoint2() 
{
	UpdateData(true);
	if(HexToInt(m_txtBreak2.GetBuffer(10))==0xFFFFFFFF)
		MessageBox("Please input the number of Hex.", NULL, MB_ICONSTOP);
	UpdateData(false);

	m_txtBreak2.ReleaseBuffer();
}

void CDisasm::OnKillfocusBreakPoint3() 
{
	UpdateData(true);
	if(HexToInt(m_txtBreak3.GetBuffer(10))==0xFFFFFFFF)
		MessageBox("Please input the number of Hex.", NULL, MB_ICONSTOP);
	UpdateData(false);
	
	m_txtBreak3.ReleaseBuffer();
}

BOOL CDisasm::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN){
		switch(pMsg->wParam){
			case VK_ESCAPE:
				return false;
			case VK_F5:
				if(fKeyShift)OnStop();
				else OnRun();
				break;
			case VK_F7:
				OnNext();
				break;
			case VK_SHIFT:
				fKeyShift=true;
				break;
			case VK_CONTROL:
				fKeyCtrl=true;
				break;
			default:
				break;
		}
	}
	if(pMsg->message == WM_KEYUP){
		switch(pMsg->wParam){
			case VK_SHIFT:
				fKeyShift=false;
				break;
			case VK_CONTROL:
				fKeyCtrl=false;
				break;
			default:
				break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CDisasm::OnFlagZ() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_FLAG_Z);
	if(FZ){
		RF(_Z);
		UpdateRegs();
	}else{
		SF(_Z);
		UpdateRegs();
	}
}

void CDisasm::OnFlagN() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_FLAG_N);
	if(FN){
		RF(_N);
		UpdateRegs();
	}else{
		SF(_N);
		UpdateRegs();
	}	
}

void CDisasm::OnFlagH() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_FLAG_H);
	if(FH){
		RF(_H);
		UpdateRegs();
	}else{
		SF(_H);
		UpdateRegs();
	}
}

void CDisasm::OnFlagC() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_FLAG_C);
	if(FC){
		RF(_C);
		UpdateRegs();
	}else{
		SF(_C);
		UpdateRegs();
	}
}

void CDisasm::OnFlagIme() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_FLAG_IME);
	if(IME){
		IME=0;
		UpdateRegs();
	}else{
		IME=1;
		UpdateRegs();
	}
}

void CDisasm::OnInterrupt1() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_INTERRUPT1);
	if(MEM[0xFFFF]&0x01){
		MEM[0xFFFF]&=~0x01;
		UpdateRegs();
	}else{
		MEM[0xFFFF]|=0x01;
		UpdateRegs();
	}
}

void CDisasm::OnInterrupt2() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_INTERRUPT2);
	if(MEM[0xFFFF]&0x02){
		MEM[0xFFFF]&=~0x02;
		UpdateRegs();
	}else{
		MEM[0xFFFF]|=0x02;
		UpdateRegs();
	}
}

void CDisasm::OnInterrupt3() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_INTERRUPT3);
	if(MEM[0xFFFF]&0x04){
		MEM[0xFFFF]&=~0x04;
		UpdateRegs();
	}else{
		MEM[0xFFFF]|=0x04;
		UpdateRegs();
	}
}

void CDisasm::OnInterrupt4() 
{
	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_INTERRUPT4);
	if(MEM[0xFFFF]&0x08){
		MEM[0xFFFF]&=~0x08;
		UpdateRegs();
	}else{
		MEM[0xFFFF]|=0x08;
		UpdateRegs();
	}
}

void CDisasm::OnInterrupt5() 
{	CButton* pFlagchk = (CButton*)GetDlgItem(IDC_INTERRUPT5);
	if(MEM[0xFFFF]&0x10){
		MEM[0xFFFF]&=~0x10;
		UpdateRegs();
	}else{
		MEM[0xFFFF]|=0x10;
		UpdateRegs();
	}
}

void CDisasm::OnReset() 
{
//	AfxGetMainWnd()->SendMessage(OnMenuReset, 0, 0);	
}

void CDisasm::OnOK()
{

}

void CDisasm::OnCancel()
{
	EndDialog(0);
}

BOOL CDisasm::OnInitDialog() 
{
	CDialog::OnInitDialog();

	fKeyShift=fKeyCtrl=false;	
	bp1=bp2=bp3=0xffff;

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDisasm::OnDblclkDisasmList() 
{
	char str[30];

	m_lstDasm.GetText(m_lstDasm.GetCurSel(), str);

	str[4]='\0';	/*AhX̕؂o*/

	/*󔒂̃eLXg{bNXɑIꂽZ̃AhX\*/
	UpdateData(true);
	if(HexToInt(m_txtBreak3.GetBuffer(10))==0xFFFFFFFE){
		m_txtBreak3.ReleaseBuffer();
		m_txtBreak3 = str;
		UpdateData(false);
		return;
	}else if(HexToInt(m_txtBreak2.GetBuffer(10))==0xFFFFFFFE){
		m_txtBreak3.ReleaseBuffer();
		m_txtBreak2.ReleaseBuffer();
		m_txtBreak2 = str;
		UpdateData(false);
		return;
	}else if(HexToInt(m_txtBreak1.GetBuffer(10))==0xFFFFFFFE){
		m_txtBreak3.ReleaseBuffer();
		m_txtBreak2.ReleaseBuffer();
		m_txtBreak1.ReleaseBuffer();
		m_txtBreak1 = str;
		UpdateData(false);
		return;
	}else{
		m_txtBreak3.ReleaseBuffer();
		m_txtBreak2.ReleaseBuffer();
		m_txtBreak1.ReleaseBuffer();
		m_txtBreak3 = str;
		UpdateData(false);
	}
}
