// MemDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "MemDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern unsigned char RMem(unsigned short);
extern bool fMemDlg;

/////////////////////////////////////////////////////////////////////////////
// CMemDlg _CAO


CMemDlg::CMemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemDlg)
	m_txtAdr = 0;
	//}}AFX_DATA_INIT
}


void CMemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemDlg)
	DDX_Control(pDX, IDC_ADR_CMB, m_Memcmb);
	DDX_Control(pDX, IDC_MEMORY_LIST, m_Memlst);
	DDX_Text(pDX, IDC_EDIT_ADR, m_txtAdr);
	DDV_MinMaxUInt(pDX, m_txtAdr, 0, 65535);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMemDlg, CDialog)
	//{{AFX_MSG_MAP(CMemDlg)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_DUMP, OnDump)
	ON_CBN_SELCHANGE(IDC_ADR_CMB, OnSelchangeAdrCmb)
	ON_BN_CLICKED(IDC_GO, OnGo)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemDlg bZ[W nh

BOOL CMemDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMemDlg::OnClose() 
{	// tO߂ă_CAO
	fMemDlg=false;	
	CDialog::OnClose();
}

void CMemDlg::ShowMemory()
{	// _v\
	CString MemLine="";
	int ly, lx, ml=0x0000;
	char tm[5];

	CFont* pFont = new CFont;
	pFont->CreatePointFont(10, _T("Courier"));	// tHg
	m_Memlst.SetFont(pFont);

	m_Memlst.ResetContent();
	m_Memlst.AddString("     +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F");
	
	for(ly=0; ly<0x1000; ly++){
		_itoa((int)ml, tm, 16);
		if(strlen(tm)==1)MemLine="000";
		else if(strlen(tm)==2)MemLine="00";
		else if(strlen(tm)==3)MemLine="0";
		else MemLine="\0";
		MemLine+=tm;
		for(lx=0; lx<16; lx++,ml++){
			_itoa((int)RMem(ml), tm, 16);
			if(strlen(tm)==1)MemLine=MemLine+" 0";
			else MemLine=MemLine+" ";
			MemLine+=tm;
		}
		m_Memlst.AddString(MemLine);
	}

	m_Memcmb.SetCurSel(0);
}

void CMemDlg::OnDump() 
{	// \eXV
	ShowMemory();
}

void CMemDlg::OnSelchangeAdrCmb() 
{	// R{{bNXIɕ\ꂽAhXֈړ
	if(m_Memcmb.GetCurSel()==0)m_Memlst.SetTopIndex(1);
	if(m_Memcmb.GetCurSel()==1)m_Memlst.SetTopIndex(0x401);
	if(m_Memcmb.GetCurSel()==2)m_Memlst.SetTopIndex(0x801);
	if(m_Memcmb.GetCurSel()==3)m_Memlst.SetTopIndex(0xa01);
	if(m_Memcmb.GetCurSel()==4)m_Memlst.SetTopIndex(0xc01);
	if(m_Memcmb.GetCurSel()==5)m_Memlst.SetTopIndex(0xe01);
	if(m_Memcmb.GetCurSel()==6)m_Memlst.SetTopIndex(0xfe1);
	if(m_Memcmb.GetCurSel()==7)m_Memlst.SetCurSel(0xffb);
	if(m_Memcmb.GetCurSel()==8)m_Memlst.SetCurSel(0xff9);
	if(m_Memcmb.GetCurSel()==9)m_Memlst.SetCurSel(0x1000);
}

void CMemDlg::OnGo() 
{	// ͂ꂽAhXփWv
	UpdateData(true);
	m_Memlst.SetCurSel(m_txtAdr/0x10+1);
	UpdateData(false);
}

void CMemDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	RECT	DlgSize;
	CDialog::GetClientRect(&DlgSize);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_MEMORY_LIST), 0, 3, 23, 
					DlgSize.right-DlgSize.left-6, DlgSize.bottom - DlgSize.top-26,
					SWP_NOACTIVATE|SWP_NOZORDER);
}
