# -*- coding: ascii -*-
#
#  downloader.py - Downloader for GBottler
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: downloader.py,v 1.9 2004/05/22 00:20:30 atzm Exp $
#

import os, sys, re, time, string
import urllib
from common import *

class Downloader:
	DLBOX   = 'download'
	LOGFILE = 'download.log'

	def __init__(self, verbose=False, dic={}, logging=True):
		self.verbose = verbose
		if dic:
			self.set_pattern(dic)

		self.logging = logging
		self.logdir  = open_bottlecase()
		self.logpath = os.path.join(self.logdir, self.LOGFILE)

	def set_pattern(self, dic):
		patterns = []
		for name in dic.keys():
			if not dic[name]:
				continue
			try:
				patterns.append(DL_SUFFIX_PATTERNS[name])
			except KeyError:
				pass

		patterns = string.join(patterns, '|')
		if patterns:
			self.file_patterns = '([^/]+\.(%s))' % patterns
			self.file_regex    = re.compile('^.+/%s$' % self.file_patterns)
			self.url_regex     = re.compile('((http|ftp|file)://.+?%s)' % self.file_patterns)
		else:
			self.file_patterns = ''
			self.file_regex    = re.compile('^$')
			self.url_regex     = re.compile('^$')

	def set_logging(self, logging):
		self.logging = logging

	def get_files(self, urls):
		if not urls:
			return
		dir = os.path.join(LIBDIR, self.DLBOX,
						   time.strftime("%Y%m%d", time.localtime(time.time())))
		try:
			dir = open_bottlecase(dir)
		except:
			sys.stderr.write("can't open download dir: %s" % dir)
			return

		for url in urls:
			try:
				localfile = self.file_regex.match(url).group(1)
			except:
				continue
			if not localfile:
				continue

			if os.path.exists(os.path.join(dir, localfile)):
				count = 0
				while True:
					if os.path.exists(os.path.join(dir, "%d.%s" % (count, localfile))):
						count += 1
						continue
					break
				localfile = "%d.%s" % (count, localfile)

			filename = ''
			try:
				filename, header = urllib.urlretrieve(url, os.path.join(dir, localfile))
			except:
				pass

			if self.logging:
				self.write_log(url, filename)

	def find_url_from_script(self, script):
		all = self.url_regex.findall(script)
		urls = []
		for item in all:
			urls.append(item[0])
		return urls

	def write_log(self, url, filename):
		now = time.strftime("%Y/%m/%d-%H:%M:%S", time.localtime(time.time()))
		if filename:
			write_str = '%s - From %s To %s\n' % (now, url, filename)
		else:
			write_str = '%s - From %s - Read Error.\n' % (now, url)

		try:
			file = open(self.logpath, "a")
		except IOError, (errno, message):
			sys.stderr.write("Error: cannot write %s\n" % self.logpath)
		else:
			file.write(write_str)
			file.close()

		#print write_str,
