#!/usr/bin/env python
# -*- coding: ascii -*-
#
#  ghost.py - The Ghost
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: ghost.py,v 1.2 2004/06/20 23:46:55 atzm Exp $
#

import gtk
import os
import sys
import string
import re
from types import *

from viewercommon import *

class Ghost:
	def __init__(self, svg_txt, svg_dir, debug=DEBUG):
		self.debug = debug

		self.svg_dir     = svg_dir
		self.surface_dic = {}

		self.ghostname   = None
		self.sakura      = None
		self.sakura2     = None
		self.unyu        = None
		self.user        = None
		self.surfacefile = None

		temporary   = None
		last_splite = 0

		if self.debug:
			print '-' * 20
		self.debugprint('Ghost def text', svg_txt)

		try:
			file = open(svg_txt)
		except IOError:
			self.debugprint('no such file', svg_txt)
		except TypeError:
			self.debugprint('undefined ghost', svg_txt)
		else:
			while True:
				line = file.readline()
				if not line:
					break

				line = string.replace(line, '\r\n', '')
				if not line:
					continue
				elif line[:4] == '/EOF':
					break
				elif line[0] == '/':
					continue

				elif line[:10] == 'ghostname=':
					self.ghostname = self.expand_quote(unicode(line[10:], 'sjis', 'replace'))
					self.debugprint('Ghost name', self.ghostname)

				elif line[:7] == 'sakura=':
					self.sakura = self.expand_quote(unicode(line[7:], 'sjis', 'replace'))
					self.debugprint('Sakura name', self.sakura)

				elif line[:8] == 'sakura2=':
					self.sakura2 = self.expand_quote(unicode(line[8:], 'sjis', 'replace'))
					self.debugprint('Sakura2 name', self.sakura2)

				elif line[:5] == 'unyu=':
					self.unyu = self.expand_quote(unicode(line[5:], 'sjis', 'replace'))
					self.debugprint('Unyu name', self.unyu)

				elif line[:5] == 'user=':
					self.user = self.expand_quote(unicode(line[5:], 'sjis', 'replace'))
					self.debugprint('User name', self.user)

				# get a svg_image_file
				elif line[:12] == 'surfacefile=':
					self.surfacefile = self.expand_quote(line[12:])
					self.debugprint('Ghost img file', self.surfacefile)

				# make a surface_id to splite_id dictionary
				elif line[:8] == 'surface=' or re.match('\d', line[:2]): # support for minus
					m = re.match('(.+?)/.+?', line)
					if m is not None:
						line = m.group(1)

					if not line:
						continue
					elif line[:8] == 'surface=':
						if line[8:]:
							temporary = line[8:].split(',')
					elif line:
						temporary = line.split(',')

					if not temporary:
						continue
					if not temporary[-1]:
						temporary = temporary[:-1]

					double = re.compile('(\d+)-(\d+)')
					for t in temporary:
						sur = t.split(':', 1)

## 						if sur[1] == '-1':
## 							# FIXME
## 							continue

						if sur[1] == '*':
							m = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in range(sur_ein, sur_zwei+1):
									self.surface_dic[each] = each
								last_splite = sur_zwei+1
							else:
								s = int(sur[0])
								self.surface_dic[s] = s
								last_splite = s+1

						elif sur[1] == '+':
							m = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in range(sur_ein, sur_zwei+1):
									self.surface_dic[each] = last_splite
									last_splite += 1
							else:
								self.surface_dic[int(sur[0])] = last_splite
								last_splite += 1

						else:
							#TODO if define[20-28:20] fix me
							s1 = int(sur[1])
							m  = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in range(sur_ein, sur_zwei+1):
									self.surface_dic[each] = s1
							else:
								s0 = int(sur[0])
								self.surface_dic[s0] = s1

							last_splite = s1 + 1

		#print self.surface_dic

	def set_debug(self, flag):
		self.debug = bool(flag)

	def debugprint(self, desc, text):
		if self.debug:
			print "%-14s: %s" % (desc, text)

	EXPAND_QUOTE_REGEX = re.compile('"(.+)"')
	def expand_quote(self, text):
		m = self.EXPAND_QUOTE_REGEX.match(text)
		if m is not None:
			text = m.group(1)
		return text	

	def __str__(self):
		if self.ghostname is None and type(self.sakura) is StringType:
			return self.sakura
		elif type(self.ghostname) is StringType:
			return self.ghostname
		return ''

	def get_ghostname(self):
		if self.ghostname is None:
			return self.sakura
		return self.ghostname

	def get_sakura(self):
		return self.sakura

	def get_unyu(self):
		return self.unyu

	def get_user(self):
		return self.user

	def set_svg_dir(self, path):
		if not os.path.exists(path):
			raise ValueError, 'no such directory: %s' % path
		if not os.path.isdir(path):
			raise ValueError, '%s is not directory' % path
		self.svg_dir = path

	def get_surface(self, surface_id, side):
		if not self.surface_dic:
			# if ghost definition text not found
			return None

		surface_id = int(surface_id)
		try:
			surface = self.surface_dic[surface_id]
			id = int(surface)
		except KeyError:
			if surface_id == -1:
				id = -1
			else:
				self.debugprint('No defined surface_id', surface_id)
				if side == SIDE_KERO:
					id = 10
				else:
					id = 0

		path = os.path.join(self.svg_dir, self.surfacefile)
		try:
			current_ghost_pixbuf = gtk.gdk.pixbuf_new_from_file(path)
		except:
			self.debugprint("can't open file", path)
			return None
## 			self.current_ghost_pixbuf = gtk.gdk.pixbuf_new_from_file('svg.png')
## 			a = 0
## 			b = 0
		else:
			if id == -1:
				area = gtk.gdk.pixbuf_new_from_xpm_data(XPM_VANISH)
			else:
				svg_width  = current_ghost_pixbuf.get_width()
				svg_height = current_ghost_pixbuf.get_height()

				x = svg_width / SIZE_SURFACE_H
				y = svg_height / SIZE_SURFACE_V
				a = id % x
				b = id / x

				area = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, gtk.TRUE, 8, 48, 64)
				current_ghost_pixbuf.copy_area(SIZE_SURFACE_H * a, SIZE_SURFACE_V * b,
											   SIZE_SURFACE_H, SIZE_SURFACE_V, area, 0, 0)

		return area
