# -*- coding: ascii -*-
#
#  logbook.py - Notebook for LogWindow
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logbook.py,v 1.7 2005/09/08 20:03:43 atzm Exp $
#

import gtk
from loglist import LogList
from common  import *
import config

class LogBook(gtk.Notebook):
	def __init__(self, label_text):
		self.current_label_text = label_text

		gtk.Notebook.__init__(self)
		self.set_scrollable(True)
		self.set_tab_pos(gtk.POS_TOP)
		self.show()

	def get_n_pages(self):
		# override for PyGTK 2.3 or earlier
		return len(self.get_children())

	def get_create_tab_position(self):
		pos = config.get('logwindow', 'new_page_placement', 'int')
		if pos == config.LOGWINDOW_PAGE_PLACEMENT_NEXT:
			return self.get_current_page() + 1
		elif pos == config.LOGWINDOW_PAGE_PLACEMENT_PREV:
			return self.get_current_page()
		elif pos == config.LOGWINDOW_PAGE_PLACEMENT_LEFTMOST:
			return 0
		elif pos == config.LOGWINDOW_PAGE_PLACEMENT_RIGHTMOST:
			return -1
		else:
			raise ValueError, 'chan to basho shitei site kure'

	def focus_active_loglist(self, widget=None, data=None):
		list = self.get_active_loglist()
		if not list:
			return
		list.grab_focus()

	def tab_changed(self, notebook, page, pagenum):
		tab  = notebook.get_nth_page(pagenum)
		list = tab.get_child()
		return list.tab_changed()

	def close_tab(self, widget, child):
		n = self.page_num(child)
		self.remove_page(n)
		return self.get_current_page()

	def create_tab(self, label_text, list=None):
		pos = self.get_create_tab_position()

		new_tab = LogList()

		sw = gtk.ScrolledWindow()
		sw.show()
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		sw.set_shadow_type(gtk.SHADOW_IN)
		sw.add(new_tab)

		hbox, eventbox, button = get_hbox_with_label_button(gtk.STOCK_CLOSE, label_text)
		hbox.show()

		self.insert_page(sw, hbox, pos)
		self.set_menu_label(sw, gtk.Label(label_text))

		if list:
			new_tab.set_local_log(list)

		if config.get('logwindow', 'focus_new_page', 'boolean'):
			self.set_current_page(pos)

		return button, eventbox, sw

	def cancel_play(self, widget=None, data=None):
		list = self.get_active_loglist()
		if list:
			return list.cancel_play()

	def cancel_play_page(self):
		list = self.get_active_loglist()
		if list:
			list.cancel_play_all()
			return list
		return None

	def cancel_play_all(self):
		for list in self.get_children():
			list = list.get_children()[0]
			list.cancel_play_all()

	def get_bottle_state(self, mid, list):
		if list is not None:
			return list.get_bottle_state(mid)

	def set_bottle_state(self, mid, list, stock=STATE_BOTTLE_NONE):
		if list is not None:
			list.set_bottle_state(mid, stock)

	def set_playing_bottle(self, mid, list):
		if list is not None:
			list.set_playing_bottle(mid)

	def clear_playing_bottle(self, list=None):
		if list is None:
			list = self.get_active_loglist()

		if list:
			list.clear_playing_bottle()

	def get_active_loglist(self):
		# getting showing LogList
		n = self.get_current_page()
		if n == -1:
			return
		tab  = self.get_nth_page(n)
		list = tab.get_child()
		return list

	def get_current_loglist(self):
		# getting LogList named `Current'
		tabs = self.get_children()
		for tab in tabs:
			hbox = self.get_tab_label(tab)
			eventbox, button = hbox.get_children()
			label = eventbox.get_children()[0]

			label_text = label.get_text()
			if label_text == self.current_label_text:
				return tab.get_child()

	def active_is(self, list):
		return (self.get_active_loglist() == list)

	def current_is(self, list):
		return (self.get_current_loglist() == list)

	def get_current_button_and_child(self):
		# getting close button and ScrolledWindow inside LogList named `Current'
		tabs = self.get_children()
		for i in xrange(len(tabs)):
			hbox = self.get_tab_label(tabs[i])
			eventbox, button = hbox.get_children()
			label = eventbox.get_children()[0]

			label_text = label.get_text()
			if label_text == self.current_label_text:
				return button, self.get_nth_page(i)

	def search(self, arrow, text, widget=None, data=None):
		list = self.get_active_loglist()
		if not list:
			return

		list.search(arrow, text, widget, data)

	def update(self, mid, channel, ghost, script, datetime):
		current_tab = self.get_current_loglist()

		button   = None
		eventbox = None
		sw       = None
		if not current_tab:
			button, eventbox, sw = self.create_tab(self.current_label_text)
			current_tab = sw.get_child()

		current_tab.update(mid, channel, ghost, script, datetime)
		return button, eventbox, sw
		# returns close button, EventBox, and ScrolledWindow if create LogList
		# named `Current' (if not exists LogList named `Current')
		# otherwise, returns [None, None, None]

	def log_votes(self, mid, type, num):
		for sw in self.get_children():
			loglist = sw.get_child()

			if loglist.has_mid(mid):
				loglist.log_votes(mid, type, num)

	def voting(self, widget, data, parent):
		list = self.get_active_loglist()
		if not list:
			return None, None
		return list.voting(widget, data, parent)

	def agreeing(self, widget, data, parent):
		list = self.get_active_loglist()
		if not list:
			return None, None
		return list.agreeing(widget, data, parent)

	def edit_copy(self, widget, data, target):
		list = self.get_active_loglist()
		if not list or not list.is_selected():
			return
		text = ''
		if target == LogList.LISTSTORE_ALL:
			text = list.get_text(list.selection(), LogList.LISTSTORE_DATETIME)
			text += ' ' + list.get_text(list.selection(), LogList.LISTSTORE_GHOST)
			text += ' ' + list.get_text(list.selection(), LogList.LISTSTORE_CHANNEL)
			text += ' ' + list.get_text(list.selection(), LogList.LISTSTORE_VOTES)
			text += ' ' + list.get_text(list.selection(), LogList.LISTSTORE_AGREES)
			text += ' ' + list.get_text(list.selection(), LogList.LISTSTORE_SCRIPT)
		else:
			text = list.get_text(list.selection(), target)
		if not text:
			return
		return text
