# -*- coding: ascii -*-
#
#  logfetchdialog.py - Log Download Dialog
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logfetchdialog.py,v 1.4 2005/08/29 20:28:58 atzm Exp $
#

import gtk
import os, sys, string
import time

class LogFetchDialog:
	def __init__(self, parent, channels=[]):
# === Past Box === #
		self.time_msg = [
			unicode(_('Minutes'), 'utf-8'),
			unicode(_('Hours'), 'utf-8'),
			unicode(_('Days'), 'utf-8'),
			]

		self.timeradio = gtk.RadioButton()
		self.pastlabel = gtk.Label(unicode(_('Past'), 'utf-8'))
		adj = gtk.Adjustment(1.0, 1.0, 100.0, 1.0, 5.0, 0.0)
		self.timespin  = gtk.SpinButton(adj, 0, 0)
		self.combo     = gtk.combo_box_new_text()
		for msg in self.time_msg:
			self.combo.append_text(msg)
		self.combo.set_active(0)
		self.pastbox = gtk.HBox()
		self.pastbox.set_border_width(5)
		self.pastbox.pack_start(self.timeradio)
		self.pastbox.pack_start(self.pastlabel)
		self.pastbox.pack_start(self.timespin)
		self.pastbox.pack_start(self.combo)

		self.timeradio.show()
		self.pastlabel.show()
		self.timespin.show()
		self.combo.show()
		self.pastbox.show()

# === Date Box === #
		[y, m, d] = string.split(time.strftime("%Y:%m:%d", time.localtime(time.time())), ':')
		self.dateradio = gtk.RadioButton(self.timeradio)
		self.dateradio.show()
##
		adj = gtk.Adjustment(1.0, 2001.0, float(y), 1.0, 5.0, 0.0)
		self.from_y_spin = gtk.SpinButton(adj, 0, 0)
		self.from_y_spin.set_value(float(y))
		self.from_y_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 12.0, 1.0, 5.0, 0.0)
		self.from_m_spin = gtk.SpinButton(adj, 0, 0)
		self.from_m_spin.set_value(float(m))
		self.from_m_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 31.0, 1.0, 5.0, 0.0)
		self.from_d_spin = gtk.SpinButton(adj, 0, 0)
		self.from_d_spin.set_value(float(d))
		self.from_d_spin.show()
##
		self.from_label = gtk.Label(' - ')
		self.from_label.show()
##
		adj = gtk.Adjustment(1.0, 2001.0, float(y), 1.0, 5.0, 0.0)
		self.to_y_spin = gtk.SpinButton(adj, 0, 0)
		self.to_y_spin.set_value(float(y))
		self.to_y_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 12.0, 1.0, 5.0, 0.0)
		self.to_m_spin = gtk.SpinButton(adj, 0, 0)
		self.to_m_spin.set_value(float(m))
		self.to_m_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 31.0, 1.0, 5.0, 0.0)
		self.to_d_spin = gtk.SpinButton(adj, 0, 0)
		self.to_d_spin.set_value(float(d))
		self.to_d_spin.show()
##
		self.datebox = gtk.HBox()
		self.datebox.set_border_width(5)
		self.datebox.show()

		self.datebox.pack_start(self.dateradio)
		self.datebox.pack_start(self.from_y_spin)
		self.datebox.pack_start(self.from_m_spin)
		self.datebox.pack_start(self.from_d_spin)
		self.datebox.pack_start(self.from_label)
		self.datebox.pack_start(self.to_y_spin)
		self.datebox.pack_start(self.to_m_spin)
		self.datebox.pack_start(self.to_d_spin)

# === Bring PastBox and DateBox together to Frame === #
		self.dayvbox = gtk.VBox()
		self.dayvbox.set_border_width(5)
		self.dayvbox.show()
		self.dayvbox.pack_start(self.pastbox)
		self.dayvbox.pack_start(self.datebox)

		self.dayframe = gtk.Frame(unicode(_('Date'), 'utf-8'))
		self.dayframe.show()
		self.dayframe.set_border_width(5)
		self.dayframe.add(self.dayvbox)

# === Start Filter Option === #
		self.channels = ['']
		for n in xrange(len(channels)):
			self.channels.append(channels[n]['name'])

		ch_label = gtk.Label(unicode(_('Channel'), 'utf-8'))
		ch_label.show()
		self.ch_combo = gtk.combo_box_new_text()
		self.ch_combo.show()
		for ch in self.channels:
			self.ch_combo.append_text(ch)
		if len(self.channels) == 1:
			self.ch_combo.set_sensitive(False)

		votelabel = gtk.Label(unicode(_('Votes'), 'utf-8'))
		votelabel.show()
		agreelabel = gtk.Label(unicode(_('Agrees'), 'utf-8'))
		agreelabel.show()
		overlabel1  = gtk.Label(unicode(_('Over'), 'utf-8'))
		overlabel1.show()
		overlabel2  = gtk.Label(unicode(_('Over'), 'utf-8'))
		overlabel2.show()

		adj = gtk.Adjustment(0.0, 0.0, 100.0, 1.0, 5.0, 0.0)
		self.votespin  = gtk.SpinButton(adj, 0, 0)
		self.votespin.show()
		adj = gtk.Adjustment(0.0, 0.0, 100.0, 1.0, 5.0, 0.0)
		self.agreespin = gtk.SpinButton(adj, 0, 0)
		self.agreespin.show()

		filter_table = gtk.Table(3, 3)
		filter_table.show()

		filter_table.attach(ch_label,      0, 1, 0, 1, gtk.FILL, gtk.FILL, 5, 5)
		filter_table.attach(self.ch_combo, 1, 2, 0, 1, gtk.FILL, gtk.FILL, 5, 5)

		filter_table.attach(votelabel,     0, 1, 1, 2, gtk.FILL, gtk.FILL, 5, 5)
		filter_table.attach(self.votespin, 1, 2, 1, 2, gtk.FILL, gtk.FILL, 5, 5)
		filter_table.attach(overlabel1,    2, 3, 1, 2, gtk.FILL, gtk.FILL, 5, 5)

		filter_table.attach(agreelabel,    0, 1, 2, 3, gtk.FILL, gtk.FILL, 5, 5)
		filter_table.attach(self.agreespin,1, 2, 2, 3, gtk.FILL, gtk.FILL, 5, 5)
		filter_table.attach(overlabel2,    2, 3, 2, 3, gtk.FILL, gtk.FILL, 5, 5)

		filterframe = gtk.Frame(unicode(_('Filter'), 'utf-8'))
		filterframe.show()
		filterframe.set_border_width(5)
		filterframe.add(filter_table)

# === Bringing all items together to window === #
		self.window = gtk.Dialog((unicode(_("Download Logs"))), parent,
								 gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
								 (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
								  gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
		self.window.set_border_width(5)
		self.window.connect("destroy", lambda x: x.destroy())
		self.window.vbox.pack_start(self.dayframe, True, True, 0)
		self.window.vbox.pack_start(filterframe, True, True, 0)
		self.window.show()

		self.clear()

		res = self.window.run()
		if res == gtk.RESPONSE_ACCEPT:
			self.fetch(y + m + d)
		self.window.destroy()

	def clear(self):
		self.request = None
		self.request_name = None

	def fetch(self, now):
		filter_req = self.gen_filter_request()
		if self.timeradio.get_active():
			value = value_min = self.timespin.get_value_as_int()
			combo_text = self.combo.get_active_text()
			if combo_text == self.time_msg[0]: # minutes
				pass
			elif combo_text == self.time_msg[1]: # hours
				value_min *= 60
			elif combo_text == self.time_msg[2]: # days
				value_min *= 60 * 24

			self.request = 'recent=%s&sort=time%s' % (value_min, filter_req)
			self.request_name = unicode(_('Past'), 'utf-8') + str(value) + combo_text

		elif self.dateradio.get_active():
			from_date = "%04d" % self.from_y_spin.get_value_as_int() + \
						"%02d" % self.from_m_spin.get_value_as_int() + \
						"%02d" % self.from_d_spin.get_value_as_int()
			to_date   = "%04d" % self.to_y_spin.get_value_as_int() + \
						"%02d" % self.to_m_spin.get_value_as_int() + \
						"%02d" % self.to_d_spin.get_value_as_int()
			dic = self.format(from_date, to_date, now)

			self.request = 'year_lo=%s&month_lo=%s&day_lo=%s&year_hi=%s&month_hi=%s&day_hi=%s&sort=time%s' % (
				dic['from'][0], dic['from'][1], dic['from'][2],
				dic['to'][0], dic['to'][1], dic['to'][2], filter_req)
			self.request_name = '%s-%s-%s - %s-%s-%s' % (
				dic['from'][0], dic['from'][1], dic['from'][2],
				dic['to'][0], dic['to'][1], dic['to'][2])
		else:
			raise ValueError, 'sonna wake aruka!'

	def gen_filter_request(self):
		minvote = self.votespin.get_value_as_int()
		if minvote > 0:
			minvote_req = '&minvote=%d'  % minvote
		else:
			minvote_req = ''

		minagree = self.agreespin.get_value_as_int()
		if minagree > 0:
			minagree_req = '&minagree=%d' % minagree
		else:
			minagree_req = ''

		channel = self.ch_combo.get_active_text()
		if channel is None: channel = ''
		channel = unicode(channel, 'utf-8').encode('sjis')
		channel = string.join(map(lambda c: '%%%0x' % ord(c), channel), '')
		if channel:
			channel_req = '&channel=%s' % channel
		else:
			channel_req = ''

		filter_req = '%s%s%s' % (minvote_req, minagree_req, channel_req)
		return filter_req

	def format(self, from_date, to_date, now):
		if int(from_date) > int(to_date):
			tmp       = from_date
			from_date = to_date
			to_date   = tmp
		if int(from_date) > int(now):
			from_date = now
		if int(to_date) > int(now):
			to_date = now

		dic = {}
		dic['from'] = [int(from_date[:4]),
					   int(from_date[4:6]),
					   int(from_date[6:])]
		dic['to'] = [int(to_date[:4]),
					 int(to_date[4:6]),
					 int(to_date[6:])]
		return dic
