#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  ghost.py - The Ghost
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: ghost.py,v 1.18 2005/09/27 05:59:49 atzm Exp $
#

__version__ = '$Revision: 1.18 $'
__author__ = '$Author: atzm $'

import gtk
import os
import sys
import string
import re
from types import *

from viewercommon import *

class Ghost:
	def __init__(self, svg_txt, svg_dir):
		self.svg_dir     = svg_dir
		self.surface_dic = {}
		self.reverse_dic = {}
		self.sequential_dic = {}

		self.sakura      = None
		self.unyu        = None
		self.user        = None
		self.craftman    = None
		self.url         = None
		self.hpname      = None
		self.surfacefile = None
		self.update      = None
		self.sakura2     = None
		self.ghostname   = None
		self.supported   = None
		self.sakura_action = None
		self.inform      = None

		self.ghost_pixbuf = None

		temporary   = None
		last_splite = 0

		# toriaezu uzai
		#if __debug__:
		#	print >> sys.stderr, '%s' % ('-' * 20)
		self.debugprint('Ghost def text', svg_txt)

		try:
			file = open(svg_txt)
		except IOError:
			self.debugprint('no such file', svg_txt)
		except TypeError:
			self.debugprint('undefined ghost', svg_txt)
		else:
			while True:
				line = file.readline()
				if not line:
					break

				#line = string.replace(line, '\r\n', '')
				line = string.rstrip(line)
				if not line:
					continue
				elif line[:4] == '/EOF':
					break
				elif line[0] == '/':
					continue

				elif line[:7] == 'sakura=':
					self.sakura = expand_quote(unicode(line[7:], 'sjis', 'replace'))
					self.debugprint('Sakura name', self.sakura)

				elif line[:5] == 'unyu=':
					self.unyu = expand_quote(unicode(line[5:], 'sjis', 'replace'))
					self.debugprint('Unyu name', self.unyu)

				elif line[:5] == 'user=':
					self.user = expand_quote(unicode(line[5:], 'sjis', 'replace'))
					self.debugprint('User name', self.user)

				elif line[:9] == 'craftman=':
					self.craftman = expand_quote(unicode(line[9:], 'sjis', 'replace'))
					self.debugprint('Craftman', self.craftman)

				elif line[:4] == 'url=':
					self.url = expand_quote(unicode(line[4:], 'sjis', 'replace'))
					self.debugprint('URL', self.url)

				elif line[:7] == 'hpname=':
					self.hpname = expand_quote(unicode(line[7:], 'sjis', 'replace'))
					self.debugprint('HP name', self.hpname)

				elif line[:7] == 'update=':
					self.update = expand_quote(unicode(line[7:], 'sjis', 'replace'))
					self.debugprint('update', self.update)

				elif line[:8] == 'sakura2=':
					self.sakura2 = expand_quote(unicode(line[8:], 'sjis', 'replace'))
					self.debugprint('Sakura2 name', self.sakura2)

				elif line[:10] == 'ghostname=':
					self.ghostname = expand_quote(unicode(line[10:], 'sjis', 'replace'))
					self.debugprint('Ghost name', self.ghostname)

				elif line[:10] == 'supported=':
					self.supported = expand_quote(unicode(line[10:], 'sjis', 'replace'))
					self.debugprint('Supported', self.supported)

				elif line[:14] == 'sakura-action=':
					self.sakura_action = expand_quote(unicode(line[14:], 'sjis', 'replace'))
					self.debugprint('Sakura Action', self.sakura_action)

				elif line[:7] == 'inform=':
					self.inform = expand_quote(unicode(line[7:], 'sjis', 'replace'))
					self.debugprint('Information', self.inform)

				# get a svg_image_file
				elif line[:12] == 'surfacefile=':
					self.surfacefile = expand_quote(line[12:])
					self.debugprint('Ghost img file', self.surfacefile)

				# make a surface_id to splite_id dictionary
				elif line[:8] == 'surface=' or re.match('\d', line[:2]): # support for minus
					m = re.match('(.+?)/.+?', line)
					if m is not None:
						line = m.group(1)

					if not line:
						continue
					elif line[:8] == 'surface=':
						if line[8:]:
							temporary = line[8:].split(',')
					elif line:
						temporary = line.split(',')

					if not temporary:
						continue
					if not temporary[-1]:
						temporary = temporary[:-1]

					double = re.compile('(\d+)-(\d+)')
					for t in temporary:
						sur = t.split(':', 1)

## 						if sur[1] == '-1':
## 							# FIXME
## 							continue

						# FIXME
						# example '15＝欠番'
						try:
							if sur[1] == None:
								continue
						except IndexError:
							continue

						if sur[1] == '*':
							m = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in xrange(sur_ein, sur_zwei+1):
									self.surface_dic[each] = each
								last_splite = sur_zwei+1
							else:
								s = int(sur[0])
								self.surface_dic[s] = s
								last_splite = s+1

						elif sur[1] == '+':
							m = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in xrange(sur_ein, sur_zwei+1):
									self.surface_dic[each] = last_splite
									last_splite += 1
							else:
								self.surface_dic[int(sur[0])] = last_splite
								last_splite += 1

						else:
							#TODO if define[20-28:20] fix me
							s1 = int(sur[1])
							m  = double.match(sur[0])
							if m:
								sur_ein  = int(m.group(1))
								sur_zwei = int(m.group(2))
								for each in xrange(sur_ein, sur_zwei+1):
									self.surface_dic[each] = s1
							else:
								s0 = int(sur[0])
								self.surface_dic[s0] = s1

							last_splite = s1 + 1

				# get a sequential images
				elif line[:11] == 'sequential=':
					### NOTICE!!
					### self.sequential_dic type of STRING
					# delete "\[" and "\]"
					seque = re.match('\[(.*)\]', line[11:]).group(1)
					sequential_index, sequential_group = re.split('=', seque, 1)
					# we need make and set dictionary that is {'4':'100>>101>>102>>*'} for example
					#print 'hoge', sequential_index, sequential_group
					self.sequential_dic[int(sequential_index)] = sequential_group

					self.debugprint('sequential splite', self.surfacefile)

		#print self.surface_dic
		#print self.sequential_dic


	def load_image(self):
		image_path = os.path.join(self.svg_dir, self.surfacefile)
		try:
			self.ghost_pixbuf = gtk.gdk.pixbuf_new_from_file(image_path)
		except:
			self.debugprint("can't open file", image_path)
			self.ghost_pixbuf = None

	def debugprint(self, desc, text):
		pass
		# toriaezu uzai
		#if __debug__:
		#	print >> sys.stderr, '%-15s: %s' % (desc, text.encode('euc-jp', 'ignore'))

	def __str__(self):
		if self.sakura:
			return self.sakura
		elif self.ghostname:
			return self.ghostname
		elif self.sakura2:
			return self.sakura2
		return 'Ghost: not defined Name'

	def get_sakura(self):
		return self.sakura

	def get_unyu(self):
		return self.unyu

	def get_user(self):
		return self.user

	def get_craftman(self):
		return self.craftman

	def get_url(self):
		return self.url

	def get_hpname(self):
		return self.hpname

	def get_surfacefile(self):
		return self.surfacefile

	def get_update(self):
		return self.update

	def get_sakura2(self):
		return self.sakura2

	def get_ghostname(self):
		if self.ghostname is None:
			return self.sakura
		return self.ghostname

	def get_supported(self):
		return self.supported

	def get_sakura_action(self):
		return self.sakura_action

	def get_inform(self):
		return self.inform

	def set_svg_dir(self, path):
		if not os.path.exists(path):
			raise ValueError, 'no such directory: %s' % path
		if not os.path.isdir(path):
			raise ValueError, '%s is not directory' % path
		self.svg_dir = path

	def get_surface(self, surface_id, side=SIDE_SAKURA):
		if not self.surface_dic:
			# if ghost definition text not found
			return None

		surface_id = int(surface_id)
		try:
			surface = self.surface_dic[surface_id]
			id = int(surface)
		except KeyError:
			if surface_id == -1:
				id = -1
			else:
				self.debugprint('No defined surface_id', surface_id)
				if side == SIDE_KERO:
					id = 10
				else:
					id = 0

		if self.ghost_pixbuf is None: # try to load ghost image file if not cached
			self.load_image()
			if self.ghost_pixbuf is None: # return None if loading failed
				return None

		if id == -1:
			area = gtk.gdk.pixbuf_new_from_xpm_data(XPM_VANISH)
		else:
			svg_width  = self.ghost_pixbuf.get_width()
			svg_height = self.ghost_pixbuf.get_height()

			x = svg_width / SIZE_SURFACE_H
			y = svg_height / SIZE_SURFACE_V
			a = id % x
			b = id / x

			area = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, 48, 64)
			self.ghost_pixbuf.copy_area(SIZE_SURFACE_H * a, SIZE_SURFACE_V * b,
										SIZE_SURFACE_H, SIZE_SURFACE_V, area, 0, 0)

		return area

	def set_reverse_dic(self):
		for i in self.surface_dic.keys():
			if not self.reverse_dic.has_key(i):
				self.reverse_dic[self.surface_dic[i]] = i

	def check_ss(self, surface_id):
		if not self.sequential_dic or not surface_id:
			return False
		try:
			id = int(surface_id)
			splite_id = self.surface_dic[id]
		except KeyError:
			return False
		return self.sequential_dic.has_key(splite_id)

	def get_surface_s(self, splite_id, side=SIDE_SAKURA):	## for Sequential Splite
		id = int(splite_id)

		if self.ghost_pixbuf is None: # try to load ghost image file if not cached
			self.load_image()
			if self.ghost_pixbuf is None: # return None if loading failed
				return None

		if id == -1:
			area = gtk.gdk.pixbuf_new_from_xpm_data(XPM_VANISH)
		else:
			svg_width  = self.ghost_pixbuf.get_width()
			svg_height = self.ghost_pixbuf.get_height()

			x = svg_width / SIZE_SURFACE_H
			y = svg_height / SIZE_SURFACE_V
			a = id % x
			b = id / x

			area = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, 48, 64)
			self.ghost_pixbuf.copy_area(SIZE_SURFACE_H * a, SIZE_SURFACE_V * b,
										SIZE_SURFACE_H, SIZE_SURFACE_V, area, 0, 0)
		return area

	def get_ss_group(self, surface_id):
		id = int(surface_id)
		sequential_def = self.sequential_dic[self.surface_dic[id]]
		splite = re.split('[>]', sequential_def)
		return splite
