# -*- coding: ascii -*-
#
#  logfetch.py - Log Downloader
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logfetch.py,v 1.3 2004/05/21 23:18:19 atzm Exp $
#

import gtk
import os, sys, string
import time
import mimetools, socket, httplib

from common import HOST, AGENT_NAME

class LogFetchDialog:
	def __init__(self, parent):
# === Past Box === #
		self.time_msg = [
			unicode(_('Minutes'), 'utf-8'),
			unicode(_('Hours'), 'utf-8'),
			unicode(_('Days'), 'utf-8'),
			]

		self.timeradio = gtk.RadioButton()
		self.pastlabel = gtk.Label(unicode(_('Past'), 'utf-8'))
		adj = gtk.Adjustment(1.0, 1.0, 100.0, 1.0, 5.0, 0.0)
		self.timespin  = gtk.SpinButton(adj, 0, 0)
		self.combo     = gtk.Combo()
		self.combo.set_popdown_strings(self.time_msg)
		self.pastbox = gtk.HBox()
		self.pastbox.set_border_width(5)
		self.pastbox.pack_start(self.timeradio)
		self.pastbox.pack_start(self.pastlabel)
		self.pastbox.pack_start(self.timespin)
		self.pastbox.pack_start(self.combo)

		self.timeradio.show()
		self.pastlabel.show()
		self.timespin.show()
		self.combo.show()
		self.pastbox.show()

# === Date Box === #
		[y, m, d] = string.split(time.strftime("%Y:%m:%d", time.localtime(time.time())), ':')
		self.dateradio = gtk.RadioButton(self.timeradio)
		self.dateradio.show()
##
		adj = gtk.Adjustment(1.0, 2001.0, float(y), 1.0, 5.0, 0.0)
		self.from_y_spin = gtk.SpinButton(adj, 0, 0)
		self.from_y_spin.set_value(float(y))
		self.from_y_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 12.0, 1.0, 5.0, 0.0)
		self.from_m_spin = gtk.SpinButton(adj, 0, 0)
		self.from_m_spin.set_value(float(m))
		self.from_m_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 31.0, 1.0, 5.0, 0.0)
		self.from_d_spin = gtk.SpinButton(adj, 0, 0)
		self.from_d_spin.set_value(float(d))
		self.from_d_spin.show()
##
		self.from_label = gtk.Label(' - ')
		self.from_label.show()
##
		adj = gtk.Adjustment(1.0, 2001.0, float(y), 1.0, 5.0, 0.0)
		self.to_y_spin = gtk.SpinButton(adj, 0, 0)
		self.to_y_spin.set_value(float(y))
		self.to_y_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 12.0, 1.0, 5.0, 0.0)
		self.to_m_spin = gtk.SpinButton(adj, 0, 0)
		self.to_m_spin.set_value(float(m))
		self.to_m_spin.show()

		adj = gtk.Adjustment(1.0, 1.0, 31.0, 1.0, 5.0, 0.0)
		self.to_d_spin = gtk.SpinButton(adj, 0, 0)
		self.to_d_spin.set_value(float(d))
		self.to_d_spin.show()
##
		self.datebox = gtk.HBox()
		self.datebox.set_border_width(5)
		self.datebox.show()

		self.datebox.pack_start(self.dateradio)
		self.datebox.pack_start(self.from_y_spin)
		self.datebox.pack_start(self.from_m_spin)
		self.datebox.pack_start(self.from_d_spin)
		self.datebox.pack_start(self.from_label)
		self.datebox.pack_start(self.to_y_spin)
		self.datebox.pack_start(self.to_m_spin)
		self.datebox.pack_start(self.to_d_spin)

# === Bring PastBox and DateBox together to Frame === #
		self.dayvbox = gtk.VBox()
		self.dayvbox.set_border_width(5)
		self.dayvbox.show()
		self.dayvbox.pack_start(self.pastbox)
		self.dayvbox.pack_start(self.datebox)

		self.dayframe = gtk.Frame(unicode(_('Date'), 'utf-8'))
		self.dayframe.show()
		self.dayframe.set_border_width(5)
		self.dayframe.add(self.dayvbox)

		self.window = gtk.Dialog((unicode(_("Download Logs"))), parent,
								 gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
								 (gtk.STOCK_OK, gtk.RESPONSE_ACCEPT,
								  gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT))
		self.window.set_border_width(5)
		self.window.connect("destroy", lambda x: x.destroy())
		self.window.vbox.pack_start(self.dayframe, gtk.TRUE, gtk.TRUE, 0)
		self.window.show()

		self.clear()

		res = self.window.run()
		if res == gtk.RESPONSE_ACCEPT:
			self.fetch(y + m + d)
		self.window.destroy()

	def clear(self):
		self.request = None
		self.request_name = None

	def fetch(self, now):
		if self.timeradio.get_active():
			value = value_min = self.timespin.get_value_as_int()
			combo_text = self.combo.entry.get_text()
			if combo_text == self.time_msg[0]: # minutes
				pass
			elif combo_text == self.time_msg[1]: # hours
				value_min *= 60
			elif combo_text == self.time_msg[2]: # days
				value_min *= 60 * 24

			self.request = 'recent=%s&sort=time' % value_min
			self.request_name = unicode(_('Past'), 'utf-8') + str(value) + combo_text

		elif self.dateradio.get_active():
			from_date = "%04d" % self.from_y_spin.get_value_as_int() + \
						"%02d" % self.from_m_spin.get_value_as_int() + \
						"%02d" % self.from_d_spin.get_value_as_int()
			to_date   = "%04d" % self.to_y_spin.get_value_as_int() + \
						"%02d" % self.to_m_spin.get_value_as_int() + \
						"%02d" % self.to_d_spin.get_value_as_int()
			dic = self.format(from_date, to_date, now)

			self.request = 'year_lo=%s&month_lo=%s&day_lo=%s&year_hi=%s&month_hi=%s&day_hi=%s&sort=time' % (
				dic['from'][0], dic['from'][1], dic['from'][2],
				dic['to'][0], dic['to'][1], dic['to'][2])
			self.request_name = '%s-%s-%s - %s-%s-%s' % (
				dic['from'][0], dic['from'][1], dic['from'][2],
				dic['to'][0], dic['to'][1], dic['to'][2])
		else:
			raise ValueError, 'sonna wake aruka!'

	def format(self, from_date, to_date, now):
		if int(from_date) > int(to_date):
			tmp       = from_date
			from_date = to_date
			to_date   = tmp
		if int(from_date) > int(now):
			from_date = now
		if int(to_date) > int(now):
			to_date = now

		dic = {}
		dic['from'] = [int(from_date[:4]),
					   int(from_date[4:6]),
					   int(from_date[6:])]
		dic['to'] = [int(to_date[:4]),
					 int(to_date[4:6]),
					 int(to_date[6:])]
		return dic

class LogFetcher:
	def __init__(self):
		pass

	def fetch(self, request, action='/fetchlog.cgi'):
		try:
			http = httplib.HTTP(HOST)

			http.putrequest("POST", action)
			http.putheader("Host", HOST)
			http.putheader("From", AGENT_NAME)
			http.putheader("Accept", "text/html, text/plain")
			http.putheader("Content-type", "application/x-www-form-urlencoded")
			http.putheader("Content-length", str(len(request)))
			http.endheaders()

			http.send(request)
		except socket.error, e:
			print e
			return

		try:
			code, message, headers = http.getreply()
		except socket.error, e:
			print e
			return

		file = http.getfile()
		headers = mimetools.Message(file, 0)

		if code != 200:
			print 'error: not code 200'
			print code, message, headers
			return
		if not headers.has_key("Result") or headers["Result"] != "OK":
			print 'error: no Result'
			print code, message, headers
			return
		if not headers.has_key("Limit"):
			print 'error: no Limit header'
			print code, message, headers
			return

		lines = []
		while True:
			line = file.readline()
			if not line:
				break
			if line[-2:] == '\r\n':
				line = line[:-2]
			if not line:
				continue
			line = unicode(line, 'sjis', 'replace')
			[date, mid, channel, ghost, users, votes, agrees, script] = string.split(line, '\t', 7)
			lines.append([date, mid, votes, agrees, channel, ghost, script])

		return lines

if __name__ == '__main__':
	import gettext
	gettext.install('gbottler')
	w = gtk.Window()
	w.show()
	l = LogFetchDialog(w)
