# -*- coding: ascii -*-
#
#  prefs.py - Preference manipulator for GBottler
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: prefs.py,v 1.42 2004/05/28 16:13:23 atzm Exp $
#

import os, sys, re, string
import gtk
from common import *

class PreferenceDialog:
	def __init__(self, app, prefmanager, luid_info=None):
		self.prefs = {}
		self.app = app
		self.prefmanager = prefmanager
		if luid_info:
			self.luid_info = luid_info

# === Create General Tab === #
		self.prefs['auto_open_log'] = gtk.CheckButton(unicode(_("Open log window when startup")))
		self.prefs['auto_connect'] = gtk.CheckButton(unicode(_("Connect bottle server when startup")))
		self.prefs['auto_join'] = gtk.CheckButton(unicode(_("Join all channels when connect")))
		self.prefs['auto_clear']  = gtk.CheckButton(unicode(_("Clear editor after send")))

		self.genbox = gtk.VBox()
		self.genbox.show()
		for name in ['auto_open_log', 'auto_connect', 'auto_join', 'auto_clear']:
			self.prefs[name].set_border_width(5)
			self.prefs[name].show()
			self.genbox.pack_start(self.prefs[name], gtk.FALSE, gtk.FALSE, 0)

		self.genframe = gtk.Frame(unicode(_("General")))
		self.genframe.show()
		self.genframe.set_border_width(5)
		self.genframe.add(self.genbox)

# === Create SSTP Frame === #
		self.sendbox = gtk.VBox()
		self.sendbox.show()

		self.prefs['forward'] = gtk.CheckButton(unicode(_("Forward")))
		self.prefs['accept_all'] = gtk.RadioButton(None, unicode(_("Accept All")))
		self.prefs['forward_listed'] = gtk.RadioButton(self.prefs['accept_all'],
													   unicode(_("Forward only listed Ghost")))
		for name in ['forward', 'accept_all', 'forward_listed']:
			self.prefs[name].set_border_width(5)
			self.prefs[name].show()
			self.sendbox.pack_start(self.prefs[name], gtk.FALSE, gtk.FALSE, 0)
		self.prefs['forward'].connect('toggled', self.forward_toggled)

		self.sendframe = gtk.Frame(unicode(_("SSTP server")))
		self.sendframe.show()
		self.sendframe.set_border_width(5)
		self.sendframe.add(self.sendbox)

# === Create Initial Script Frame === #
		self.prefs['initialscript'] = gtk.Entry()
		self.prefs['initialscript'].show()

		iniscl = gtk.Label(unicode(_('A first | is cursor position'), 'utf-8'))
		iniscl.show()

		self.iniscbox = gtk.VBox()
		self.iniscbox.show()
		self.iniscbox.pack_start(self.prefs['initialscript'], gtk.FALSE, gtk.FALSE, 5)
		self.iniscbox.pack_start(iniscl, gtk.FALSE, gtk.FALSE, 5)

		self.iniscframe = gtk.Frame(unicode(_("Initial script")))
		self.iniscframe.show()
		self.iniscframe.set_border_width(5)
		self.iniscframe.add(self.iniscbox)

# === Bring General and SSTP Frames together to General Tab === #
		self.gentab = gtk.VBox()
		self.gentab.show()
		self.gentab.pack_start(self.genframe, gtk.FALSE, gtk.FALSE, 0)
		self.gentab.pack_start(self.sendframe, gtk.FALSE, gtk.FALSE, 0)
		self.gentab.pack_start(self.iniscframe, gtk.FALSE, gtk.FALSE, 0)

# === Create Logging Frame == #
		self.prefs['logging'] = gtk.CheckButton(unicode(_("Save `Current' log as XML when disconnect"), 'utf-8'))
		self.prefs['logging'].set_border_width(2)
		self.prefs['logging'].show()
		self.prefs['logging'].connect('toggled', self.logging_toggled)

		self.prefs['logging_current_tab_closed'] = gtk.CheckButton(unicode(_("Save log as XML when close `Current' tab"), 'utf-8'))
		self.prefs['logging_current_tab_closed'].set_border_width(2)
		self.prefs['logging_current_tab_closed'].show()
		self.prefs['logging_current_tab_closed'].connect('toggled', self.logging_toggled)

		self.prefs['logging_path'] = gtk.Entry()
		self.prefs['logging_path'].show()
		self.prefs['logging_path'].set_sensitive(gtk.FALSE)
		ll = gtk.Label(unicode(_('Can use time format e.g. %H, %M, %S and etc.'), 'utf-8'))
		ll.show()

		lbox = gtk.VBox()
		lbox.show()
		lbox.pack_start(self.prefs['logging_path'], gtk.FALSE, gtk.FALSE, 3)
		lbox.pack_start(ll, gtk.FALSE, gtk.FALSE, 3)

		lframe = gtk.Frame(unicode(_('Filename'), 'utf-8'))
		lframe.show()
		lframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
		lframe.set_border_width(5)
		lframe.add(lbox)

		self.logbox1 = gtk.VBox()
		self.logbox1.show()
		self.logbox1.pack_start(self.prefs['logging'], gtk.FALSE, gtk.FALSE, 2)
		self.logbox1.pack_start(self.prefs['logging_current_tab_closed'], gtk.FALSE, gtk.FALSE, 2)
		self.logbox1.pack_start(lframe, gtk.FALSE, gtk.FALSE, 2)

		self.logframe1 = gtk.Frame(unicode(_("Logs")))
		self.logframe1.show()
		self.logframe1.set_border_width(5)
		self.logframe1.add(self.logbox1)

# === Create LogTab behavior Frame == #
		self.logbox2 = gtk.VBox()
		self.logbox2.show()

		self.prefs['logtabfocus']  = gtk.CheckButton(unicode(_("Focus new page automatically"), 'utf-8'))
		self.prefs['logtabfocus'].set_border_width(2)
		self.prefs['logtabfocus'].show()
		self.logbox2.pack_start(self.prefs['logtabfocus'], gtk.FALSE, gtk.FALSE, 2)

		pagepos_table = gtk.Table(2, 2)
		pagepos_table.show()
		prev = None
		list = [[
			[POS_NEXT,  "To current tab's next"],
			[POS_PREV,  "To current tab's previous"]
			],
				[
			[POS_END,   'As end tab'],
			[POS_FIRST, 'As first tab']
			]]
		for i in range(len(list)):
			for j in range(len(list[i])):
				pref = list[i][j][0]
				description = list[i][j][1]

				self.prefs[pref]  = gtk.RadioButton(prev, unicode(_(description)))
				self.prefs[pref].set_border_width(2)
				self.prefs[pref].show()
				pagepos_table.attach(self.prefs[pref], j, j+1, i, i+1, gtk.FILL, gtk.FILL, 3, 3)
				prev = self.prefs[pref]
		self.logbox2.pack_start(pagepos_table, gtk.FALSE, gtk.FALSE, 2)

		self.logframe2 = gtk.Frame(unicode(_("When open new page...")))
		self.logframe2.show()
		self.logframe2.set_border_width(5)
		self.logframe2.add(self.logbox2)

# === Create LogTab position Frame == #
		tabpos_table = gtk.Table(4, 1)
		tabpos_table.show()
		prev = None
		list = [['Top', 'Bottom', 'Left', 'Right']]
		for i in range(len(list)):
			for j in range(len(list[i])):
				label = list[i][j]

				pref_name = None
				if label == 'Right':
					pref_name = "LOGTABPOS_%s" % gtk.POS_RIGHT
				elif label == 'Left':
					pref_name = "LOGTABPOS_%s" % gtk.POS_LEFT
				elif label == 'Bottom':
					pref_name = "LOGTABPOS_%s" % gtk.POS_BOTTOM
				else:
					pref_name = "LOGTABPOS_%s" % gtk.POS_TOP

				self.prefs[pref_name] = gtk.RadioButton(prev, unicode(_(label)))
				self.prefs[pref_name].show()
				tabpos_table.attach(self.prefs[pref_name], j, j+1, i, i+1, gtk.FILL, gtk.FILL, 3, 3)
				prev = self.prefs[pref_name]

		self.logframe3 = gtk.Frame(unicode(_("Tab position")))
		self.logframe3.show()
		self.logframe3.set_border_width(5)
		self.logframe3.add(tabpos_table)

# === Create Browser Frame == #
		self.prefs['browser'] = gtk.Entry()
		self.prefs['browser'].show()

		self.brs_label = gtk.Label(unicode(_('Replace %s to URL'), 'utf-8'))
		self.brs_label.show()

		self.logbox4 = gtk.VBox()
		self.logbox4.show()
		self.logbox4.pack_start(self.prefs['browser'], gtk.FALSE, gtk.FALSE, 5)
		self.logbox4.pack_start(self.brs_label, gtk.TRUE, gtk.TRUE, 3)

		self.logframe4 = gtk.Frame(unicode(_("Command to run browser")))
		self.logframe4.show()
		self.logframe4.set_border_width(5)
		self.logframe4.add(self.logbox4)

# === Bring Browser, Logging, LogTab behavior, LogTab position frames together to Log Tab === #
		self.logtab = gtk.VBox()
		self.logtab.show()
		self.logtab.pack_start(self.logframe1, gtk.FALSE, gtk.FALSE, 0)
		self.logtab.pack_start(self.logframe2, gtk.FALSE, gtk.FALSE, 0)
		self.logtab.pack_start(self.logframe3, gtk.FALSE, gtk.FALSE, 0)
		self.logtab.pack_start(self.logframe4, gtk.FALSE, gtk.FALSE, 0)

# === Create Download Frame === #
		self.prefs['autodl'] = gtk.CheckButton(unicode(_("Auto download when receive script contained URL")))
		self.prefs['autodl'].set_border_width(5)
		self.prefs['autodl'].show()
		self.prefs['autodl'].connect('toggled', self.download_toggled)

		self.prefs['download_log'] = gtk.CheckButton(unicode(_("Logging history")))
		self.prefs['download_log'].set_border_width(5)
		self.prefs['download_log'].show()
		self.prefs['download_log'].set_sensitive(gtk.FALSE)

		# make table
		rows = 4
		ex_table = gtk.Table(7, rows)
		ex_table.show()

		keys = DL_SUFFIX_PATTERNS.keys()
		keys.sort()
		length = len(keys) / rows + 1
		list = [keys[length*i:length*(i+1)] for i in range(rows)]

		for i in range(len(list)):
			for j in range(len(list[i])):
				self.prefs[list[i][j]] = gtk.CheckButton(list[i][j])
				self.prefs[list[i][j]].show()
				self.prefs[list[i][j]].set_sensitive(gtk.FALSE)
				ex_table.attach(self.prefs[list[i][j]], j, j+1, i, i+1, gtk.FILL, gtk.FILL, 3, 3)

		ex_frame = gtk.Frame(unicode(_('Supported file types'), 'utf-8'))
		ex_frame.show()
		ex_frame.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
		ex_frame.set_border_width(5)
		ex_frame.add(ex_table)

		self.dlbox = gtk.VBox()
		self.dlbox.show()
		self.dlbox.pack_start(self.prefs['autodl'], gtk.FALSE, gtk.FALSE, 0)
		self.dlbox.pack_start(self.prefs['download_log'], gtk.FALSE, gtk.FALSE, 0)
		self.dlbox.pack_start(ex_frame, gtk.FALSE, gtk.FALSE, 0)

		self.dlframe = gtk.Frame(unicode(_("Download"), 'utf-8'))
		self.dlframe.show()
		self.dlframe.set_border_width(5)
		self.dlframe.add(self.dlbox)

# === Create Color Tab === #
		self.colortable = gtk.Table(6, 2)
		self.colortable.show()

		list = ['script', 'sakura', 'kero', 'sync', 'error', 'URL']
		for i in range(len(list)):
			entry = gtk.Entry()
			entry.show()
			label = gtk.Label(unicode(_(list[i]), 'utf-8'))
			label.show()
			self.prefs[list[i]] = entry
			self.colortable.attach(label, 0, 1, i, i+1, gtk.FILL, gtk.FILL, 3, 3)
			self.colortable.attach(entry, 1, 2, i, i+1, gtk.FILL, gtk.FILL, 3, 3)

		self.colorbox = gtk.VBox()
		self.colorbox.show()
		self.colorbox.pack_start(self.colortable, gtk.FALSE, gtk.FALSE, 0)

		self.colorframe = gtk.Frame(unicode(_("Color settings")))
		self.colorframe.show()
		self.colorframe.set_border_width(5)
		self.colorframe.add(self.colorbox)

# === Create LUID Tab === #
		if luid_info:
			luid_data = self.luid_info.get_all()

			if luid_data['info']:
				self.luidinfolist = gtk.CList(len(luid_data['info'][0]), luid_data['info'][0])
			else:
				self.luidinfolist = gtk.CList()
			self.luidinfolist.column_titles_passive()
			self.luidinfolist.show()
			self.luidinfolist.set_column_auto_resize(1, gtk.TRUE)
			self.luidinfolist.set_shadow_type(gtk.SHADOW_IN)
			self.luidinfolist.set_selection_mode(gtk.SELECTION_BROWSE)
			self.luidinfolist.set_reorderable(gtk.TRUE)
			self.luidinfolist.set_column_width(0, 100)
			self.luidinfolist.set_column_auto_resize(1, gtk.TRUE)

			self.luidinfolist.freeze()
			self.luidinfolist.clear()
			for line in luid_data['info'][1:]:
				self.luidinfolist.append(tuple(line))
			self.luidinfolist.sort()
			self.luidinfolist.columns_autosize()
			self.luidinfolist.thaw()

			self.luidinfosw = gtk.ScrolledWindow()
			self.luidinfosw.show()
			self.luidinfosw.set_size_request(300, 80)
			self.luidinfosw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
			self.luidinfosw.add(self.luidinfolist)

			self.luidinfof = gtk.Frame(unicode(_('General')))
			self.luidinfof.set_border_width(5)
			self.luidinfof.show()
			self.luidinfof.add(self.luidinfosw)

			if luid_data['table']:
				self.luidlist = gtk.CList(len(luid_data['table'][0]), luid_data['table'][0])
			else:
				self.luidlist = gtk.CList()
			self.luidlist.column_titles_passive()
			self.luidlist.show()
			self.luidlist.set_column_auto_resize(1, gtk.TRUE)
			self.luidlist.set_shadow_type(gtk.SHADOW_IN)
			self.luidlist.set_selection_mode(gtk.SELECTION_BROWSE)
			self.luidlist.set_reorderable(gtk.TRUE)
			self.luidlist.set_column_width(0, 100)
			self.luidlist.set_column_auto_resize(1, gtk.TRUE)

			self.luidlist.freeze()
			self.luidlist.clear()
			for line in luid_data['table'][1:]:
				self.luidlist.append(tuple(line))
			self.luidlist.sort()
			self.luidlist.columns_autosize()
			self.luidlist.thaw()

			self.luidsw = gtk.ScrolledWindow()
			self.luidsw.show()
			self.luidsw.set_size_request(300, 100)
			self.luidsw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
			self.luidsw.add(self.luidlist)

			self.luidf = gtk.Frame(unicode(_('Details')))
			self.luidf.set_border_width(5)
			self.luidf.show()
			self.luidf.add(self.luidsw)

			self.luidbutton = gtk.Button(unicode(_('Update')))
			self.luidbutton.show()
			self.luidbutton.connect('clicked', self.refresh_luid_info)

			self.luidbox = gtk.VBox()
			self.luidbox.show()
			self.luidbox.pack_start(self.luidinfof, gtk.FALSE, gtk.FALSE, 0)
			self.luidbox.pack_start(self.luidf, gtk.TRUE, gtk.TRUE, 0)
			self.luidbox.pack_end(self.luidbutton, gtk.FALSE, gtk.FALSE, 3)

# === Bring all Tabs together to Notebook === #
		self.main_notebook = gtk.Notebook()
		self.main_notebook.popup_enable()
		self.main_notebook.set_scrollable(gtk.TRUE)
		self.main_notebook.set_tab_pos(gtk.POS_TOP)
		self.main_notebook.show()

		self.main_notebook.append_page(self.gentab,     gtk.Label(unicode(_("General"))))
		self.main_notebook.append_page(self.logtab,     gtk.Label(unicode(_("Logs"))))
		self.main_notebook.append_page(self.dlframe,    gtk.Label(unicode(_("Download"))))
		self.main_notebook.append_page(self.colorframe, gtk.Label(unicode(_("Colors"))))
		if luid_info is not None:
			self.main_notebook.append_page(self.luidbox,    gtk.Label(unicode(_("LUID"))))

# === Bring all items together to Main Window Finally === #
		self.window = gtk.Dialog(("%s: " % APP + unicode(_("Preferences"))), self.app.window,
								 gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
								 (gtk.STOCK_APPLY, gtk.RESPONSE_APPLY,
								  gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
								  gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
		self.window.set_border_width(5)
		self.window.connect("destroy", self.close)
		self.window.set_title("%s: " % APP + unicode(_("Preferences")))
		self.window.vbox.pack_start(self.main_notebook, gtk.TRUE, gtk.TRUE, 0)

# === Initialization of PreferenceDialog === #
		self.prefmanager.load_database()
		self.set_prefs()

# === Start mainloop of Dialog === #
		self.window.show()
		while True:
			response = self.window.run()

			if response == gtk.RESPONSE_APPLY:
				self.prefmanager.save_database(self)
				self.app.notify_preferences_changed(self.get_prefs())
			elif response == gtk.RESPONSE_ACCEPT:
				self.prefmanager.save_database(self)
				self.app.notify_preferences_changed(self.get_prefs())
				self.close()
				break
			elif response == gtk.RESPONSE_REJECT:
				self.set_prefs()
				self.close()
				break

	def refresh_luid_info(self, widget=None, data=None):
		luid_data = self.luid_info.get_all(True)

		if luid_data['info'] and luid_data['table']:
			self.luidinfolist.freeze()
			self.luidinfolist.hide()
			self.luidinfolist.clear()
			self.luidinfosw.remove(self.luidinfolist)
			self.luidinfolist = gtk.CList(len(luid_data['info'][0]), luid_data['info'][0])
			self.luidinfolist.column_titles_passive()
			self.luidinfolist.set_column_auto_resize(1, gtk.TRUE)
			self.luidinfosw.add(self.luidinfolist)
			for line in luid_data['info'][1:]:
				self.luidinfolist.append(tuple(line))
			self.luidinfolist.columns_autosize()
			self.luidinfolist.thaw()
			self.luidinfolist.show()

			self.luidlist.freeze()
			self.luidlist.hide()
			self.luidlist.clear()
			self.luidsw.remove(self.luidlist)
			self.luidlist = gtk.CList(len(luid_data['table'][0]), luid_data['table'][0])
			self.luidlist.column_titles_passive()
			self.luidlist.set_column_auto_resize(1, gtk.TRUE)
			self.luidsw.add(self.luidlist)
			for line in luid_data['table'][1:]:
				self.luidlist.append(tuple(line))
			self.luidlist.columns_autosize()
			self.luidlist.thaw()
			self.luidlist.show()

	def close(self, widget=None, data=None):
		self.window.destroy()

	def get_prefs(self):
		prefs = {}

		# CheckButtons
		for name in ['auto_open_log', 'auto_connect', 'auto_join', 'autodl',
					 'forward', 'accept_all', 'forward_listed', 'auto_clear',
					 'logging', 'logging_current_tab_closed',
					 'logtabfocus', 'download_log'] + DL_SUFFIX_PATTERNS.keys():
			prefs[name] = self.prefs[name].get_active()

		# Entries
		for name in ['browser', 'script', 'sakura',
					 'kero', 'sync', 'error', 'URL',
					 'initialscript', 'logging_path']:
			prefs[name] = self.prefs[name].get_text()

		# RadioButtons
		for name in [POS_NEXT, POS_PREV,
					 POS_FIRST, POS_END]:
			if self.prefs[name].get_active():
				prefs['logpagepos'] = name
				break
		for type in [gtk.POS_TOP, gtk.POS_BOTTOM, gtk.POS_LEFT, gtk.POS_RIGHT]:
			name = "LOGTABPOS_%s" % type
			if self.prefs[name].get_active():
				prefs['logtabpos'] = type
				break

		return prefs

	def set_prefs(self):
		for key in self.prefmanager.rc.keys():
			if self.prefs.has_key(key):
				# Entries
				if key in ['browser', 'script', 'sakura',
						   'kero', 'sync', 'error', 'URL',
						   'initialscript', 'logging_path']:
					self.prefs[key].set_text(self.prefmanager.rc[key])
				else:
					self.prefs[key].set_active(self.prefmanager.rc[key])

			if key == 'logpagepos':
				for type in [POS_NEXT, POS_PREV,
							 POS_FIRST, POS_END]:
					if self.prefmanager.rc[key] == type:
						self.prefs[type].set_active(gtk.TRUE)
						break
			elif key == 'logtabpos':
				for type in [gtk.POS_TOP, gtk.POS_BOTTOM, gtk.POS_LEFT, gtk.POS_RIGHT]:
					name = "LOGTABPOS_%s" % type
					if self.prefmanager.rc[key] == str(type):
						self.prefs[name].set_active(gtk.TRUE)
						break

		if not self.prefs['forward'].get_active():
			self.prefs['accept_all'].set_sensitive(gtk.FALSE)
			self.prefs['forward_listed'].set_sensitive(gtk.FALSE)

	def forward_toggled(self, widget=None, data=None):
		state = self.prefs['forward'].get_active()
		self.prefs['accept_all'].set_sensitive(state)
		self.prefs['forward_listed'].set_sensitive(state)

	def download_toggled(self, widget=None, data=None):
		state = self.prefs['autodl'].get_active()
		self.prefs['download_log'].set_sensitive(state)
		for p in DL_SUFFIX_PATTERNS.keys():
			self.prefs[p].set_sensitive(state)

	def logging_toggled(self, widget=None, data=None):
		logging_state = self.prefs['logging'].get_active()
		logcurr_state = self.prefs['logging_current_tab_closed'].get_active()

		if not logging_state and not logcurr_state:
			self.prefs['logging_path'].set_sensitive(gtk.FALSE)
		else:
			self.prefs['logging_path'].set_sensitive(gtk.TRUE)


class PreferenceManager:
	DBFILE = "bottlerc"

	def __init__(self):
		self.dbpath = os.path.join(open_bottlecase(), self.DBFILE)
		self.rc = {}
		self.initialize()
		self.load_database()

	def initialize(self):
		for k, v in [['auto_open_log', False],
					 ['auto_connect', False],
					 ['auto_join', False],
					 ['autodl', False],
					 ['download_log', True],
					 ['forward', True],
					 ['accept_all', True],
					 ['forward_listed', False],
					 ['auto_clear', True],
					 ['initialscript', r'\t\u\s[10]\h\s[0]|\e'],
					 ['logging', False],
					 ['logging_current_tab_closed', False],
					 ['logging_path', os.path.normpath(open_bottlecase() + '/autolog/%Y%m%d/%H-%M-%S.xml')],
					 ['logtabfocus', True],
					 ['logpagepos', POS_NEXT],
					 ['logtabpos', gtk.POS_TOP],
					 ['browser', "mozilla -remote 'openFile(%s,new-tab)'"],
					 ['script', "dark green"],
					 ['sakura', "black"],
					 ['kero', "brown"],
					 ['sync', "blue"],
					 ['error', "red"],
					 ['URL', "purple"]] + [[i, True] for i in DL_SUFFIX_PATTERNS.keys()]:
			self.rc[k] = v

	def load_database(self):
		pat = re.compile('\s*:\s*')
		try:
			file = open(self.dbpath)
		except IOError:
			return
		while 1:
			line = unicode(file.readline(), "utf-8")
			if not line:
				break
			elif line[0] in ["#", ";"]:
				continue
			elif line[0:2] == "//":
				continue
			elif line[-2:] == "\r\n":
				line = line[:-2]
			elif line[-1] in ["\r", "\n"]:
				line = line[:-1]

			[name, value] = pat.split(line, 1)
			if value == 'True':
				value = True
			elif value == 'False':
				value = False
			self.rc[name] = value
		file.close()

	def save_database(self, prefdialog):
		try:
			file = open(self.dbpath, "w")
		except IOError:
			sys.stderr.write("Error: cannot write %s\n" % self.dbpath)
			return
		self.rc = prefdialog.get_prefs()
		file.write("# This is an auto-generated file.\n")
		file.write("# Don't edit this file while running %s!\n" % APP)
		for key in self.rc.keys():
			file.write("%s: %s\n" % (key.encode("utf-8"), self.rc[key]))
		file.close()

	def get(self, name):
		if not self.rc.has_key(name):
			raise ValueError("rc has no key %s\n" % name)
		return self.rc[name]
