//=============================================================================
//
// ͏ [input.h]
// Author : AKIRA TANAKA
//
//=============================================================================
#ifndef _INPUT_H_
#define _INPUT_H_

#include "main.h"
#pragma comment( lib ,"dinput8.lib")

#define	DIRECTINPUT_VERSION (0x0800)
#include  <dinput.h>


//*****************************************************************************
// }N`
//*****************************************************************************
#define	NUM_KEY_MAX		(256)	// L[ő吔

//*********************************************************
// ̓NX
//*********************************************************
class CInput
{
public:
	CInput();
	virtual ~CInput();

	virtual HRESULT Init(HINSTANCE hInst, HWND hWnd);
	virtual void Uninit(void);
	virtual void Update(void) = 0;		// ---> z֐

protected:
	static LPDIRECTINPUT8 m_pDInput;	// DirectInputIuWFNg
	LPDIRECTINPUTDEVICE8 m_pDIDevice;	// DeviceIuWFNg(͂ɕKv)
};

//*********************************************************
// L[{[h̓NX
//*********************************************************
class CInputKeyboard : public CInput
{
public:
	CInputKeyboard();
	~CInputKeyboard();

	HRESULT Init(HINSTANCE hInst, HWND hWnd);
	void Uninit(void);
	void Update(void);

	BOOL GetKeyPress(int nKey);
	BOOL GetKeyTrigger(int nKey);
	BOOL GetKeyRelease(int nKey);
	BOOL GetKeyRepeat(int nKey);
	void FlushKeyTrigger(int nKey);

private:
	BYTE	m_aKeyState[NUM_KEY_MAX];			// L[{[h̏Ԃ󂯎郏[N
	BYTE	m_aKeyStateTrigger[NUM_KEY_MAX];	// gK[[N
	BYTE	m_aKeyStateRelease[NUM_KEY_MAX];	// [X[N
	BYTE	m_aKeyStateRepeat[NUM_KEY_MAX];		// s[g[N
	int		m_aKeyStateRepeatCnt[NUM_KEY_MAX];	// s[gJE^
};



#endif