//=========================================================================
//	_[(renderer.cpp)
//	쐬ҁF
//	쐬F2016/10/31
//=========================================================================
//=========================================================================
//	CN[ht@C
//=========================================================================
#include "main.h"
#include "renderer.h"
#include "scene.h"
#include "scene2D.h"
#include "scene3D.h"

//=========================================================================
//	ÓIϐ
//=========================================================================
LPDIRECT3D9			CRenderer::m_pD3D = NULL;
LPDIRECT3DDEVICE9	CRenderer::m_pD3DDevice;

#ifdef _DEBUG
LPD3DXFONT			CRenderer::m_pFont = NULL;			// tHgւ̃|C^
#endif


//=========================================================================
//	
//=========================================================================
HRESULT	CRenderer::Init( HWND hwnd , BOOL bWindow)
{
	D3DPRESENT_PARAMETERS d3dpp;
    D3DDISPLAYMODE d3ddm;

	// Direct3DIuWFNg̍쐬
	m_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if(m_pD3D == NULL)
	{
		return E_FAIL;
	}

	// ݂̃fBXvC[h擾
    if(FAILED(m_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &d3ddm)))
	{
		return E_FAIL;
	}

	// foCX̃v[e[Vp[^̐ݒ
	ZeroMemory(&d3dpp, sizeof(d3dpp));								// [N[NA
	d3dpp.BackBufferCount			 = 1;							// obNobt@̐
	d3dpp.BackBufferWidth			 = SCREEN_WIDTH;				// Q[ʃTCY()
	d3dpp.BackBufferHeight			 = SCREEN_HEIGHT;				// Q[ʃTCY()
	d3dpp.BackBufferFormat			 = d3ddm.Format;				// J[[h̎w
	d3dpp.SwapEffect				 = D3DSWAPEFFECT_DISCARD;		// fMɓătbv
	d3dpp.EnableAutoDepthStencil	 = TRUE;						// fvXobt@iyobt@jƃXeVobt@쐬
	d3dpp.AutoDepthStencilFormat	 = D3DFMT_D16;					// fvXobt@Ƃ16bitg
	d3dpp.Windowed					 = bWindow;						// EBhE[h
	d3dpp.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;		// tbV[g
	d3dpp.PresentationInterval       = D3DPRESENT_INTERVAL_DEFAULT;	// C^[o

	// foCX̐
	// fBXvCA_v^\߂̃foCX쐬
	// `ƒ_n[hEFAōsȂ
	if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
									D3DDEVTYPE_HAL, 
									hwnd, 
									D3DCREATE_HARDWARE_VERTEXPROCESSING, 
									&d3dpp, &m_pD3DDevice)))
	{
		// L̐ݒ肪s
		// `n[hEFAōsA_CPUōsȂ
		if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
										D3DDEVTYPE_HAL, 
										hwnd, 
										D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
										&d3dpp, &m_pD3DDevice)))
		{
			// L̐ݒ肪s
			// `ƒ_CPUōsȂ
			if(FAILED(m_pD3D->CreateDevice(D3DADAPTER_DEFAULT, 
											D3DDEVTYPE_REF, hwnd, 
											D3DCREATE_SOFTWARE_VERTEXPROCESSING, 
											&d3dpp, &m_pD3DDevice)))
			{
				// s
				return E_FAIL;
			}
		}
	}

	m_pD3DDevice = NULL;

	//Direct3DfoCX̍쐬
	if( FAILED(m_pD3D->CreateDevice(
		D3DADAPTER_DEFAULT ,	//n[hEGAAOtBbN{[hȂǂꍇAOS߂ftHĝw
		D3DDEVTYPE_HAL ,	//`揈^Cv̎wAn[hEGACPU
		hwnd ,			//foCXΏ
		D3DCREATE_HARDWARE_VERTEXPROCESSING ,	//n[hEGAŒ_@foCX쐬IvVtO
		&d3dpp ,			//̑̐ݒl
		&m_pD3DDevice ) ) )//oオC^[tF[Xݒ肷邽߂̃|C^[̃|C^[
	{
		//n[hEGAł̏sꍇ@_\tgEGA
		if( FAILED(m_pD3D->CreateDevice(
			D3DADAPTER_DEFAULT ,	//n[hEGAAOtBbN{[hȂǂꍇAOS߂ftHĝw
			D3DDEVTYPE_HAL ,	//`揈^Cv̎wAn[hEGACPU
			hwnd ,			//foCXΏ
			D3DCREATE_SOFTWARE_VERTEXPROCESSING ,	//n[hEGAŒ_@foCX쐬IvVtO
			&d3dpp ,			//̑̐ݒl
			&m_pD3DDevice ) ) )//oオC^[tF[Xݒ肷邽߂̃|C^[̃|C^[
		{
			//`_\tgEGA
			if( FAILED(m_pD3D->CreateDevice(
				D3DADAPTER_DEFAULT ,	//n[hEGAAOtBbN{[hȂǂꍇAOS߂ftHĝw
				D3DDEVTYPE_REF ,	//`揈^Cv̎wAn[hEGACPU
				hwnd ,			//foCXΏ
				D3DCREATE_SOFTWARE_VERTEXPROCESSING ,	//n[hEGAŒ_@foCX쐬IvVtO
				&d3dpp ,			//̑̐ݒl
				&m_pD3DDevice ) ) )//oオC^[tF[Xݒ肷邽߂̃|C^[̃|C^[
			{
				//ł_
				return	E_FAIL; 
			}
		}
	}

	// _[Xe[g̐ݒ
    m_pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);				// JOsȂ
	m_pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);						// Zobt@gp
	m_pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);				// uhs
	m_pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);		// \[XJ[̎w
	m_pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);	// fXeBl[VJ[̎w

	// Tv[Xe[g̐ݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);	// eNX`tľJԂݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);	// eNX`uľJԂݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);	// eNX`g厞̕Ԑݒ
	m_pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);	// eNX`k̕Ԑݒ

	// eNX`Xe[WXe[g̐ݒ
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);	// At@ufBO(lD3DTOP_SELECTARG1)
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);		// ŏ̃At@(lD3DTA_TEXTUREAeNX`ȂꍇD3DTA_DIFFUSE)
	m_pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG2, D3DTA_CURRENT);		// QԖڂ̃At@(lD3DTA_CURRENT)

		//C[t[ŕ\
#ifdef	WIRE_FRAME_MODE
	m_pD3DDevice->SetRenderState( D3DRS_FILLMODE , D3DFILL_WIREFRAME );
#endif

#ifdef _DEBUG
	// fobO\ptHg̐
	D3DXCreateFont(m_pD3DDevice, 18, 0, 0, 0, FALSE, SHIFTJIS_CHARSET,
					OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Terminal", &m_pFont);
#endif

	return S_OK;
}

//=========================================================================
//	I
//=========================================================================
void	CRenderer::Uninit(void)
{
#ifdef _DEBUG
	// fobO\ptHg̔j
	if(m_pFont != NULL)
	{
		m_pFont->Release();
		m_pFont = NULL;
	}
#endif

	// foCX̔j
	if(m_pD3DDevice != NULL)
	{
		m_pD3DDevice->Release();
		m_pD3DDevice = NULL;
	}

	// Direct3DIuWFNg̔j
	if(m_pD3D != NULL)
	{
		m_pD3D->Release();
		m_pD3D = NULL;
	}
}

//=========================================================================
//	XV
//=========================================================================
void	CRenderer::Update(void)
{
	
}

//=========================================================================
//	`揈Jn
//=========================================================================
void	CRenderer::DrawBigin(void)
{
	// obNobt@yobt@̃NA
	m_pD3DDevice->Clear(0, NULL, (D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER), D3DCOLOR_RGBA( 64, 128 , 128, 255 ), 1.0f, 0);

	// Direct3Dɂ`̊Jn
	if(FAILED(m_pD3DDevice->BeginScene()))
	{
		UINT nID = MessageBox( NULL , "`Jnł܂\n" , "ERROR[ renderer.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
	}

#ifdef _DEBUG
		// FPS\
		DrawFPS();
#endif
}

//=========================================================================
//	`I
//=========================================================================
void	CRenderer::DrawEnd(void)
{
	// Direct3Dɂ`̏I
	m_pD3DDevice->EndScene();

	// obNobt@ƃtgobt@̓ւ
	m_pD3DDevice->Present(NULL, NULL, NULL, NULL);
}


#ifdef _DEBUG
//=============================================================================
// FPS\
//=============================================================================
void CRenderer::DrawFPS(void)
{
	RECT rect = {0, 0, SCREEN_WIDTH, SCREEN_HEIGHT};
	char str[256];
	int nCountFPS;

	nCountFPS = GetFPS();
	wsprintf(str, "FPS:%d\n", nCountFPS);

	// eLXg`
	m_pFont->DrawText(NULL, str, -1, &rect, DT_LEFT, D3DCOLOR_ARGB(0xff, 0xff, 0xff, 0xff));
}
#endif
