//=========================================================================
//	XJCh[NX[ skydome.cpp ]
//	쐬F2017/05/10
//	쐬ҁF
//=========================================================================
#include	"skydome.h"
#include	"renderer.h"
#include	"manager.h"
#include	"camera.h"
#include	"light.h"

//=========================================================================
//	萔`
//=========================================================================
//DrawSphearŎg_̐ݒ
#define FVF_VERTEX_SKY (D3DFVF_XYZ | D3DFVF_TEX1)

//ǂݍރeNX`̖O
#define TEXTURENAME "data/TEXTURE/4690241.jpg"

//=========================================================================
//	\
//=========================================================================
typedef	struct
{
	D3DXVECTOR3 pos;
	D3DXVECTOR2 tex;
}VERTEX_SKY;

//=========================================================================
// 
//=========================================================================
void CSkyDome::Init( void )
{
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	m_fLength = 3000.0f;

	D3DXCreateSphere( pDevice , m_fLength , 32 , 32 , &m_Mesh , NULL);

	m_Mesh->CloneMeshFVF(NULL, FVF_VERTEX_SKY , pDevice , &m_Mesh2);

	LPDIRECT3DVERTEXBUFFER9 pVertexBuffer = NULL;
	VERTEX_SKY* pVertex = NULL;
	m_Mesh2->GetVertexBuffer( &pVertexBuffer );
	pVertexBuffer->Lock( 0 , 0 , (VOID**)&pVertex , 0 );
	
	DWORD n;
	
	//_̐擾
	for( n = 0 ; n < m_Mesh2->GetNumVertices() ; n++ )
	{
		float u,v;
	//	convert(pVer[n].x,pVer[n].y,pVer[n].z,R,u,v);

		float q;
		float q2;
		q = atan2( pVertex[ n ].pos.z , pVertex[ n ].pos.x );

		u = q / (2.0f * 3.1415f);
		q2 = asin( pVertex[ n ].pos.y / m_fLength );
		v = ( 1.0f - q2 / ( 3.1415f/2.0f ))/2.0f;
		if( u > 1.0 )
		u = 1.0;

		pVertex[n].tex.x = u; 
		pVertex[n].tex.y = v;
	}
	pVertexBuffer->Unlock();

	if (FAILED( D3DXCreateTextureFromFile(pDevice , TEXTURENAME , &m_pTexture ) ))
	{
        UINT nID = MessageBox( NULL , "eNX`ǂݍ߂܂\n" , "ERROR[ skydome.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
    }
}

//=========================================================================
// I
//=========================================================================
void CSkyDome::Uninit( void )
{
	if( m_Mesh != NULL )
	{
		m_Mesh->Release();
		m_Mesh = NULL;
	}

	if( m_Mesh2 != NULL )
	{
		m_Mesh2->Release();
		m_Mesh2 = NULL;
	}

	CScene3D::Uninit();
}

//=========================================================================
// XV
//=========================================================================
void CSkyDome::Update( void )
{}

//=========================================================================
// `揈
//=========================================================================
void CSkyDome::Draw( void )
{

	LPDIRECT3DDEVICE9	pDevice;
	pDevice = CRenderer::GetDevice();

	pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);				// JOsȂ

	pDevice->SetRenderState( D3DRS_WRAP0 , D3DWRAPCOORD_0 );

	//[h}gNX̍쐬
	D3DXMATRIX	mtxWorld , mtxRot;
	//SSsNX

	//Pʍs̍쐬
	D3DXMatrixIdentity( &mtxWorld );	//sPʍsɂ
	
	//g̏
	D3DXMATRIX	mtxKakudai;	//gs
	D3DXMatrixScaling( &mtxKakudai , 1.0f , 1.0f , 1.0f );

	//]̏
	D3DXMATRIX	mtxKaiten;	//]s
	D3DXMatrixRotationYawPitchRoll( &mtxKaiten , 0.0f , 0.0f , 0.0f );	
	
	D3DXMATRIX	mtxHeikou;	//sړs
	D3DXMatrixTranslation( &mtxHeikou , GetPosition().x , GetPosition().y , GetPosition().z );

	//s̊|Z
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKakudai );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKaiten );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxHeikou );	

	//CgOFF
	CManager::GetLight()->OffLight();

	//foCXɃ[hϊso^
	pDevice->SetTransform( D3DTS_WORLD , &mtxWorld );

	//r[s̍쐬
	D3DXMATRIX	mtxView = CManager::GetCamera()->GetView();

	//foCXɃr[ϊsݒ
	pDevice->SetTransform( D3DTS_VIEW , &mtxView);

	//pDevice->SetTextureStageState(0,D3DTSS_COLORARG2,D3DTA_TEXTURE);

	pDevice->SetStreamSource( 0 , m_pVtxBuffer , 0 , sizeof(VERTEX_SKY) );

	pDevice->SetFVF( FVF_VERTEX_SKY );

	pDevice->SetTexture( 0,  m_pTexture );

	//|S̕`
	m_Mesh2->DrawSubset(0);
	//CgON
	CManager::GetLight()->OnLight();


	pDevice->SetRenderState( D3DRS_WRAP0 , 0 );
	pDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);

}

//=========================================================================
//	XJCh[̍쐬
//=========================================================================
CSkyDome* CSkyDome::Create( void )
{
	CSkyDome *pskydome;
	pskydome = new CSkyDome;
	pskydome->Init();

	return pskydome;
}