/***************************************************************/
//
//
//		DirectX	[ debugmanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 1/7
/*---------------------------------------------------------------
Update : 2017/1/7
			debugmanager.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#include <WinBase.h>
#include "window.h"
#include "system_component.h"

#include "game_manager.h"
#include "rendererdx9.h"

#include "d_manager.h"
#include "d_console.h"
#include "d_log.h"
#include "d_font.h"
//#include "debugfont.h"

// [U[Cvbg
#include "mouse.h"

// vZR|[lg

#pragma comment ( lib, "Kernel32.lib" )
//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")

using namespace std;      								// WCuOԎw

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define NUM_VERTEX  ( 4 )								// 1`Ŏgp钸_
#define NUM_POLYGON ( 2 )								// `悷|S

#define TEXTURE_NAME "data/texture/background.jpg"		// eNX`pX

/*----------------------------------------------------------------
	X^eBbNoϐ̏
----------------------------------------------------------------*/

vector<CDebugManager*> CDebugManager::pManager;
int                    CDebugManager::counter = 0;
LPDIRECT3DDEVICE9      CDebugManager::pDevice = nullptr;



// fobO}l[W[̃RXgN^
CDebugManager::CDebugManager( )
{
	
	// fobO}l[W̕ϐ
	pDebugConsole = nullptr;
	pDebugLog     = nullptr;
	pDebugFont    = nullptr;
	pLine         = nullptr;

	// vϐ̏
	//ZeroMemory( &point, sizeof( D3DXVECTOR3 * PROCESS_COUNT ) );
	measureNumber = 0;

	// }Cio[
	myNumber = 0;	

}

// fobO}l[W[̃fXgN^
CDebugManager::~CDebugManager( )
{

	// Ȃ

}

// fobO}l[W[̏
void CDebugManager::Init( void )
{


	{ // fobO@\Zbg

		// R\[
		#ifdef _DEBUG
		Console::OpenConsole( );
		#endif // _DEBUG

		// OJn
		pDebugLog = new CDebugLog;
		pDebugLog ->StartLog( "data\\log.txt");

		// WindowfobO
		pDebugFont = CDebugFont::SetDebugFont( ); 
		pDebugFont ->SetColor( &D3DXCOLOR( 0.39f, 1, 1, 1 ) );

	} // -> START DEBUG


	// Ot`pfoCX̐ݒ
	if( !pDevice ){

		// foCX̎擾
		Renderer* pRenderer= GameManager::Operate( )->DeviceInfo( );
		pDevice = dynamic_cast< RendererDX9* >(pRenderer)->GetDevice( );
	}

	// C`foCX̍쐬
	HRESULT hResult = D3DXCreateLine( pDevice, &pLine ); 
	if( FAILED( hResult ) ){
	
		#ifdef _DEBUG
		MessageBox( NULL, "LINE DEVICE DONT CREATED !!", "CREATE LINE ERROR !! ", MB_OK | MB_ICONWARNING );
		#endif // _DEBUG
	}

	// _̏
	for( int index = 0; index < PROCESS_COUNT; index++ ){
	
		point[ index ] = D3DXVECTOR2( ((Window::SCREEN_WIDTH / PROCESS_COUNT) * index), 0.0f + ( Window::SCREEN_HEIGHT >> 1 ) + (10 * index) );
	}


	// eNX`̓ǂݍ 
	#ifdef TEXTURE_NAME
	HRESULT hres = D3DXCreateTextureFromFile( pDevice, TEXTURE_NAME, &pBackGround );
	if( FAILED( hres )){
		#ifdef _DEBUG
		MessageBox( NULL, "eNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}
	#endif // TEXTURE_NAME

	// obNobt@|C^i[
	pDevice->GetRenderTarget( 0 , &pBackbuf );

	// eNX`̍쐬
	pDevice ->CreateTexture(
		Window::SCREEN_WIDTH, Window::SCREEN_HEIGHT,
		1,
		D3DUSAGE_RENDERTARGET,
		D3DFMT_A8R8G8B8,
		D3DPOOL_DEFAULT,
		&pTexture,
		NULL
	);	

	// T[tFX̐ݒ
	pTexture ->GetSurfaceLevel( 0, &pSurface );
	
	// |Sʒu̐ݒ
	pos = D3DXVECTOR3( (Window::SCREEN_WIDTH >>1) + (Window::SCREEN_WIDTH >>2), (Window::SCREEN_HEIGHT >> 1) - (Window::SCREEN_HEIGHT >>2), 0.0f );
	
	// _obt@̍쐬
	Vertex2D *pVtx;									// zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(Vertex2D) * NUM_VERTEX,	 	 		// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_VERTEX_2D,								// gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							// obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&pVtxBuf,									// i[|C^
			NULL)))
	{
		#ifdef _DEBUG
		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!", MB_OK );
		#endif // _DEBUG
		return;
	}

	// W̐ݒ
	D3DXVECTOR2 start,end;								// eNX`ʒu n_ƏI_
	start = D3DXVECTOR2( pos.x - ( Window::SCREEN_WIDTH * 0.15f ), pos.y - ( Window::SCREEN_HEIGHT * 0.15f ) );
	end   = D3DXVECTOR2( pos.x + ( Window::SCREEN_WIDTH * 0.15f ), pos.y + ( Window::SCREEN_HEIGHT * 0.15f ) );

	
	// obt@bNzAhX擾
	pVtxBuf -> Lock(0,0,(void**)&pVtx,0);				// GPUVRAMւ̑bN

	pVtx[ 0 ].pos = Vector3( start.x, start.y,0 ); 
	pVtx[ 1 ].pos = Vector3( end.x,   start.y,0 ); 
	pVtx[ 2 ].pos = Vector3( start.x, end.y,0   ); 
	pVtx[ 3 ].pos = Vector3( end.x,   end.y,0   ); 

	pVtx[ 0 ].rhw = 1.0f;
	pVtx[ 1 ].rhw = 1.0f;
	pVtx[ 2 ].rhw = 1.0f;
	pVtx[ 3 ].rhw = 1.0f;

	pVtx[ 0 ].color = ARGB_COLOR( 192, 192, 244, 100 );
	pVtx[ 1 ].color = ARGB_COLOR( 192, 192, 244, 100 );
	pVtx[ 2 ].color = ARGB_COLOR( 192, 192, 244, 100 );
	pVtx[ 3 ].color = ARGB_COLOR( 192, 192, 244, 100 );

	pVtx[ 0 ].tex = Vector2( 0.0f, 0.0f );
	pVtx[ 1 ].tex = Vector2( 1.0f, 0.0f );
	pVtx[ 2 ].tex = Vector2( 0.0f, 1.0f );
	pVtx[ 3 ].tex = Vector2( 1.0f, 1.0f );

	// obt@̃AbN
	pVtxBuf ->Unlock();

	
	// v̍쐬
	LARGE_INTEGER def = {};
	DWORD set = 0;
	nFreq.push_back( def );
	nBefore.push_back( def );
	nAfter.push_back( def );
	dwTime.push_back( set );

	// vϐ̏
	memset(&nFreq[measureNumber],   0x00, sizeof nFreq[measureNumber]);
	memset(&nBefore[measureNumber], 0x00, sizeof nBefore[measureNumber]);
	memset(&nAfter[measureNumber],  0x00, sizeof nAfter[measureNumber]);
	memset(&freq,   0x00, sizeof freq );
	memset(&before, 0x00, sizeof before );
	memset(&after,  0x00, sizeof after );
	dwTime[measureNumber] = 0;

	measureNumber++;

}

// fobO}l[W[̏I
void CDebugManager::Uninit( void )
{


	// C`foCX̍폜
	SAFE_RELEASE( pLine )

	// _obt@̔j
	SAFE_RELEASE( pVtxBuf )

	// eNX`T[tFXj
	SAFE_RELEASE( pTexture )
	SAFE_RELEASE( pBackGround )
	SAFE_RELEASE( pSurface )
	SAFE_RELEASE( pBackbuf )

	{ // fobO@\I
	
		// R\[I
		Console::CloseConsole( );

		// OI
		pDebugLog ->EndLog( );
		SAFE_DELETE( pDebugLog )

		// 

	} // -> END DEBUG

	// fobO}l[W[̔j
	CDebugManager::Release( );
	
}

// fobO}l[W[̍XV
void CDebugManager::Update( void )
{

	// Ot̃f[^XV
	CDebugManager::UpdateGraph( );
	
	{ // _W̍XV
		
		Vertex2D *pVtx;									// zAhX

		// obt@bNzAhX擾
		pVtxBuf -> Lock(0,0,(void**)&pVtx,0);		// GPUVRAMւ̑bN

		// W̐ݒ
		D3DXVECTOR2 start,end;								// eNX`ʒu n_ƏI_
		start = D3DXVECTOR2( pos.x - ( Window::SCREEN_WIDTH * 0.15f ), pos.y - ( Window::SCREEN_HEIGHT * 0.15f ) );
		end   = D3DXVECTOR2( pos.x + ( Window::SCREEN_WIDTH * 0.15f ), pos.y + ( Window::SCREEN_HEIGHT * 0.15f ) );

		pVtx[ 0 ].pos = Vector3( start.x, start.y,0 ); 
		pVtx[ 1 ].pos = Vector3( end.x,   start.y,0 ); 
		pVtx[ 2 ].pos = Vector3( start.x, end.y,0  ); 
		pVtx[ 3 ].pos = Vector3( end.x,   end.y,0  ); 

		// obt@̃AbN
		pVtxBuf ->Unlock();
		
	}

}

// fobO}l[W[̕`
void CDebugManager::Draw( void )
{
	
	// ԃOt̕`
	CDebugManager::DrawGraph( );
	
	{ // |S̕`
	
		// Xg[
		pDevice->SetStreamSource(0,
		pVtxBuf,											// ǂ̒_obt@\ƌԂ...
		0,													// f[^̃ItZbg
		sizeof(Vertex2D));									// XgChl(oCg)

		// _tH[}bg̐ݒ
		pDevice ->SetFVF(FVF_VERTEX_2D);

		// eNX`̐ݒ
		pDevice ->SetTexture( 0, pBackGround );		

		// |S̕`
		pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0 , NUM_POLYGON );

		// eNX`̐ݒ
		pDevice ->SetTexture( 0, pTexture );		

		// |S̕`
		pDevice ->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0 , NUM_POLYGON );
	}

}

// ԌvJn
void CDebugManager::StartMeasureProcess( void )
{

	// gݒ
	if( !QueryPerformanceFrequency( &freq ) ){

		#ifdef _DEBUG
		Console::DebugLog( " OS@\T|[gĂȂߌvo܂łB" );
		#endif // _DEBUG
		return;
	}
	//QueryPerformanceFrequency(&freq);
	//nFreq[0].QuadPart = def.QuadPart;

	// vJn
	QueryPerformanceCounter(&before);

}

// ԌvI
void CDebugManager::EndMeasureProcess( void )
{
	

	// vI
	if( !QueryPerformanceCounter(&after) ){

		#ifdef _DEBUG
		Console::DebugLog( " OS@\T|[gĂȂߌvo܂łB" );
		#endif // _DEBUG
		return;
	}

	// Ԏ擾
	dwTime[0] = (DWORD)((after.QuadPart - before.QuadPart) * 1000 / freq.QuadPart);

	// f[^FIFOŃ\[g
	for( int index = 0; index < PROCESS_COUNT-1; index++ ){
	
		point[ index ].y =  point[ index+1 ].y;
	}

	// lݒ
	point[ PROCESS_COUNT-1 ].y = (float)dwTime[0] * 10.0f;
	point[ PROCESS_COUNT-1 ].y += (float)( Window::SCREEN_HEIGHT >> 1 );
	#ifdef _DEBUG
	//pDebugLog ->WriteLog( " --  -- \n" );
	#endif // _DEBUG

	for( int index = 0; index < PROCESS_COUNT; index++ ){
	
		point[ index ].x = ((Window::SCREEN_WIDTH / (PROCESS_COUNT-1)) * index);
		#ifdef _DEBUG
		//pDebugLog ->WriteLog( " index : %d \n x : %f  \n y : %f \n ", index, point[index].x, point[index].y );
		#endif // _DEBUG
	}

}

// ԌvJn(w)
void CDebugManager::StartMeasureProcess( const int index )
{

	// gݒ
	if( !QueryPerformanceFrequency( &freq ) ){

		#ifdef _DEBUG
		Console::DebugLog( " OS@\T|[gĂȂߌvo܂łB" );
		#endif // _DEBUG
		return;
	}

	// vJn
	QueryPerformanceCounter(&before);


}

// ԌvJn(w)
void CDebugManager::EndMeasureProcess( const int index )
{


	// vI
	if( !QueryPerformanceCounter(&after) ){

		#ifdef _DEBUG
		Console::DebugLog( " OS@\T|[gĂȂߌvo܂łB" );
		#endif // _DEBUG
		return;
	}

	// Ԏ擾
	dwTime[0] = (DWORD)((after.QuadPart - before.QuadPart) * 1000 / freq.QuadPart);

	// f[^FIFOŃ\[g
	for( int index = 0; index < PROCESS_COUNT-1; index++ ){
	
		point[ index ].y =  point[ index+1 ].y;
	}

	// lݒ
	point[ PROCESS_COUNT-1 ].y = (float)dwTime[0] * 10.0f;
	point[ PROCESS_COUNT-1 ].y += (float)( Window::SCREEN_HEIGHT >> 1 );
	#ifdef _DEBUG
	Console::DebugLog( " --  -- \n" );
	#endif // _DEBUG

	for( int index = 0; index < PROCESS_COUNT; index++ ){
	
		point[ index ].x = ((Window::SCREEN_WIDTH / (PROCESS_COUNT-1)) * index);
		#ifdef _DEBUG
		//Console::DebugLog( " index : %d \n x : %f  \n y : %f \n ", index, point[index].x, point[index].y );
		#endif // _DEBUG
	}


}

// ԃOtpf[^̍XV
void CDebugManager::UpdateGraph( void )
{

	// OtʒuXV
	#ifdef _GAME_EQUATION_H_
	#ifdef _MOUSE_H_
	D3DXVECTOR2 start = D3DXVECTOR2( pos.x - ( SCREEN_WIDTH * 0.15f ), pos.y - ( SCREEN_HEIGHT * 0.15f ) );
	D3DXVECTOR2 end   = D3DXVECTOR2( pos.x + ( SCREEN_WIDTH * 0.15f ), pos.y + ( SCREEN_HEIGHT * 0.15f ) );
	D3DXVECTOR2 coord = D3DXVECTOR2( CMouse::Access()->GetMouseX(), CMouse::Access()->GetMouseY() );
	if( __ObjectTouchSquare( &start, &end, &coord ) ){
		if( CMouse::Access()->GetKeyPress( CMouse::MOUSE_BUTTON_LEFT ) ){

			// }EXW擾
			pos.x = CMouse::Access()->GetMouseX( );
			pos.y = CMouse::Access()->GetMouseY( );
		}
	}
	#endif // _MOUSE_H_
	#endif // _GAME_EQUATION_H_

}

// ԂOt`
void CDebugManager::DrawGraph( void )
{


	// _O^[QbgeNX`ɕύX
	pDevice->SetRenderTarget( 0 , pSurface );

	
	// T[tFCX̃NA
	pDevice->Clear(0,								// NA`̈̐
		NULL,										// `̈
		D3DCLEAR_TARGET								// _O^[QbgƐ[xobt@NA 
		| D3DCLEAR_ZBUFFER,							// [x
		D3DCOLOR_RGBA( 255,255,255,0 ),				// Fɓx100%ɃNA
		1.0f,										// Zobt@̃NAl
		0											// XeVobt@̃NAl
	);
	
	
	// ̑ 
	pLine ->SetWidth( 5.0f ); 

	// `Jn
	pLine->Begin( );  

	// At@ufBO̐ݒ 
	pDevice ->SetRenderState( D3DRS_ALPHABLENDENABLE , TRUE); 
	pDevice ->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA); 
	pDevice ->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA); 

	// Ot`
	pLine ->Draw( 
		point,								// _
		PROCESS_COUNT,						// 
		D3DCOLOR_ARGB(255,255,0,0));		// `悷̐F
	//`I
	
	pLine->End( ); 
	
	
	// _O^[QbgobNobt@ɕύX
	pDevice->SetRenderTarget( 0 , pBackbuf );


}

// fobOÕ|C^̎擾
CDebugLog* CDebugManager::GetDebugLog( void )
{

	#ifdef _DEBUGLOG_H_
		return pManager[ myNumber ] ->pDebugLog;
	#else
		#ifdef _DEBUG
		MessageBox( NULL, "ERROR", "ERROR !!", MB_OK | MB_ICONWARNING );
		#endif // _DEBUG
	#endif // _DEBUGLOG_H_

	return 0;

}

// fobOtHg̎擾
CDebugFont* CDebugManager::GetDebugFont( void )
{

	#ifdef _DEBUGFONT_H_
		return pManager[ myNumber ] ->pDebugFont;
	#else
		#ifdef _DEBUG
		MessageBox( NULL, "ERROR", "ERROR !!", MB_OK | MB_ICONWARNING );
		#endif // _DEBUG
	#endif // _DEBUGFONT_H_

	return 0;

}

// fobO}l[W[̍쐬
CDebugManager* CDebugManager::Create( void )
{

	// foCX̎擾
	if( !pDevice ){
	
		pDevice = GetDevice( );
	}

	// fobO}l[W[̍쐬
	CDebugManager* pDebugManager;
	pDebugManager = new CDebugManager;
	pManager.push_back( pDebugManager );
	pManager[counter] ->myNumber = counter;
	counter++;

	return pDebugManager;

}

// fobO}l[W[̃CfbNXԍ̃|C^̎擾
CDebugManager* CDebugManager::IndexAccess( const int number )
{

	// G[`FbN
	if( number >= counter ){
	
		#ifdef _DEBUG
		MessageBox( NULL, "QƔԍ܂", " ERROR D_MANAGER ", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
		return NULL;
	}

	return pManager[ number ];

}

// SXV
void CDebugManager::UpdateAll( void )
{
	
	for( int index = 0; index < counter; index ++ ){

		if( pManager[ index ] != NULL ){
		
			pManager[ index ] ->Update( );
		}
	}


}

// S`揈
void CDebugManager::DrawAll( void )
{

	for( int index = 0; index < counter; index ++ ){

		if( pManager[ index ] != NULL ){
		
			pManager[ index ] ->Draw( );
		}
	}

	// Render Debug Font
	CDebugFont::DrawAll( );

}

// SJ
void CDebugManager::ReleaseAll( void )
{

	// CDebug Font Release
	CDebugFont::ReleaseAll( );

	for( int index = 0; index < counter; index ++ ){

		if( pManager[ index ] != NULL ){
		
			pManager[ index ] ->Uninit( );
		}
	}

}

// ʉ
void CDebugManager::Release( void )
{
	
	if( pManager[ myNumber ] != NULL ){

		int nID;

		// delete̍ۂID̂ŕۑ
		nID = myNumber;

		// fobO}l[W[̍폜
		pManager.erase( pManager.begin() + nID );

		// 폜ƓɑOl߂̂ŁACfbNXԍOl
		if( counter != nID ){
			for( int index = nID; index < counter-1; index++ ){
			
				pManager[ nID ] ->myNumber = index;
			}
		}
		//pManager[ counter ] = NULL;
		counter--;
	}

}

// fobObZ[Wo
void CDebugManager::DebugMsg( char* buf, ... )
{

	va_list ap;
	char str[ 256 ];
	bool flag = false;
	DWORD word;

	va_start( ap, buf );
	vsprintf( str, buf, ap );
	va_end( ap );

	#ifdef _DEBUG
	MessageBox( NULL, str, APPLICATION_NAME, MB_OK | MB_ICONWARNING );
	#endif // _DEBUG


}


