/***************************************************************/
//
//
//		DirectX	[ dictionary.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/16
/*---------------------------------------------------------------
Update : 2017/6/16
			Create Header File -> dictionary.h.h 
 			< Add Class Function >


Update : 2017/6/16



/*-------------------------------------------------------------*/
#ifndef _DICTIONARY_H_

#define _DICTIONARY_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#define _CRT_SECURE_NO_WARNINGS

#include <stdio.h>

#include <map>
#include <vector>


/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Dictionary Using Dictionary
template <class A, class B> class Dictionary
{

public:

	// Member Variable
	std::map< A, B > data;
	std::vector< A > id;


public:
	
	Dictionary( ){}						// Dictionary Constructor
	~Dictionary( ){}					// Dictionary Destructor

	void Registry(						// Dictionary Registry
		A search,
		B data ){
	
		data[search] = data;
		id.push_back( search );
	}
		
	void Release( B search ){			// Dictionary Search
	
		for( int index = 0; index < id.size(); index++ ){
			if( data[id[index]] == search ){
				
				//data[id[index]]->Release( );
				auto itr = data.find( id[index] );
				data.erase(itr);
				id.erase(id.begin()+index);
			}
		}
	}

	void Delete( void ){				// Dictionary Delete
	
		if( id.empty() ){
			return;
		}

		// All data -> Release
		for( int index = 0;; index++ ){

			data[id[index]]->Release( );
			auto itr = data.find( id[index] );
			data.erase(itr);
			if( id[index] == id.back())
				break;
		}
		
		// delete < ID >
		id.erase( id.begin(), id.end() );
	}

	B Export(							// Dictionary GetDictionaryData
		const A search ){
	
		return data[search];
	}	

};


#endif	//	_DICTIONARY_H_


