/***************************************************************/
//
//
//		DirectX	[ fieldmap.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/29
/*---------------------------------------------------------------
Update : 2017/5/29
			Create Header File -> fieldmap.h.h 
 			< Add Class Function >
				FIELDMAP->Constructor
				FIELDMAP->Destructor
				FIELDMAP->Create ( static member )
				FIELDMAP->Init
				FIELDMAP->Uninit
				FIELDMAP->Update
				FIELDMAP->Draw

Update : 2017/6/19@
			}bvIuWFNg̍쐬ƊȒPɂ邽߂ɁA
			fXg[ const char* MODEL_NAME ]
			ǉ

/*-------------------------------------------------------------*/
#ifndef _FIELDMAP_H_

#define _FIELDMAP_H_


//#include "block.h"

#include "system_component.h"
#include "rendererdx9.h"

class GameObject;
class Base;

#include "playercontrol.h"
#include "grid.h"

#include "menulist.h"
#include "currentframe.h"

#define GRID_FVF_FORMAT ( D3DFVF_XYZ | D3DFVF_DIFFUSE )

#define MAP_SIZE (8)

#define MAP_HEIGHT (50)

#define NUM_OBJECT  (512)
#define OBJ_PRIORITY (3)

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class FieldMap Using FieldMap
class FieldMap
{
public:
	
	typedef enum{
		NONE = 0,
		IMMORTAL,	//TS݂Ȃ
		GOAL,		//I
		START,		//X^[g
		MOVE,		//z^e
		TYPE_MAX ,
	}TYPE;
	
	FieldMap( );						// FieldMap Constructor
	~FieldMap( );						// FieldMap Destructor

	static FieldMap* Create( void );	// FieldMap Create Instance Class

	void Init( const char* filename = nullptr );	// FieldMap Initialize
	void Uninit( void );				// FieldMap Uninitialize
	void Update( void );				// FieldMap Update
	void Draw( void );					// FieldMap Draw

	static void PutObject( TYPE type, Base* pObj );
	static Vector2& SetObject( Vector3& pos, TYPE type, GameObject* pObj );
	void FieldCheck( void );
	static int* GetStatus( void );

	bool Scissor( const int& z, const int& x );
	bool OnScissor( const int& z, const int& x );
	void Attack( const int& z, const int& x );

private:

	// Member Variable
	static FieldMap* pMap;

	int vertical;
	int horizonal;
	
	int* map;							// map[][]ƂĎgp
	GameObject** pObj;

	PlayerControl* player;
	Grid* grid;

	int frame;

	UserInterface* select;
	MenuList* menu;

	static	const char* MODEL_NAME[TYPE_MAX];

	Base*		other[OBJ_PRIORITY][NUM_OBJECT];
	Base*		start;
};


#endif	//	_FIELDMAP_H_


