/***************************************************************/
//
//
//		DirectX	[ indexbuffer.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/22
/*---------------------------------------------------------------
Update : 2017/5/22
			Create Header File -> indexbuffer.h.h 
 			< Add Class Function >
				INDEXBUFFER->Constructor
				INDEXBUFFER->Destructor
				INDEXBUFFER->Create ( static member )
				INDEXBUFFER->Init
				INDEXBUFFER->Uninit
				INDEXBUFFER->Update
				INDEXBUFFER->Draw

Update : 2017/5/22



/*-------------------------------------------------------------*/
#ifndef _INDEXBUFFER_H_

#define _INDEXBUFFER_H_



class Vertex3D;
class Vertex2D;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class IndexBuffer Using IndexBuffer
class IndexBuffer
{
public:
	IndexBuffer( );								// IndexBuffer constructor
	virtual ~IndexBuffer( );					// IndexBuffer destructor
	
	virtual bool CreateIndexBuffer(				// IndexBuffer CreateVertexBuffer
		unsigned int indexNumber ) = 0;
	
	virtual void SetIndex( void ) = 0;			// IndexBuffer SetVertex

	virtual void Release( void ) = 0;			// IndexBuffer Uninitialize
	
	virtual void Lock( 							// IndexBuffer Lock
		unsigned short** pIndex ) = 0;
	
	virtual void Unlock( void ) = 0;			// IndexBuffer Unlock

	virtual int GetIndexNumber( void ){			// IndexBuffer IdxCount
		return indexNumber;
	}

protected:

	// Member Variable
	int indexNumber;


};


#endif	//	_INDEXBUFFER_H_


