/***************************************************************/
//
//
//		DirectX	[ indexbufferdx9.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/23
/*---------------------------------------------------------------
Update : 2017/5/23
			Create Header File -> indexbufferdx9.h.h 
 			< Add Class Function >
				CINDEXBUFFERDX9->Constructor
				CINDEXBUFFERDX9->Destructor
				CINDEXBUFFERDX9->Create ( static member )
				CINDEXBUFFERDX9->Init
				CINDEXBUFFERDX9->Uninit
				CINDEXBUFFERDX9->Update
				CINDEXBUFFERDX9->Draw

Update : 2017/5/23



/*-------------------------------------------------------------*/
#ifndef _INDEXBUFFERDX9_H_

#define _INDEXBUFFERDX9_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "indexbuffer.h"

#include "rendererdx9.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class IndexBufferDX9 Using IndexBufferDX9
class IndexBufferDX9 : public IndexBuffer
{
public:
	
	IndexBufferDX9( );							// IndexBufferDX9 constructor
	~IndexBufferDX9( );							// IndexBufferDX9 destructor

	static IndexBufferDX9* Create( void );		// IndexBufferDX9 Create Instance Class
	
	bool CreateIndexBuffer(					// IndexBufferDX9 CreateVertexBuffer
		unsigned int indexNumber );

	void SetIndex( void );						// IndexBufferDX9 SetIndex
	
	void Release( void );						// IndexBufferDX9 Uninitialize
	
	void Lock( 									// IndexBufferDX9 Lock
		unsigned short** pIndex );
	
	void Unlock( void );						// IndexBufferDX9 Unlock


private:

	// Member Variable
	LPDIRECT3DINDEXBUFFER9 pIdxBuf;				// IndexBufferDX9 InterfacePointer

};


#endif	//	_INDEXBUFFERDX9_H_


