/***************************************************************/
//
//
//		DirectX	[ input.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 2/15
/*---------------------------------------------------------------
Update : 2017/2/15
			input.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

#include "window.h"
#include "input.h"

//#include "game_system.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/



/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

CInput* CInput::pInput[ INPUT_MAX ] = { };
LPDIRECTINPUT8 CInput::pDirectInput = nullptr;


// CInput Constructor
CInput::CInput( TYPE type )
{

	// Member Clear Process
	pInputDevice = nullptr;
	
	// InputDeviceTypeSettingProcess
	SetInputType( type );

	// Registration Class( Input )
	for( int index = 0; index < INPUT_MAX; index++ ){
		if( pInput[index] == NULL ){
			pInput[index] = this;
			myNumber = index;
			break;
		}
	}


}

// CInput Destructor
CInput::~CInput( )
{

	// Do Nothing!!

}

// CInput Create Instance 
CInput* CInput::Create( const char* INPUT_NAME )
{

	// Create Class Instance
	CInput* pObject;
	pObject = new CInput( TYPE_NONE );

	// Setting Class Name for Access
	strcpy( pObject->inputName, INPUT_NAME );

	return pObject;

}

// CInput Access Outside Function  
CInput* CInput::Access( const char* INPUT_NAME )
{

	// Search CInput Class
	for( int index = 0; index < INPUT_MAX; index ++ ){
		if( pInput[index] != NULL ){
			if( strcmp( pInput[index]->inputName, INPUT_NAME ) == 0 ){

				return pInput[index];
				break;
			}
		}
	}

	return 0;

}

// CInput Initialize
HRESULT CInput::Init( HINSTANCE hInstance, HWND hWnd )
{

	// Initialize Process
	HRESULT hr = S_OK;

	// Create DirectInputObject
	if(!pDirectInput){
		hr = DirectInput8Create( 
			hInstance,
			DIRECTINPUT_VERSION,
			IID_IDirectInput8,
			(void**)&pDirectInput,
			NULL);
	}

	return hr;

}

// CInput Uninitialize
void CInput::Uninit( void )
{

	// Uninitialize Process
	if( pInputDevice ){
		pInputDevice ->Unacquire( );
		pInputDevice ->Release( );
		pInputDevice = NULL;
	}

}

// CInput Update
void CInput::Update( void )
{

	// Update Process


}

// CInput Press
bool CInput::GetPress( const int& key )
{
	return false;
}

// CInput Trigger
bool CInput::GetTrigger( const int& key )
{
	return false;
}

// CInput Release
bool CInput::GetRelease( const int& key )
{
	return false;
}

// CInput Release Class All
void CInput::ReleaseAll( void )
{

	// Release CInput All
	for( int index = 0; index < INPUT_MAX; index ++ ){
		if( pInput[ index ] ){

			pInput[ index ] ->Uninit( );
			SAFE_DELETE( pInput[ index ] )
		}
	}
	
	SAFE_RELEASE( pDirectInput )

}

// CInput Update Class All
void CInput::UpdateAll( void )
{

	// Update CInput All
	for( int index = 0; index < INPUT_MAX; index ++ ){
		if( pInput[ index ] != NULL ){

			pInput[ index ] ->Update( );
		}
	}


}

// CInput SetInputDeviceType
void CInput::SetInputType( TYPE type )
{

	CInput::type = type;

}

// CInput GetInputDeviceType
CInput::TYPE CInput::GetInputType( void )
{

	return CInput::type;

}



















