//=========================================================================
//	X~NX	[ k_sumi.cpp ]
//	쐬F2017/06/05
//	쐬ҁF
//=========================================================================
#include	"k_sumi.h"
#include	"main.h"
#include	<time.h>
#include	"renderer.h"
//#include	"manager.h"
//#include	"camera.h"
#include	"light.h"

//=========================================================================
//	萔`
//=========================================================================
#define NUM_VERTEX (4)								// _
#define NUM_INDEX  (6)								// _CfbNX

//J̎dlႩꍇAύXăp[eBN
#define ROT_KAMERA_Y	( 180.0f )							
	
#define NUM_POLYGON (2)								// |S

#define TEXTURENAME "data/TEXTURE/smoke.jpg"

#define PARTICLE_LIFE ( 100 )						// GtFNg̎

#define PARTICLE_RADIUS (30)						// wi̕

#define RADIAN(arc) (((arc) * D3DX_PI ) / 180)		// WǍvZɕKv

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }

//=========================================================================
//	
//=========================================================================
void	KSumi::Init( void )
{
	srand( ( unsigned int ) time( NULL ) );

	LPDIRECT3DDEVICE9	pDevice;
	pDevice = GetDevice();


	// p[eBNp[^[
	for( int index = 0; index < PARTICLE_MAX ; index++ ){

		m_aParticle[ index ].life   = 0; 
		m_aParticle[ index ].radius = PARTICLE_RADIUS;
		m_aParticle[ index ].arc.x    = RADIAN( 10 * index );

		m_aParticle[ index ].ambientPower = D3DXVECTOR3( 0, 0 , 0 );

		m_nCountBuf[ index ] = 0;
	}

	m_nNumber = 0;

	// VERTEX_2D̐ݒ
	MakeVertex( pDevice );

		// eNX`̓ǂݍ
	if( FAILED(D3DXCreateTextureFromFile( pDevice, TEXTURENAME, &m_pTexture )))
	{
#ifdef _DEBUG
		MessageBox( NULL , "|St@Cǂݍ߂܂\n" , "ERROR[ k_sumi.cpp ]" , MB_OK | MB_ICONEXCLAMATION );		
#endif
	}

	//X~ۂp[eBN̂Ă

}
//=========================================================================
//	I
//=========================================================================
// p[eBNI
void KSumi::Uninit( void )
{
	// eNX`C^[tF[X̊J
	SAFE_RELEASE( m_pTexture )

	// CfbNXobt@̊J
	SAFE_RELEASE( m_pIndexBuffer )

	// _obt@C^[tF[X̊J
	SAFE_RELEASE( m_pVtxBuffer )
}

//=========================================================================
//	XV
//=========================================================================
void	KSumi::Update( void )
{
	//X~o
	//SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	
	/*
	SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	SetParticle( D3DXVECTOR3( 0.0f , 0.0f , 0.0f) );
	*/
// zAhX
	VERTEX_3D *pVtx;


	// gpGtFNg̏
	m_nNumber = 0;


	// p[eBN̍XV
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		// gpobt@̏( {ȂʏōŝX}[gx̂߂ŏ )
		m_nCountBuf[ index ] = 0;

		if( m_aParticle[ index ].life ){


			// gpGtFNg̃JEg
			m_nCountBuf[ m_nNumber ] = index;
			m_nNumber++;
				

			{ // p[eBNp[^[̍XV


				// p[eBN݃t[̍XV
				m_aParticle[ index ].life -= 1 ;
				m_aParticle[ index ].age  += 1;

				// F̐ݒ
				m_aParticle[ index ].color.r -= m_aParticle[ index ].amountOfChangeInColor.r;
				m_aParticle[ index ].color.g -= m_aParticle[ index ].amountOfChangeInColor.g;
				m_aParticle[ index ].color.b -= m_aParticle[ index ].amountOfChangeInColor.b;
				m_aParticle[ index ].color.a -= m_aParticle[ index ].amountOfChangeInColor.a;
				if( m_aParticle[ index ].color.a < 0.0f ){
					m_aParticle[ index ].color.a = 0.0f;
				}

				/*// a̍XVƐݒ
				particle[ index ].radius -= particle[ index ].amountOfChangeInRadius;
				if( particle[ index ].radius < 0.0f ){
					particle[ index ].radius = 0.0f;
				}*/

				// x̉Z
				m_aParticle[ index ].speed.x *= m_aParticle[ index ].velocity.x;
				m_aParticle[ index ].speed.y *= m_aParticle[ index ].velocity.y;
				m_aParticle[ index ].speed.z *= m_aParticle[ index ].velocity.z;

				// p[eBN̈ړ
				m_aParticle[ index ].center.x += m_aParticle[ index ].speed.x * sinf( m_aParticle[ index ].arc.x )* cosf(m_aParticle[ index ].arc.y) ;
				m_aParticle[ index ].center.y += m_aParticle[ index ].speed.y * cosf( m_aParticle[ index ].arc.x );
				m_aParticle[ index ].center.z += m_aParticle[ index ].speed.z * sinf( m_aParticle[ index ].arc.x )* cosf(m_aParticle[ index ].arc.y)  ;

				// ͂ɂxNgϊ
				if( m_aParticle[ index ].age > 10 ){
					m_aParticle[ index ].center += m_aParticle[ index ].ambientPower;
				}


			} // -> END ( PARTICLE UPDATE )
			
		}	// if( particle[ index ].life ) -> END
	}	// for -> END


	// obt@bNzAhX擾
	m_pVtxBuffer -> Lock(0,0,(void**)&pVtx,0);

	// _̊i[
	for( int index = 0; index < m_nNumber; index++ ){

		// GtFNg̐ݒu
		SetVertexColor( pVtx, index );
		SetVertexCoord( pVtx, index );
	}

	// obt@̃AbN
	m_pVtxBuffer->Unlock();

}

//=========================================================================
//	`
//=========================================================================	
void	KSumi::Draw( void )
{
	LPDIRECT3DDEVICE9	pDevice;
	pDevice = GetDevice();

	//[h}gNX̍쐬
	D3DXMATRIX	mtxWorld , mtxRot;
	//SSsNX

	//Pʍs̍쐬
	D3DXMatrixIdentity( &mtxWorld );	//sPʍsɂ
	
	//g̏
	D3DXMATRIX	mtxKakudai;	//gs
	D3DXMatrixScaling( &mtxKakudai , 1.0f , 1.0f , 1.0f );

	//]̏
	D3DXMATRIX	mtxKaiten;	//]s
	D3DXMatrixRotationYawPitchRoll( &mtxKaiten , D3DXToRadian( ROT_KAMERA_Y ) , 0.0f , 0.0f );	
	
	D3DXMATRIX	mtxHeikou;	//sړs
	D3DXMatrixTranslation( &mtxHeikou , 0.0f , 0.0f , 0.0f );

	//s̊|Z
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKakudai );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxKaiten );	
	D3DXMatrixMultiply( &mtxWorld , &mtxWorld , &mtxHeikou );	

	//foCXɃ[hϊso^
	pDevice->SetTransform( D3DTS_WORLD , &mtxWorld );

	//r[s̍쐬
	//D3DXMATRIX	mtxView = CManager::GetCamera()->GetView();

	//foCXɃr[ϊsݒ
	//pDevice->SetTransform( D3DTS_VIEW , &mtxView);

	//pDevice->SetLight( 0, &CManager::GetLight()->GetLight() );

	//IȃCgOFFɂĂ
	pDevice->SetRenderState( D3DRS_LIGHTING , FALSE );

	pDevice ->SetRenderState( D3DRS_BLENDOP, D3DBLENDOP_REVSUBTRACT );
	pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );	
	pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	pDevice ->SetRenderState( D3DRS_ZWRITEENABLE, false );


	// Xg[
	pDevice->SetStreamSource(0,					
		m_pVtxBuffer,								// ǂ̒_obt@\ƌԂ...
		0,													// f[^̃ItZbg
		sizeof( VERTEX_3D ));								// XgChl(oCg)

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( m_pIndexBuffer );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, m_pTexture );
	
	// |S̕`
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 0, NUM_INDEX * m_nNumber, 0, NUM_POLYGON * m_nNumber );

	// ̏Ԃɖ߂
	pDevice->SetRenderState( D3DRS_BLENDOP , D3DBLENDOP_ADD); //default
	pDevice ->SetRenderState( D3DRS_ZWRITEENABLE, true );

	//pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	pDevice->SetRenderState( D3DRS_DESTBLEND,D3DBLEND_INVSRCALPHA );
}

//=========================================================================
// _̍쐬
//=========================================================================
HRESULT KSumi::MakeVertex( LPDIRECT3DDEVICE9 pDevice )
{


	VERTEX_3D *pVtx;										// zAhX
	unsigned int *pIndex;									// zCfbNXAhX


	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_3D) * NUM_VERTEX * PARTICLE_MAX,	// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,								// gp@
			FVF_VERTEX_3D,									// gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,								// obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&m_pVtxBuffer,							// i[|C^
			NULL)))
	{
		#ifdef _DEBUG
		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		#endif	// _DEBUG
		return E_FAIL;
	}


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( VERTEX_3D ) * NUM_INDEX * PARTICLE_MAX,
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX32,
		D3DPOOL_MANAGED,
		&m_pIndexBuffer,
		NULL)))
	{
	
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "ERROR[ k_sumi.cpp ]", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG
		return E_FAIL;
	}


	// obt@bNzAhX擾	
	m_pVtxBuffer -> Lock(0,0,(void**)&pVtx,0);		// GPUVRAMւ̑bN


	// _obt@[̐ݒ
	for( int index = 0; index < PARTICLE_MAX ; index++ ){


		// _W̐ݒ
		SetVertexCoord( pVtx , index );

		// _F̐ݒ
		SetVertexColor( pVtx , index );

		// _UVl̐ݒ
		SetVertexSpriteUV( pVtx , index );

		// _RHW
		pVtx[ 0 + ( NUM_VERTEX * index ) ].normal = D3DXVECTOR3(  0.0f , 0.0f , 0.0f );
		pVtx[ 1 + ( NUM_VERTEX * index ) ].normal = D3DXVECTOR3(  0.0f , 0.0f , 0.0f );
		pVtx[ 2 + ( NUM_VERTEX * index ) ].normal = D3DXVECTOR3(  0.0f , 0.0f , 0.0f );
		pVtx[ 3 + ( NUM_VERTEX * index ) ].normal = D3DXVECTOR3(  0.0f , 0.0f , 0.0f );

	}

	// obt@̃AbN
	m_pVtxBuffer->Unlock( );

	// CfbNXbNzAhX擾
	m_pIndexBuffer->Lock( 0, 0, (void**)&pIndex, 0 );


	// _W̐ݒ
	for( int index = 0; index < PARTICLE_MAX ; index++ ){

		pIndex[ 0 + ( NUM_INDEX * index ) ] = 0 + ( NUM_VERTEX * index );
		pIndex[ 1 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 2 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 3 + ( NUM_INDEX * index ) ] = 2 + ( NUM_VERTEX * index );
		pIndex[ 4 + ( NUM_INDEX * index ) ] = 1 + ( NUM_VERTEX * index );
		pIndex[ 5 + ( NUM_INDEX * index ) ] = 3 + ( NUM_VERTEX * index );

	}

	// obt@̃AbN
	m_pIndexBuffer ->Unlock( );


	return S_OK;

}

// p[eBNWݒu
void KSumi::SetVertexCoord( VERTEX_3D *pVtx , const int index )
{


	// pVtx     >> zAhX
	// arryycenter >> ǂ̔Ԗڂ̃GtFNg...


	D3DXVECTOR3 start,end;			//n_ƏI_


	// WvZparticle
	start.x = m_aParticle[ index ].center.x - m_aParticle[ index ].radius;
	start.y = m_aParticle[ index ].center.y - m_aParticle[ index ].radius;
	start.z = m_aParticle[ index ].center.z - m_aParticle[ index ].radius;
	end.x   = m_aParticle[ index ].center.x + m_aParticle[ index ].radius;
	end.y   = m_aParticle[ index ].center.y + m_aParticle[ index ].radius;
	end.z   = m_aParticle[ index ].center.z + m_aParticle[ index ].radius;

	// _W̐ݒ
	pVtx[ 0 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, start.y, start.z );
	pVtx[ 1 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   start.y, start.z );
	pVtx[ 2 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( start.x, end.y,   start.z );
	pVtx[ 3 + (index * NUM_VERTEX) ].pos = D3DXVECTOR3( end.x,   end.y,   start.z );


}

// p[eBNFύX֐
void KSumi::SetVertexColor( VERTEX_3D *pVtx , const int index )
{
	
	// ̕ύX
	pVtx[ 0 + (index * NUM_VERTEX) ].color = m_aParticle[ index ].color;
	pVtx[ 1 + (index * NUM_VERTEX) ].color = m_aParticle[ index ].color;
	pVtx[ 2 + (index * NUM_VERTEX) ].color = m_aParticle[ index ].color;
	pVtx[ 3 + (index * NUM_VERTEX) ].color = m_aParticle[ index ].color;
	

}

// p[eBNUVl̃Zbg
void KSumi::SetVertexSpriteUV( VERTEX_3D *pVtx , const int index  )
{

	pVtx[ 0 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[ 1 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[ 2 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[ 3 + (index * NUM_VERTEX) ].tex = D3DXVECTOR2( 1.0f, 1.0f );

}

// p[eBN(I[_)
void KSumi::SetParticle( const D3DXVECTOR3 center )
{


	//srand( ( unsigned int ) time( NULL ) );

	// GtFNg̐ݒu
	for( int index = 0; index < PARTICLE_MAX; index++ ){

		if( !m_aParticle[ index ].life ){
			

			{ // p[eBNp[^[̐ݒ


				// p[eBNSW
				m_aParticle[ index ].center   =  center;

				// p[eBN̑x
				m_aParticle[ index ].speed    =  D3DXVECTOR3( 0.5f, 0.5f , 0.5f ); 

				// p[eBN̉x
				m_aParticle[ index ].velocity =
				D3DXVECTOR3( 1.0f + ((( rand( )%200 ) - 100  ) * 0.001f ), 1.0f + ((( rand( )%200 ) - 100  ) * 0.001f ) , 1.0f + ((( rand( )%200 ) - 100  ) * 0.001f ) ); 

				// p[eBNړ̐ݒ
				m_aParticle[ index ].arc.x      =  (( rand( )%628 ) - 314 ) * 0.01f;
				m_aParticle[ index ].arc.y      =  (( rand( )%628 ) - 314 ) * 0.01f;

				// p[eBNF
				m_aParticle[ index ].color    =  D3DXCOLOR( rand()%50 * 0.02f, rand()%50 * 0.02f, rand()%50 * 0.02f , 1.0f );

				// p[eBNa
				m_aParticle[ index ].radius   =  rand( )%100 + 5;

				// p[eBN̑݃t[
				m_aParticle[ index ].life     =  rand( )%100 + 200;

				// p[eBNωʒ萔
				m_aParticle[ index ].amountOfChangeInColor.a  = m_aParticle[ index ].color.a / m_aParticle[ index ].life;
				m_aParticle[ index ].amountOfChangeInColor.r  = m_aParticle[ index ].color.r / m_aParticle[ index ].life;
				m_aParticle[ index ].amountOfChangeInColor.g  = m_aParticle[ index ].color.g / m_aParticle[ index ].life;
				m_aParticle[ index ].amountOfChangeInColor.b  = m_aParticle[ index ].color.b / m_aParticle[ index ].life;
				m_aParticle[ index ].amountOfChangeInRadius   = (m_aParticle[ index ].radius - 10) / m_aParticle[ index ].life;
				
			
			} // -> END ( PARTICLE SET )

			break;

		}
	}

}
