/***************************************************************/
//
//
//		DirectX	[ keyboard.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/27
/*---------------------------------------------------------------
Update : 2017/2/27
			Create Header File -> inputkeyboard.h.h 
 			< Add Class Function >
				CInputKeyboard->Constructor
				CInputKeyboard->Destructor
				CInputKeyboard->Create ( static member )
				CInputKeyboard->Access ( static member )
				CInputKeyboard->Init
				CInputKeyboard->Uninit
				CInputKeyboard->Update
				CInputKeyboard->ReleaseAll ( static member )
				CInputKeyboard->UpdateAll  ( static member )
				CInputKeyboard->DrawAll    ( static member )

Update : 2017/2/27



/*-------------------------------------------------------------*/
#ifndef _KEYBOARD_H_

#define _KEYBOARD_H_

#include "input.h"

#define INPUTKEYBOARD_MAX (2)
#define STRING_MAX (32)

#define	NUM_KEY_MAX			(256)	// L[̍ő吔
#define	LIMIT_COUNT_REPEAT	( 5 )	// s[gJEg~b^[

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CInputKeyboard Using InputKeyboard
class CInputKeyboard : public CInput
{
public:
	CInputKeyboard( );							// CInputKeyboard constructor
	~CInputKeyboard( );							// CInputKeyboard destructor

	static CInputKeyboard* Create( 				// CInputKeyboard Create Instance Class
		const char* INPUTKEYBOARD_NAME );
	static void ReleaseAll( void );				// CInputKeyboard Class Release All 
	static CInputKeyboard* Access(				// CInputKeyboard Class Access Outside Function 
		const char* INPUTKEYBOARD_NAME );
	static CInputKeyboard* Access(				// CInputKeyboard Class Access Outside Function
		const int index = 0 );

	virtual HRESULT Init(						// CInputKeyboard Initialize 
		HINSTANCE hInstance,
		HWND hWnd);	
	virtual void Uninit( void );				// CInputKeyboard Uninitialize
	virtual void Update( void );				// CInputKeyboard Update

	static void UpdateAll( void );				// CInputKeyboard Update Class All

	BOOL GetKeyPress(int nKey);
	BOOL GetKeyTrigger(int nKey);
	BOOL GetKeyRelease(int nKey);
	BOOL GetKeyRepeat(int nKey);
	void FlushKeyTrigger(int nKey);


private:

	// InputKeyboard Member 
	int  myNumber;

	// static Member
	static CInputKeyboard* pInputKeyboard[ INPUTKEYBOARD_MAX ];

	BYTE	m_aKeyState[NUM_KEY_MAX];			// L[{[h̏Ԃ󂯎郏[N
	BYTE	m_aKeyStateTrigger[NUM_KEY_MAX];	// gK[[N
	BYTE	m_aKeyStateRelease[NUM_KEY_MAX];	// [X[N
	BYTE	m_aKeyStateRepeat[NUM_KEY_MAX];		// s[g[N
	int		m_aKeyStateRepeatCnt[NUM_KEY_MAX];	// s[gJE^

};



#endif	//	_KEYBOARD_H_


